/*
 * String pointer manipulation routines.
 * $Id: strpos.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/string.h>

char	*tail(const char *tail)
{
	if(!tail)
		return NULL;

	while(*tail)
		++tail;
	
	return (char *)tail;
}

char *left(char *str, size_t pos)
{
        if(!str)
                return NULL;

        if(pos < strlen(str))
                str[pos] = 0;

        return str;
};

char	*right(char *s, size_t l)
{
	size_t	len;
	
	if(!s)
		return NULL;
		
	len = strlen(s);
	if(len <= l)
		return s;
	
	return s + len - l;
}
	
		
