/*
 * Portable string handling routines.
 * $Id: strcvt.h 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#ifndef	__OTHER_STRCVT_H__
#define	__OTHER_STRCVT_H__

#ifndef	__STD_STRING_H__
#include <std/string.h>
#endif

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef	__NAMESPACE
#define	__SPACES	__NAMESPACE(__SPACES)
#endif

extern	char	__SPACES[];

#ifdef	__NAMESPACE
#define	atob		__NAMESPACE(atob)
#define	strint		__NAMESPACE(strint)
#define	picture		__NAMESPACE(picture)
#define	expand		__NAMESPACE(expand)
#define	xdigit		__NAMESPACE(xdigit)
#define	xtol		__NAMESPACE(xtol)
#define	hex		__NAMESPACE(hex)
#define	hexbyte		__NAMESPACE(hexbyte)
#define	hexshort	__NAMESPACE(hexshort)
#define	hexlong		__NAMESPACE(hexlong)
#define	str2bcd		__NAMESPACE(str2bcd)
#define	bcd2str		__NAMESPACE(bcd2str)
#endif

bool 	atob(const char *str);
char 	*strint(long i, int z);
char 	*picture(char *buf, const char *pict, long value);
char 	*expand(const char *str);
int	xdigit(char digit);
ulong	xtol(const char *digit);
char	hex(int value);
char 	*hexbyte(uchar);
char	*hexshort(ushort);
char	*hexlong(ulong);
char	*str2bcd(uchar *bcd, char *str, int max);
uchar	*bcd2str(char *str, uchar *bcd, int len);
#ifdef	__cplusplus
}
#endif

#endif
