/*
 * String formatting of numeric data.
 * $Id: picture.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <std/string.h>

char	*picture(char *buf, const char *pict, long value)
{
	char	*bp = buf, *tp;
	long	shift = 0;
	int	sign = 0;
	int	zfill = 0;
	int	digit;
	int	currency = 0;
	int	digits = 0;
	
	if(value < 0)
	{
		++sign;
		value = -value;
	}
	
	while(*pict)
	{
		switch(*pict)
		{
		case '$':
			++currency;
			*(bp++) = ' ';
			++pict;
			break;
		case '+':
			if(sign)
				*(bp++) = ' ';
			else
				*(bp++) = '+';
			++pict;
			break;
		case '-':
			if(sign)
				*(bp++) = '-';
			else
				*(bp++) = ' ';
			++pict;
			break;
		case '9':
		case '0':
			shift *= 10;
			if(!shift)
				shift = 1;
		default:
			*(bp++) = *(pict++);
		}
	}
	if(value >= shift * 10)
	{				
		bp = buf;
		while(*bp)
		{
			if(isdigit(*bp))
				*bp = '#';
			++bp;
		}
		return buf;
	}
	bp = tp = buf;
	while(*bp)
	{
		switch(*bp)
		{
		case ',':
			if(*(bp - 1) == '#')
			{
				*bp = '#';
				break;
			}
			if(!zfill)
				*bp = ' ';
			break;
		case '#':
			if(!digits)
				if(shift > value)
					break;	
		case '0':
			++zfill;
		case '9':
			++digits;
			digit = (int)(value / shift);
			if((digit > 0) || (shift == 1))
				++zfill;
			if(!zfill && !digit)
				digit = (int)(' ' - '0');				
			*bp = (char)('0' + digit);
			if(isdigit(*bp) && currency)
			{
				currency = 0;
				*(tp - 1) = '$';
			}
			value %= shift;
			shift /= 10;
		}
		if(*bp != '#')
			*(tp++) = *bp;
		++bp;
	}
	*tp = 0;
	return buf;
}
				
