/*
 * Copy strings and objects into a memory pool.
 * $Id: memreq.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/memory.h>
#include <std/math.h>

static	void	*memrequest(MEMPOOL *mem, MEMPAGE *page, size_t len)
{	
	int	psize = mem->mem_psize;
	void	*obj;

	/* align objects to ptr field size */

	len = align(len, __OBJALIGN);

	if(len > mem->mem_psize)
		return (*mem->mem_pfault)(mem, len);

	while(page)
	{
		if(page->page_used + len <= psize)	
		{
			obj = &page->page[page->page_used];
			page->page_used += len;
			return obj;
		}
		page = page->page_next;
	}
	
	if(mem->mem_pused >= mem->mem_pcount)
		return (*mem->mem_pfault)(mem, len);
		
	++mem->mem_pused;
	page = (MEMPAGE *)malloc(psize + sizeof(MEMPAGE));
	if(!page)
		return (*mem->mem_pfault)(mem, len);
	
	mem->mem_last->page_next = page;
	mem->mem_last = page;	
	page->page_used = len;
	page->page_next = NULL;
	return page->page;	
}

void	*memlreq(MEMPOOL *mem, size_t len)
{
	return memrequest(mem, mem->mem_last, len);
}

void	*memreq(MEMPOOL *mem, size_t len)
{
	return memrequest(mem, memfirst(mem), len);
} 
	

