/*
 * Portable memory manipulation and management routines.
 * $Id: memory.h 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#ifndef __OTHER_MEMORY_H__
#define __OTHER_MEMORY_H__

#ifndef __STD_TYPES_H__
#include <std/types.h>
#endif

#ifndef	MEMORY_H_MISSING
#include <memory.h>
#endif

#ifndef	__MEMALIGN
#define	__MEMALIGN	sizeof(ptr_t)
#endif

#ifndef	__OBJALIGN
#define	__OBJALIGN	__MEMALIGN
#endif

struct	_mempool;
struct	_mempage;
struct	_memfree;
struct	_memcell;

typedef struct _mempool
{
        int     mem_psize;
        int     mem_pcount;
        int     mem_pused;
        void    *(*mem_pfault)(struct _mempool *mem, int reqsize);
	struct	_memfree *mem_free;
        struct	_mempage *mem_reuse;
        struct	_mempage *mem_last;
}       MEMPOOL;

typedef struct _mempage
{
        struct	_mempage *page_next;
        int     page_used;
	uchar	page[ EMPTY ];
}       MEMPAGE;

typedef struct _memfree
{
        struct	_memfree *next;
        struct  _memcell *list;
        int     size;
}       _MEMFREE;

typedef	struct	_memcell
{
	void	*next;
}	_MEMCELL;

#define memfault(mem, fault)    mem->mem_pfault = fault;
#define memfirst(mem)           ((MEMPAGE *)((char *)(mem) - sizeof(MEMPAGE)))

#ifdef __cplusplus
extern "C" {
#endif

#ifdef	__NAMESPACE
#define	mempool		__NAMESPACE(mempool)
#define	memreuse 	__NAMESPACE(memreuse)
#define	memrelease	__NAMESPACE(memrelease)
#define	memreq		__NAMESPACE(memreq)
#define	memlreq		__NAMESPACE(memlreq)
#define	strreq		__NAMESPACE(strreq)
#define	strlreq		__NAMESPACE(strlreq)
#define	memdup		__NAMESPACE(memdup)
#define	memalloc	__NAMESPACE(memalloc)
#define	memfree		__NAMESPACE(memfree)
#endif

MEMPOOL *mempool(int psize, int pcount);
void 	memreuse(MEMPOOL *mem);
void    memrelease(MEMPOOL *mem);
void    *memreq(MEMPOOL *mem, size_t memsize);
void    *memlreq(MEMPOOL *mem, size_t memsize);
char    *strreq(MEMPOOL *mem, const char *str);
char    *strlreq(MEMPOOL *mem, const char *str);
void	*memdup(void *, size_t);

/* more advanced allocation schemes */

void    *memalloc(MEMPOOL *mem, int memsize);
void    memfree(MEMPOOL *mem, void *obj, int memsize);

#ifdef	__cplusplus
}
#endif

#endif



