/*
 * Advanced memory pool allocation scheme.
 * $Id: memalloc.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse consult product license.
 */

#include <other/memory.h>
#include <std/math.h>

void	*memalloc(MEMPOOL *mem, int len)
{
	_MEMFREE *free = mem->mem_free;
	_MEMCELL *cell = NULL;
	
	len = align(len, __OBJALIGN);

	while(free)
	{
		if(free->size == len)
		{
			cell = free->list;
			break;
		}
		free = free->next;
	}
	
	if(cell)
	{
		free->list = cell->next;
		return cell;
	}

	return memreq(mem, len);
}
