/*
 * Create and bind a udp socket for a server.
 * $Id: udpsocket.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <net/socket.h>

SOCKET	udpsocket(char *mask, int port)
{
	SOCKET	so;
	struct	sockaddr_in	saddr;
	struct	in_addr *aptr;
	
	so = socket(AF_INET, SOCK_DGRAM, 0);
	if(so == INVALID_SOCKET)
		return so;

	saddr.sin_family =  AF_INET;
	saddr.sin_port = htons(port);
	aptr = getnetaddr(mask);
	if(!aptr)
	{
		endsocket(so);
		return INVALID_SOCKET;
	}
	saddr.sin_addr = *aptr;		
		
	if(bind(so, (struct sockaddr *)&saddr, sizeof(saddr)))
	{
		endsocket(so);
		return INVALID_SOCKET;
	}
	return so;
}
