/*
 * Generic snmp trap generation routine.
 * $Id: snmptrap.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <net/trap.h>
#include <std/string.h>

int	snmptrap(char *host, char *agent, char *community, int id, char *enterprise, char *describe, long ut)
{
	static	uchar	sysvar[] = {0x06, 0x08, 0x2b, 0x06, 0x01, 0x02, 0x01, 0x01, 0x01, 0x00, 0x04};
	
	uchar	pkt[256] = {0x30, 0x82, 0x00, 0x00, 0x02, 0x01, 0x00, 0x04};
	char	console[129];
	int	len;
	int	pos;
	int	l1 = 45;
	int	l2 = 39;
	int	l3 = 16;
	int	l2pos;
	int	l3pos;
	int	v1;
	char	*p;
	int	v2;
	ulong	hostip;
	struct	hostent *hp;
	struct	sockaddr_in target;
	struct	in_addr *aptr;
	int	i1, i2;
	SOCKET	so;	
	
	if(!describe)
		describe = "";
			
	if(!host)
		host = "localhost";
	
	if(!agent)
		agent = "localhost";

	hp = gethost(agent);
	if(!hp)
		return -1;

	while( (aptr = (struct in_addr *)*(hp->h_addr_list)++) != NULL)
		memcpy(&hostip, aptr, 4);
	
	if(!community)
		community = "PUBLIC";
	
	if(!enterprise)
		enterprise = "1.3.6.1.4.1.3.1.1";	

			
	so = socket(AF_INET, SOCK_DGRAM, 0);	
	if(so == INVALID_SOCKET)
		return -1;

	len = strlen(community);
	l1 = l1 + len + 1;
	pkt[8] = (uchar)len;
	strcpy((char *)pkt + 9, community);
	pos = 9 + len;
	pkt[pos++] = 0xa4;
	l2pos = pos++;
	pkt[pos++] = 0x06;
	len = 0;

	v1 = atoi(enterprise);
	enterprise = strchr(enterprise, '.');
	v2 = atoi(++enterprise);
	len = 1;
	pkt[pos + len] = (uchar)(v1 * 40 + v2);
	
	while(NULL !=(enterprise = strchr(enterprise, '.')))
		pkt[pos + (++len)] = (uchar)atoi(++enterprise);
	
	pkt[pos] = len;
	pos += len + 1;
	l1 += len;
	l2 += len;
	
	pkt[pos++] = 0x40;
	pkt[pos++] = 0x04;
	memcpy(pkt + pos, &hostip, 4);
	pos += 4;
	
	i2 = 0;
	i1 = id;
	if(id > 5 || id < 0)
	{
		i1 = 6;
		i2 = abs(id);
	}
	
	pkt[pos++] = 0x02;
	pkt[pos++] = 0x01;
	pkt[pos++] = (uchar)i1;
	pkt[pos++] = 0x02;
	if(i2 > -1 && i2 < 128)
	{
		pkt[pos++] = 0x01;
		pkt[pos++] = (uchar)i2;
	}
	else
	{
		pkt[pos++] = 0x02;
		pkt[pos++] = (uchar)(i2 / 256);
		pkt[pos++] = (uchar)(i2 % 256);
		++l1;
		++l2;
	}	
	pkt[pos++] = 0x43;
	pkt[pos++] = 0x03;
	pkt[pos++] = (uchar)((ut / 0x10000) % 256);
	pkt[pos++] = (uchar)((ut / 0x100) % 256);
	pkt[pos++] = (uchar)(ut % 256);
	pkt[pos++] = 0x30;
	pkt[pos++] = 0x82;
	pkt[pos++] = 0;
	l3pos = pos++;
	
	len = strlen(describe);
	pkt[pos++] = 0x30;
	pkt[pos++] = 0x82;
	pkt[pos++] = 0x00;
	pkt[pos++] = len + 12;
	memcpy(pkt + pos, sysvar, 11);
	pos += 11;
	pkt[pos++] = (uchar)len;
	strcpy((char *)pkt + pos, describe);
	
	l1 += len;
	l2 += len;
	l3 += len;
	pos += len;
	 
	pkt[2] = (uchar)(l1 / 256);
	pkt[3] = (uchar)(l1 % 256);
	pkt[l2pos] = (uchar)l2;
	pkt[l3pos] = (uchar)l3;	
	

	strcpy(console, host);
	host = strtok(console, ":\t; \t\n");
	while(NULL != host)
	{
		hp = gethost(host);
		if(!hp)
			return -1;
		
		while( (aptr = (struct in_addr *)*(hp->h_addr_list)++) != NULL)
			target.sin_addr = *aptr;

		target.sin_family = hp->h_addrtype;
		target.sin_port = htons(SNMP_TRAP_PORT);
		host = strtok(NULL, ":\t;");
		sendto(so, pkt, pos, 0, (struct sockaddr *)&target, sizeof(struct sockaddr));
	}
	endsocket(so);	
	return 0;
}
	
