/*
 * Portable network messaging routines.
 * $Id: msgport.h 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#ifndef	__NET_MSGPORT_H__
#define	__NET_MSGPORT_H__

#ifndef	__NET_SOCKET_H__
#include <net/socket.h>
#endif

typedef	struct
{
	union
	{
		struct	sockaddr_in	addr;
		long	len;
	}	header;
	ushort	sequence;
	uchar	body[ EMPTY ];
}	SOCKMSG;

/*	msgport control options */

enum
{
	MSGPORT_TIMEOUT
};

#define	attach_tcp(host, port)	getsocket(host, port, SOCK_STREAM)
#define	attach_udp(host, port)	getsocket(host, port, SOCK_DGRAM)

#ifdef	__NAMESPACE
#define	create_msgport	__NAMESPACE(create_msgport)
#define	send_msgport	__NAMESPACE(send_msgport)
#define	recv_msgport	__NAMESPACE(recv_msgport)
#define	reply_msgport	__NAMESPACE(reply_msgport)
#endif

SOCKET	create_msgport(char *mask, int port, int backlog);
size_t	send_msgport(SOCKET so, SOCKMSG *buf, size_t len, bool inc);
size_t	recv_msgport(SOCKET so, SOCKMSG *buf, size_t maxlen, bool any);
size_t	reply_msgport(SOCKET so, SOCKMSG *buf, SOCKMSG *org, size_t len);
#endif
