#include <net/socket.h>
#include <std/string.h>

SOCKET	getsocket(const char *host, int port, int socktype)
{
	SOCKET	so;
	struct	hostent	*hp;
	struct	sockaddr_in saddr;
	struct	in_addr	*aptr;
	char	*sp, *p;
	char	*dup = strdup(host);

	so = socket(AF_INET, socktype, 0);
	if(so == INVALID_SOCKET)
	{
		free(dup);
		return so;
	}

	sp = dup;	
	while(NULL != (p = strtok(sp, " ;:\t")))
	{
		sp = NULL;
		hp = gethost(p);
		if(!hp)
			continue;
		
		saddr.sin_family = hp->h_addrtype;
		saddr.sin_port = htons(port);
		while( (aptr = (struct in_addr *)*(hp->h_addr_list)++) != NULL)
			saddr.sin_addr = *aptr;
	
		if(connect(so, (struct sockaddr *)&saddr, sizeof(saddr)))
			continue;
		
		free(dup);
		return so;
	}
	endsocket(so);
	free(dup);
	return INVALID_SOCKET;
}
 
