/*
 * Simple portable service name lookup.
 * $Id: getservice.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <net/socket.h>
#include <std/string.h>

int	getservice(const char *service)
{
	char	servname[32];
	char	*p;
	struct	servent *svc;
	struct	protoent *proto;
	
	if(isdigit(*service))
		return atoi(service);
		
	strcpy(servname, service);
	p = strchr(servname, '/');
	if(!p)
		strcat(servname, "/tcp");
		
	p = strchr(servname, '/');
	*(p++) = 0;
	if(isdigit(*p))
	{
		proto = getprotobynumber(atoi(p));
		if(!proto)
			return 0;
		
			p = proto->p_name;
	}
	svc = getservbyname(servname, p);
	if(!svc)
		return 0;
	
	return ntohs(svc->s_port);
}

	
	
	
