/*
 * Portable and simple host name lookup fuction.
 * $Id: gethost.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <net/socket.h>

struct	hostent	*gethost(const char *hostname)
{
	static	struct	in_addr	saddr;
	struct	hostent *hp;
	static	struct	hostent	np;
	static	char	host[24];
	static	char	*alias[] = {NULL};
	static	struct	in_addr	*alist[] = {&saddr, NULL};

	if(!hostname)
		return NULL;

	if(isdigit(*hostname))
	{
		saddr.s_addr = inet_addr(hostname);
		hp = gethostbyaddr((void *)&saddr, sizeof(struct in_addr), AF_INET);
		if(hp)
			return hp;
			
		strcpy(host, hostname);
		np.h_name = host;
		np.h_aliases = alias;
		np.h_addrtype = AF_INET;
		np.h_length = 4;
		np.h_addr_list = (char **)alist;
		return &np;
	}
	else
		return gethostbyname(hostname);
}
