/*GPL*START*
 * 
 * Copyright (C) 1998 by Johannes Overmann <overmann@iname.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * *GPL*END*/  

#ifndef _ngw_tregex_h_
#define _ngw_tregex_h_

#include <sys/types.h>
#include <regex.h>

#include "tarray.h"
#include "tstring.h"

// POSIX regular expression interface as a class

// 1997:
// 03:00 Jul 04 created from 'rtest.cc', tested, usable
// 03:00 Jul 11 added substring match and substitution
// 21:00 Sep 04 added preserve case

// 1998:
// 22:38 Aug 05 added progmode (number and stderr)

// 1999: 
// 14:58 Jan 31 added pre/post_padstring for highlighting (h=106, cc=237)
// 20:58 Oct 14 fixed parameterSubstitution(): in and out may now be the same string



class TRegEx {
 public:
   // ctor & dtor
   // cflags: REG_EXTENDED, REG_ICASE, REG_NOSUB, REG_NEWLINE
   TRegEx(const char *regex, int cflags);
   ~TRegEx();
   
   // error reporting:
   
   // return true if error
   bool error() const {return _error!=0;}
   // return error string
   TString errorToStr() const;
   // exit on error and print error
   void exitOnError() const;

   // matching:
   // eflags: REG_NOTBOL, REG_NOTEOL
   
   // return true if str matches the regex
   bool match(const char *str, int eflags=0) const;
   // return true if str matches the regex and set position
   bool firstMatch(const char *str, int& start, int& len, int eflags=0) const;
   // return true if str matches the regex and return all positions
   // in all: all[0]=start1, all[1]=len1, all[2]=start2, all[3]=len2, ...
   bool allMatches(const char *str, TArray<int>& all, int eflags=0) const;
   // same as above but also recognize substrings in all
   bool allMatchesSubstring(const char *str, TArray<TArray<int> >& all, 
			    int eflags=0, int progress=0, int progmode=0) const;

   // constants for allMatchesSubstring(..., progmode)
   // default: print '.' to stdout
   // P_STDERR: print to stderr
   // P_NUMBER: print number instead of a '.'
   enum {P_STDERR=1, P_NUMBER=2};
   
 private: // private data
   static const int MAX_SUBSTRING;
   
   regex_t preg;
   int _error; // compile error
   bool nosub;
   TString regstr;
   
   // forbid default copy and assignment
   TRegEx(const TRegEx&);                  
   const TRegEx& operator=(const TRegEx&);    
};


// substitute occurences occ in string with sub and write to out
// and use back references in sub from occ (\0 .. \9 \a .. \z)
void parameterSubstitution(const TString& in, TString& out, const TString& sub,
			   const TArray<TArray<int> >& occ, 
			   bool preserve_case=false, int modify_case=0,
			   int progress=0, const TString& pre_padstring=TString(), 
			   const TString& post_padstring=TString(), TArray<int> *match_pos=0);


#endif
