#!/bin/sh
# Script ----------------------------------------------------------------------
# Description - Pwquery greps out a list of pattern matches from /etc/passwd
#               ; awks out the usernames then looks up each one with pwuser.
# License     - See LICENSE file for details.
#
# $Author: jayrfink $
# $Date: 2007/06/20 01:20:30 $
# $State: Exp $
#------------------------------------------------------------------------------

progname=${0##*/}
toppid=$$
results=/dev/null
trap "exit 1" 1 2 3 15

bomb()
{
    cat >&2 <<ERRORMESSAGE

ERROR: $@
*** ${progname} aborted ***
ERRORMESSAGE
    kill ${toppid}
    exit 1
}

usage()
{
	cat <<_usage_
Usage: ${progname} [pattern]
_usage_
}

if [ $# -eq 0 ]; then
	echo "No pattern specified"
	usage
	exit 1
fi

pattern=$1

match_list=$(grep $pattern /etc/passwd | awk '{print  $1}')

for match in $match_list ; do
	match="${match//:/ }"
	match=$(echo ${match} | awk '{print $1}' 2>/dev/null)
	pwuser $match
	echo " "
done



exit 
