#!/bin/sh
# Script ----------------------------------------------------------------------
# Description - Pwgrps prints out all of the groups a particular user is in.
# License     - See LICENSE file for details.
#
# $Author: jayrfink $
# $Date: 2007/05/31 23:33:45 $
# $State: Exp $
#------------------------------------------------------------------------------


progname=${0##*/}
toppid=$$
results=/dev/null
trap "exit 1" 1 2 3 15

bomb()
{
    cat >&2 <<ERRORMESSAGE

ERROR: $@
*** ${progname} aborted ***
ERRORMESSAGE
    kill ${toppid}
    exit 1
}

usage()
{
	cat <<_usage_
Usage: ${progname} [arg1 arg2 arg3...]
Usage: ${progname} [user1 user2 user3...]
Usage: ${progname} usage
_usage_
}

if [ $# -eq 0 ];then
	echo "No command or username specified"
	usage
	exit 1
fi

for i in $@
do
	if [ "$i" = 'usage' ];then
		usage
		exit 0
	fi

	grouplist=$(id -Gn $i 2>/dev/null)
	echo "$i is in: ${grouplist}"
done

exit 0
