#!/bin/sh

# Install steps
# -unzip code, deps, sbcl to a folder (done by user)

echo "Installing Paragent..."

DIR=`pwd`


# Install other programs that we need
echo " Installing requirements..."

echo "  Installing mysql..."
yum -y install mysql
yum -y install mysql-server
yum -y install mysql-devel

cp /etc/my.cnf /etc/my.cnf.old
echo '[mysqld]
datadir=/var/lib/mysql
socket=/var/lib/mysql/mysql.sock
user=mysql
# Default to using old password format for compatibility with mysql 3.x
# clients (those using the mysqlclient10 compatibility package).
old_passwords=1
lower_case_table_names=1

[mysqld_safe]
log-error=/var/log/mysqld.log
pid-file=/var/run/mysqld/mysqld.pid' > /etc/my.cnf



/etc/init.d/mysqld start

echo "  Installing apache..."
yum -y install httpd
yum -y install httpd-devel

# Create mysql database
echo " Initializing Database..."
mysql < create.sql
mysql pylon < repos/db/schema.sql
mysql pylon < data.sql


# Install mod_lisp
echo " Installing mod_lisp..."

/usr/sbin/apxs -ica mod_lisp/mod_lisp2.c


# Edit httpd.conf
echo "

#
# mod_lisp2 configuration
#

<LocationMatch \"/.*\\.ucw\">
    LispServer 127.0.0.1 3001 ucw
    SetHandler lisp-handler
</LocationMatch>

<LocationMatch \"/.*\\.csv\">
    LispServer 127.0.0.1 3001 ucw
    SetHandler lisp-handler
</LocationMatch>

Alias /paragent/ \"${DIR}/repos/nexus/html/\"
" >> /etc/httpd/conf/httpd.conf


# point apache to our static files
#mv /var/www/html /var/www/html-old
#ln -s ${DIR}/repos/nexus/html /var/www/html


echo "  Restarting apache..."
/usr/sbin/apachectl restart
/sbin/chkconfig httpd on


# install detachtty
echo " Installing detachtty..."
cd ${DIR}/ucw-boxset/dependencies/detachtty
make clean
make
make install

# Hopefully open the port in the firewall
/sbin/iptables -I INPUT -p tcp --dport 6103 -j ACCEPT
/sbin/service iptables save


# Fix up some paths
echo "
(defparameter *templar-ssl-cert* \"${DIR}/repos/certs/testcert.pem\")
(defparameter *templar-ssl-key* \"${DIR}/repos/certs/testkey.pem\")
(defparameter *nexus-root* #p\"${DIR}/repos/nexus/html/\")
(defparameter *base-directory* \"${DIR}\")
" >> ${DIR}/repos/db/config.lisp



# Get our start scripts into working order
echo " Editing startup scripts..."
echo "#!/bin/sh

/usr/local/bin/detachtty --dribble-file /var/log/arbiter-dribble --log-file \\
  /var/log/detachtty.log --pid-file /var/run/arbiter.pid \\
  /var/run/arbiter-socket \\
  ${DIR}/sbcl/sbcl --core ${DIR}/sbcl/sbcl.core --userinit ${DIR}/sbcl/.sbclrc --load \"${DIR}/repos/arbiter/scripts/start.lisp\"" > ${DIR}/repos/arbiter/scripts/start-arbiter

echo "#!/bin/sh

/usr/local/bin/detachtty --dribble-file /var/log/archon-dribble --log-file \\
  /var/log/detachtty.log --pid-file /var/run/archon.pid \\
  /var/run/archon-socket \\
  ${DIR}/sbcl/sbcl --core ${DIR}/sbcl/sbcl.core --userinit ${DIR}/sbcl/.sbclrc --load \"${DIR}/repos/archon/scripts/start.lisp\"" > ${DIR}/repos/archon/scripts/start-archon

echo "#!/bin/sh

/usr/local/bin/detachtty --dribble-file /var/log/nexus-dribble --log-file \\
  /var/log/detachtty.log --pid-file /var/run/nexus.pid \\
  /var/run/nexus-socket \\
  ${DIR}/sbcl/sbcl --core ${DIR}/sbcl/sbcl.core --userinit ${DIR}/sbcl/.sbclrc --load \"${DIR}/repos/nexus/scripts/start.lisp\"" > ${DIR}/repos/nexus/scripts/start-nexus

echo "(require 'asdf)
(require 'asdf-binary-locations)

(load \"${DIR}/ucw-boxset/start\")
;(setf ucw:*debug-on-error* t)
(asdf:oos 'asdf:load-op 'nexus)" > ${DIR}/repos/nexus/scripts/start.lisp


# Set everyone to run at startup
echo "

${DIR}/repos/arbiter/scripts/start-arbiter
${DIR}/repos/archon/scripts/start-archon
${DIR}/repos/nexus/scripts/start-nexus" >> /etc/rc.d/rc.local


# Run them now
${DIR}/repos/arbiter/scripts/start-arbiter
${DIR}/repos/archon/scripts/start-archon
${DIR}/repos/nexus/scripts/start-nexus


# Prep the agent
echo " Generating agent"

ACTIVE_INTERFACE=`/sbin/ifconfig | grep eth | awk '{print $1}'`
IP_ADDRESS=`/sbin/ifconfig $ACTIVE_INTERFACE | grep 'inet addr' | awk '{print $2}' | sed 's/addr://'`

echo "(
 (server \"${IP_ADDRESS}:6103\")
)" > ${DIR}/repos/nexus/html/Templar/settings.dat

cd ${DIR}/repos/nexus/html/
zip -r Templar.zip Templar

echo "Done!"


echo ""
echo '***************************'
echo "Paragent is now installed."
echo 'Go to http://localhost/paragent/main.ucw and log in (username: admin, password: admin)'
echo ""

