(in-package :ucw-intro)

(defcomponent timeline (widget-component)
  ((history :initarg :history :accessor history))
  (:render () (<:as-html (history timeline))))

(defcomponent drawer (widget-component)
  ((contents :initarg :contents :accessor contents))
  (:render () (<:as-html (contents drawer))))

(defcomponent office (simple-window-component)
  ((what-happened :initform '(0 0 0) :accessor what-happened)
   (closet :component (switching-container
                       :current-component-key 'in-office
                       :contents
                       `((in-office       . ,(make-instance 'timeline :history "You stand alone in the office of your evil boss. In front of you you see a closet in which you are sure you will find valuables with which you can pay off your insurmountable debts."))
                         (top-drawer    . ,(make-instance 'drawer
                                                          :contents "you find memoirs of a broken soul"))
                         (middle-drawer . ,(make-instance 'drawer
                                                          :contents "you find an agenda of grinding daily chores"))
                         (bottom-drawer . ,(make-instance 'drawer
                                                          :contents "you find an ointment to take the edge off"))))
           :accessor closet))
  (:render ()
           (with-slots (what-happened closet)
               office
             (unless (find-component closet 'leave) 
               (case (container.current-component-key closet)
                 ('top-drawer (setf (car what-happened) 1))
                 ('bottom-drawer (setf (cadr what-happened) 1))
                 ('middle-drawer (setf (caddr what-happened) 1)))
               (when (and (= (car what-happened) 1)
                          (= (cadr what-happened) 1)
                          (= (caddr what-happened) 1))
                 (add-component closet
                                (make-instance 'timeline :history "You leave the office ashamed and angry. You know now your evil boss is also a human being and you will have to feel compassion for him forever.")
                                'leave)))
             (render closet)
             (<:br)
             (<:as-html "What will you do next?")
             (<:br)
             (unless (eql (container.current-component-key closet) 'leave)
               (flet ((drawer-link (name text)
                        (<ucw:a :action (switch-component (closet office) name)
                                (<:as-html text))))
                 (<:ul
                  (<:li (drawer-link 'top-drawer "inspect top drawer"))
                  (<:li (drawer-link 'middle-drawer "inspect middle drawer"))
                  (<:li (drawer-link 'bottom-drawer "inspect bottom drawer"))
                  (<:li (drawer-link 'in-office "recall what your doing here"))
                  (when (find-component closet 'leave)
                    (<:li (drawer-link 'leave "leave"))))))
             (<:br)
             (<ucw:a :action (jump 'basics) "go back to where you came from"))))