(in-package :ucw-intro)

(defvar *www-root*
  (merge-pathnames
   (make-pathname :directory '(:relative "www"))
   (asdf:component-pathname (asdf:find-system :ucw-intro))))

(defparameter *ucw-intro-application*
  (make-instance 'cookie-session-application
                 :url-prefix "/ucw-intro/"
                 :www-roots (list *www-root*)
                 :tal-generator (make-instance 'yaclml:file-system-generator
                                               :cachep t
                                               :root-directories (list *www-root*))
                 :dispatchers (list (make-instance 'ucw::action-dispatcher)
                                    ;; hello world
                                    (url-dispatcher "hello-world.ucw"
                                      (call 'hello-world))
                                    ;; basics
                                    (regexp-dispatcher "^(basics.ucw|)$"
                                      (call 'basics))
                                    (regexp-dispatcher "^(get.ucw|)$"
                                      (with-request-params ((cow "moo"))
                                          (context.request *context*)
                                        (let ((cow (concatenate 'string "mighty " cow)))
                                          (call 'basics :cow cow))))
                                    ;; containers
                                    (regexp-dispatcher "^(containers.ucw|)$"
                                      (call 'office))
                                    ;; tal
                                    (regexp-dispatcher "^(tal.ucw|)$"
                                      (call 'tal-component))
                                    (regexp-dispatcher "^(more-tal.ucw|)$"
                                      (call 'more-tal))
                                    ;; tabbed-pane
                                    (regexp-dispatcher "^(pane.ucw|)$"
                                      (call 'pane)))
                 :debug-on-error t))