/*
 * Decompiled with CFR 0.152.
 */
package com.paragent.observer;

import com.paragent.observer.RfbProto;
import com.paragent.observer.VncViewer;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.Inflater;

class VncCanvas
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    VncViewer viewer;
    RfbProto rfb;
    ColorModel cm8_256c;
    ColorModel cm8_64c;
    ColorModel cm8_8c;
    ColorModel cm24;
    Color[] colors;
    int bytesPixel;
    Image memImage;
    Graphics memGraphics;
    Image rawPixelsImage;
    MemoryImageSource pixelsSource;
    byte[] pixels8;
    int[] pixels24;
    byte[] zlibBuf;
    int zlibBufLen = 0;
    Inflater zlibInflater;
    static final int tightZlibBufferSize = 512;
    Inflater[] tightInflaters;
    Rectangle jpegRect;
    boolean inputEnabled;
    private Color hextile_bg;
    private Color hextile_fg;
    boolean showSoftCursor = false;
    int[] softCursorPixels;
    MemoryImageSource softCursorSource;
    Image softCursor;
    int cursorX = 0;
    int cursorY = 0;
    int cursorWidth;
    int cursorHeight;
    int hotX;
    int hotY;

    VncCanvas(VncViewer v) throws IOException {
        this.viewer = v;
        this.rfb = this.viewer.rfb;
        this.tightInflaters = new Inflater[4];
        this.cm8_256c = new DirectColorModel(8, 7, 56, 192);
        this.cm8_64c = new DirectColorModel(8, 48, 12, 3);
        this.cm8_8c = new DirectColorModel(8, 4, 2, 1);
        this.cm24 = new DirectColorModel(24, 0xFF0000, 65280, 255);
        this.colors = new Color[256];
        int i = 0;
        while (i < 256) {
            this.colors[i] = new Color(this.cm8_256c.getRGB(i));
            ++i;
        }
        this.setPixelFormat();
        this.inputEnabled = false;
        if (!this.viewer.options.viewOnly) {
            this.enableInput(true);
        }
        this.addKeyListener(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        int y0;
        int x0;
        Rectangle r;
        Image image = this.memImage;
        synchronized (image) {
            g.drawImage(this.memImage, 0, 0, null);
        }
        if (this.showSoftCursor && (r = new Rectangle(x0 = this.cursorX - this.hotX, y0 = this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight)).intersects(g.getClipBounds())) {
            g.drawImage(this.softCursor, x0, y0, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0xA0) == 0) {
            return true;
        }
        if ((infoflags & 0x20) != 0 && this.jpegRect != null) {
            Rectangle rectangle = this.jpegRect;
            synchronized (rectangle) {
                this.memGraphics.drawImage(img, this.jpegRect.x, this.jpegRect.y, null);
                this.scheduleRepaint(this.jpegRect.x, this.jpegRect.y, this.jpegRect.width, this.jpegRect.height);
                this.jpegRect.notify();
            }
        }
        return false;
    }

    public synchronized void enableInput(boolean enable) {
        if (enable && !this.inputEnabled) {
            this.inputEnabled = true;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            if (this.viewer.showControls) {
                this.viewer.buttonPanel.enableRemoteAccessControls(true);
            }
        } else if (!enable && this.inputEnabled) {
            this.inputEnabled = false;
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            if (this.viewer.showControls) {
                this.viewer.buttonPanel.enableRemoteAccessControls(false);
            }
        }
    }

    public void setPixelFormat() throws IOException {
        if (this.viewer.options.eightBitColors > 0) {
            this.viewer.options.oldEightBitColors = this.viewer.options.eightBitColors;
            switch (this.viewer.options.eightBitColors) {
                case 1: {
                    int i = 0;
                    while (i < 256) {
                        this.colors[i] = new Color(this.cm8_256c.getRGB(i));
                        ++i;
                    }
                    this.rfb.writeSetPixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6, false);
                    break;
                }
                case 2: {
                    int i = 0;
                    while (i < 256) {
                        this.colors[i] = new Color(this.cm8_64c.getRGB(i));
                        ++i;
                    }
                    this.rfb.writeSetPixelFormat(8, 6, false, true, 3, 3, 3, 4, 2, 0, false);
                    break;
                }
                case 3: {
                    int i = 0;
                    while (i < 256) {
                        this.colors[i] = new Color(this.cm8_8c.getRGB(i));
                        ++i;
                    }
                    this.rfb.writeSetPixelFormat(8, 3, false, true, 1, 1, 1, 2, 1, 0, false);
                    break;
                }
                case 4: {
                    int i = 0;
                    while (i < 256) {
                        this.colors[i] = new Color(this.cm8_64c.getRGB(i));
                        ++i;
                    }
                    this.rfb.writeSetPixelFormat(8, 6, false, true, 3, 3, 3, 4, 2, 0, true);
                    break;
                }
                case 5: {
                    int i = 0;
                    while (i < 256) {
                        this.colors[i] = new Color(this.cm8_8c.getRGB(i));
                        ++i;
                    }
                    this.rfb.writeSetPixelFormat(8, 3, false, true, 1, 1, 1, 2, 1, 0, true);
                }
            }
            this.bytesPixel = 1;
        } else {
            this.rfb.writeSetPixelFormat(32, 24, false, true, 255, 255, 255, 16, 8, 0, false);
            this.bytesPixel = 4;
        }
        this.updateFramebufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFramebufferSize() {
        int fbWidth = this.rfb.framebufferWidth;
        int fbHeight = this.rfb.framebufferHeight;
        if (this.memImage == null) {
            this.memImage = this.viewer.createImage(fbWidth, fbHeight);
            this.memGraphics = this.memImage.getGraphics();
        } else {
            Image image = this.memImage;
            synchronized (image) {
                if (this.memImage.getWidth(null) != fbWidth || this.memImage.getHeight(null) != fbHeight) {
                    this.memImage = this.viewer.createImage(fbWidth, fbHeight);
                    this.memGraphics = this.memImage.getGraphics();
                }
            }
        }
        if (this.bytesPixel == 1) {
            this.pixels24 = null;
            this.pixels8 = new byte[fbWidth * fbHeight];
            ColorModel cml = this.cm8_8c;
            switch (this.viewer.options.eightBitColors) {
                case 1: {
                    cml = this.cm8_256c;
                    break;
                }
                case 2: 
                case 4: {
                    cml = this.cm8_64c;
                    break;
                }
                case 3: 
                case 5: {
                    cml = this.cm8_8c;
                }
            }
            this.pixelsSource = new MemoryImageSource(fbWidth, fbHeight, cml, this.pixels8, 0, fbWidth);
        } else {
            this.pixels8 = null;
            this.pixels24 = new int[fbWidth * fbHeight];
            this.pixelsSource = new MemoryImageSource(fbWidth, fbHeight, this.cm24, this.pixels24, 0, fbWidth);
        }
        this.pixelsSource.setAnimated(true);
        this.rawPixelsImage = this.createImage(this.pixelsSource);
        if (this.viewer.inSeparateFrame) {
            if (this.viewer.desktopScrollPane != null) {
                this.resizeDesktopFrame();
            }
        } else {
            this.setSize(fbWidth, fbHeight);
        }
    }

    void resizeDesktopFrame() {
        Dimension frameSize;
        this.setSize(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
        Insets insets = this.viewer.desktopScrollPane.getInsets();
        this.viewer.desktopScrollPane.setSize(this.rfb.framebufferWidth + 2 * Math.min(insets.left, insets.right), this.rfb.framebufferHeight + 2 * Math.min(insets.top, insets.bottom));
        this.viewer.vncFrame.pack();
        Dimension screenSize = this.viewer.vncFrame.getToolkit().getScreenSize();
        Dimension newSize = frameSize = this.viewer.vncFrame.getSize();
        boolean needToResizeFrame = false;
        if (frameSize.height > screenSize.height) {
            newSize.height = screenSize.height;
            needToResizeFrame = true;
        }
        if (frameSize.width > screenSize.width) {
            newSize.width = screenSize.width;
            needToResizeFrame = true;
        }
        if (needToResizeFrame) {
            this.viewer.vncFrame.setSize(newSize);
        }
        this.viewer.desktopScrollPane.doLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNormalProtocol() throws Exception {
        int msgType;
        this.viewer.checkRecordingStatus();
        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
        block22: while (true) {
            msgType = this.rfb.readServerMessageType();
            switch (msgType) {
                case 0: {
                    this.rfb.readFramebufferUpdate();
                    int i = 0;
                    while (i < this.rfb.updateNRects) {
                        this.rfb.readFramebufferUpdateRectHdr();
                        int rx = this.rfb.updateRectX;
                        int ry = this.rfb.updateRectY;
                        int rw = this.rfb.updateRectW;
                        int rh = this.rfb.updateRectH;
                        if (this.rfb.updateRectEncoding == -224) break;
                        if (this.rfb.updateRectEncoding == -223) {
                            this.rfb.setFramebufferSize(rw, rh);
                            this.updateFramebufferSize();
                            break;
                        }
                        if (this.rfb.updateRectEncoding == -240 || this.rfb.updateRectEncoding == -239) {
                            this.handleCursorShapeUpdate(this.rfb.updateRectEncoding, rx, ry, rw, rh);
                        } else {
                            switch (this.rfb.updateRectEncoding) {
                                case 0: {
                                    this.handleRawRect(rx, ry, rw, rh);
                                    break;
                                }
                                case 1: {
                                    this.handleCopyRect(rx, ry, rw, rh);
                                    break;
                                }
                                case 2: {
                                    this.handleRRERect(rx, ry, rw, rh);
                                    break;
                                }
                                case 4: {
                                    this.handleCoRRERect(rx, ry, rw, rh);
                                    break;
                                }
                                case 5: {
                                    this.handleHextileRect(rx, ry, rw, rh);
                                    break;
                                }
                                case 6: {
                                    this.handleZlibRect(rx, ry, rw, rh);
                                    break;
                                }
                                case 7: {
                                    this.handleTightRect(rx, ry, rw, rh);
                                    break;
                                }
                                case -232: {
                                    this.handleCursorPosUpdate(rx, ry);
                                    break;
                                }
                                default: {
                                    throw new Exception("Unknown RFB rectangle encoding " + this.rfb.updateRectEncoding);
                                }
                            }
                        }
                        ++i;
                    }
                    boolean fullUpdateNeeded = false;
                    if (this.viewer.checkRecordingStatus()) {
                        fullUpdateNeeded = true;
                    }
                    if (this.viewer.deferUpdateRequests > 0) {
                        RfbProto rx = this.rfb;
                        synchronized (rx) {
                            try {
                                this.rfb.wait(this.viewer.deferUpdateRequests);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.viewer.options.eightBitColors > 0 && this.bytesPixel != 1 || this.viewer.options.eightBitColors == 0 && this.bytesPixel == 1 || this.viewer.options.eightBitColors != this.viewer.options.oldEightBitColors) {
                        this.setPixelFormat();
                        fullUpdateNeeded = true;
                    }
                    this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, !fullUpdateNeeded);
                    continue block22;
                }
                case 1: {
                    throw new Exception("Can't handle SetColourMapEntries message");
                }
                case 2: {
                    Toolkit.getDefaultToolkit().beep();
                    continue block22;
                }
                case 3: {
                    String s = this.rfb.readServerCutText();
                    this.viewer.clipboard.setCutText(s);
                    continue block22;
                }
                case 7: {
                    this.viewer.rfb.readRfbFileTransferMsg();
                    continue block22;
                }
            }
            break;
        }
        throw new Exception("Unknown RFB message type " + msgType);
    }

    void handleRawRect(int x, int y, int w, int h) throws IOException {
        this.handleRawRect(x, y, w, h, true);
    }

    void handleRawRect(int x, int y, int w, int h, boolean paint) throws IOException {
        if (this.bytesPixel == 1) {
            int dy = y;
            while (dy < y + h) {
                this.rfb.is.readFully(this.pixels8, dy * this.rfb.framebufferWidth + x, w);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(this.pixels8, dy * this.rfb.framebufferWidth + x, w);
                }
                ++dy;
            }
        } else {
            byte[] buf = new byte[w * 4];
            int dy = y;
            while (dy < y + h) {
                this.rfb.is.readFully(buf);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(buf);
                }
                int offset = dy * this.rfb.framebufferWidth + x;
                int i = 0;
                while (i < w) {
                    this.pixels24[offset + i] = (buf[i * 4 + 2] & 0xFF) << 16 | (buf[i * 4 + 1] & 0xFF) << 8 | buf[i * 4] & 0xFF;
                    ++i;
                }
                ++dy;
            }
        }
        this.handleUpdatedPixels(x, y, w, h);
        if (paint) {
            this.scheduleRepaint(x, y, w, h);
        }
    }

    void handleCopyRect(int x, int y, int w, int h) throws IOException {
        this.rfb.readCopyRect();
        this.memGraphics.copyArea(this.rfb.copyRectSrcX, this.rfb.copyRectSrcY, w, h, x - this.rfb.copyRectSrcX, y - this.rfb.copyRectSrcY);
        this.scheduleRepaint(x, y, w, h);
    }

    void handleRRERect(int x, int y, int w, int h) throws IOException {
        int nSubrects = this.rfb.is.readInt();
        byte[] bg_buf = new byte[this.bytesPixel];
        this.rfb.is.readFully(bg_buf);
        Color pixel = this.bytesPixel == 1 ? this.colors[bg_buf[0] & 0xFF] : new Color(bg_buf[2] & 0xFF, bg_buf[1] & 0xFF, bg_buf[0] & 0xFF);
        this.memGraphics.setColor(pixel);
        this.memGraphics.fillRect(x, y, w, h);
        byte[] buf = new byte[nSubrects * (this.bytesPixel + 8)];
        this.rfb.is.readFully(buf);
        DataInputStream ds = new DataInputStream(new ByteArrayInputStream(buf));
        if (this.rfb.rec != null) {
            this.rfb.rec.writeIntBE(nSubrects);
            this.rfb.rec.write(bg_buf);
            this.rfb.rec.write(buf);
        }
        int j = 0;
        while (j < nSubrects) {
            if (this.bytesPixel == 1) {
                pixel = this.colors[ds.readUnsignedByte()];
            } else {
                ds.skip(4L);
                pixel = new Color(buf[j * 12 + 2] & 0xFF, buf[j * 12 + 1] & 0xFF, buf[j * 12] & 0xFF);
            }
            int sx = x + ds.readUnsignedShort();
            int sy = y + ds.readUnsignedShort();
            int sw = ds.readUnsignedShort();
            int sh = ds.readUnsignedShort();
            this.memGraphics.setColor(pixel);
            this.memGraphics.fillRect(sx, sy, sw, sh);
            ++j;
        }
        this.scheduleRepaint(x, y, w, h);
    }

    void handleCoRRERect(int x, int y, int w, int h) throws IOException {
        int nSubrects = this.rfb.is.readInt();
        byte[] bg_buf = new byte[this.bytesPixel];
        this.rfb.is.readFully(bg_buf);
        Color pixel = this.bytesPixel == 1 ? this.colors[bg_buf[0] & 0xFF] : new Color(bg_buf[2] & 0xFF, bg_buf[1] & 0xFF, bg_buf[0] & 0xFF);
        this.memGraphics.setColor(pixel);
        this.memGraphics.fillRect(x, y, w, h);
        byte[] buf = new byte[nSubrects * (this.bytesPixel + 4)];
        this.rfb.is.readFully(buf);
        if (this.rfb.rec != null) {
            this.rfb.rec.writeIntBE(nSubrects);
            this.rfb.rec.write(bg_buf);
            this.rfb.rec.write(buf);
        }
        int i = 0;
        int j = 0;
        while (j < nSubrects) {
            if (this.bytesPixel == 1) {
                pixel = this.colors[buf[i++] & 0xFF];
            } else {
                pixel = new Color(buf[i + 2] & 0xFF, buf[i + 1] & 0xFF, buf[i] & 0xFF);
                i += 4;
            }
            int sx = x + (buf[i++] & 0xFF);
            int sy = y + (buf[i++] & 0xFF);
            int sw = buf[i++] & 0xFF;
            int sh = buf[i++] & 0xFF;
            this.memGraphics.setColor(pixel);
            this.memGraphics.fillRect(sx, sy, sw, sh);
            ++j;
        }
        this.scheduleRepaint(x, y, w, h);
    }

    void handleHextileRect(int x, int y, int w, int h) throws IOException {
        this.hextile_bg = new Color(0);
        this.hextile_fg = new Color(0);
        int ty = y;
        while (ty < y + h) {
            int th = 16;
            if (y + h - ty < 16) {
                th = y + h - ty;
            }
            int tx = x;
            while (tx < x + w) {
                int tw = 16;
                if (x + w - tx < 16) {
                    tw = x + w - tx;
                }
                this.handleHextileSubrect(tx, ty, tw, th);
                tx += 16;
            }
            this.scheduleRepaint(x, y, w, h);
            ty += 16;
        }
    }

    void handleHextileSubrect(int tx, int ty, int tw, int th) throws IOException {
        int subencoding = this.rfb.is.readUnsignedByte();
        if (this.rfb.rec != null) {
            this.rfb.rec.writeByte(subencoding);
        }
        this.rfb.getClass();
        if ((subencoding & 1) != 0) {
            this.handleRawRect(tx, ty, tw, th, false);
            return;
        }
        byte[] cbuf = new byte[this.bytesPixel];
        this.rfb.getClass();
        if ((subencoding & 2) != 0) {
            this.rfb.is.readFully(cbuf);
            this.hextile_bg = this.bytesPixel == 1 ? this.colors[cbuf[0] & 0xFF] : new Color(cbuf[2] & 0xFF, cbuf[1] & 0xFF, cbuf[0] & 0xFF);
            if (this.rfb.rec != null) {
                this.rfb.rec.write(cbuf);
            }
        }
        this.memGraphics.setColor(this.hextile_bg);
        this.memGraphics.fillRect(tx, ty, tw, th);
        this.rfb.getClass();
        if ((subencoding & 4) != 0) {
            this.rfb.is.readFully(cbuf);
            this.hextile_fg = this.bytesPixel == 1 ? this.colors[cbuf[0] & 0xFF] : new Color(cbuf[2] & 0xFF, cbuf[1] & 0xFF, cbuf[0] & 0xFF);
            if (this.rfb.rec != null) {
                this.rfb.rec.write(cbuf);
            }
        }
        if ((subencoding & this.rfb.HextileAnySubrects) == 0) {
            return;
        }
        int nSubrects = this.rfb.is.readUnsignedByte();
        int bufsize = nSubrects * 2;
        if ((subencoding & this.rfb.HextileSubrectsColoured) != 0) {
            bufsize += nSubrects * this.bytesPixel;
        }
        byte[] buf = new byte[bufsize];
        this.rfb.is.readFully(buf);
        if (this.rfb.rec != null) {
            this.rfb.rec.writeByte(nSubrects);
            this.rfb.rec.write(buf);
        }
        int i = 0;
        if ((subencoding & this.rfb.HextileSubrectsColoured) == 0) {
            this.memGraphics.setColor(this.hextile_fg);
            int j = 0;
            while (j < nSubrects) {
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = tx + (b1 >> 4);
                int sy = ty + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.memGraphics.fillRect(sx, sy, sw, sh);
                ++j;
            }
        } else if (this.bytesPixel == 1) {
            int j = 0;
            while (j < nSubrects) {
                this.hextile_fg = this.colors[buf[i++] & 0xFF];
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = tx + (b1 >> 4);
                int sy = ty + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(sx, sy, sw, sh);
                ++j;
            }
        } else {
            int j = 0;
            while (j < nSubrects) {
                this.hextile_fg = new Color(buf[i + 2] & 0xFF, buf[i + 1] & 0xFF, buf[i] & 0xFF);
                i += 4;
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = tx + (b1 >> 4);
                int sy = ty + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(sx, sy, sw, sh);
                ++j;
            }
        }
    }

    void handleZlibRect(int x, int y, int w, int h) throws Exception {
        int nBytes = this.rfb.is.readInt();
        if (this.zlibBuf == null || this.zlibBufLen < nBytes) {
            this.zlibBufLen = nBytes * 2;
            this.zlibBuf = new byte[this.zlibBufLen];
        }
        this.rfb.is.readFully(this.zlibBuf, 0, nBytes);
        if (this.rfb.rec != null && this.rfb.recordFromBeginning) {
            this.rfb.rec.writeIntBE(nBytes);
            this.rfb.rec.write(this.zlibBuf, 0, nBytes);
        }
        if (this.zlibInflater == null) {
            this.zlibInflater = new Inflater();
        }
        this.zlibInflater.setInput(this.zlibBuf, 0, nBytes);
        if (this.bytesPixel == 1) {
            int dy = y;
            while (dy < y + h) {
                this.zlibInflater.inflate(this.pixels8, dy * this.rfb.framebufferWidth + x, w);
                if (this.rfb.rec != null && !this.rfb.recordFromBeginning) {
                    this.rfb.rec.write(this.pixels8, dy * this.rfb.framebufferWidth + x, w);
                }
                ++dy;
            }
        } else {
            byte[] buf = new byte[w * 4];
            int dy = y;
            while (dy < y + h) {
                this.zlibInflater.inflate(buf);
                int offset = dy * this.rfb.framebufferWidth + x;
                int i = 0;
                while (i < w) {
                    this.pixels24[offset + i] = (buf[i * 4 + 2] & 0xFF) << 16 | (buf[i * 4 + 1] & 0xFF) << 8 | buf[i * 4] & 0xFF;
                    ++i;
                }
                if (this.rfb.rec != null && !this.rfb.recordFromBeginning) {
                    this.rfb.rec.write(buf);
                }
                ++dy;
            }
        }
        this.handleUpdatedPixels(x, y, w, h);
        this.scheduleRepaint(x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTightRect(int x, int y, int w, int h) throws Exception {
        int dataSize;
        int i;
        byte[] buf;
        int comp_ctl = this.rfb.is.readUnsignedByte();
        if (this.rfb.rec != null) {
            if (this.rfb.recordFromBeginning || comp_ctl == 128 || comp_ctl == 144) {
                this.rfb.rec.writeByte(comp_ctl);
            } else {
                this.rfb.rec.writeByte(comp_ctl | 0xF);
            }
        }
        int stream_id = 0;
        while (stream_id < 4) {
            if ((comp_ctl & 1) != 0 && this.tightInflaters[stream_id] != null) {
                this.tightInflaters[stream_id] = null;
            }
            comp_ctl >>= 1;
            ++stream_id;
        }
        if (comp_ctl > 9) {
            throw new Exception("Incorrect tight subencoding: " + comp_ctl);
        }
        if (comp_ctl == 8) {
            if (this.bytesPixel == 1) {
                int idx = this.rfb.is.readUnsignedByte();
                this.memGraphics.setColor(this.colors[idx]);
                if (this.rfb.rec != null) {
                    this.rfb.rec.writeByte(idx);
                }
            } else {
                byte[] buf2 = new byte[3];
                this.rfb.is.readFully(buf2);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(buf2);
                }
                Color bg = new Color(0xFF000000 | (buf2[0] & 0xFF) << 16 | (buf2[1] & 0xFF) << 8 | buf2[2] & 0xFF);
                this.memGraphics.setColor(bg);
            }
            this.memGraphics.fillRect(x, y, w, h);
            this.scheduleRepaint(x, y, w, h);
            return;
        }
        if (comp_ctl == 9) {
            byte[] jpegData = new byte[this.rfb.readCompactLen()];
            this.rfb.is.readFully(jpegData);
            if (this.rfb.rec != null) {
                if (!this.rfb.recordFromBeginning) {
                    this.rfb.recordCompactLen(jpegData.length);
                }
                this.rfb.rec.write(jpegData);
            }
            Image jpegImage = Toolkit.getDefaultToolkit().createImage(jpegData);
            Rectangle rectangle = this.jpegRect = new Rectangle(x, y, w, h);
            synchronized (rectangle) {
                Toolkit.getDefaultToolkit().prepareImage(jpegImage, -1, -1, this);
                try {
                    this.jpegRect.wait(3000L);
                }
                catch (InterruptedException e) {
                    throw new Exception("Interrupted while decoding JPEG image");
                }
            }
            this.jpegRect = null;
            return;
        }
        int numColors = 0;
        int rowSize = w;
        byte[] palette8 = new byte[2];
        int[] palette24 = new int[256];
        boolean useGradient = false;
        if ((comp_ctl & 4) != 0) {
            int filter_id = this.rfb.is.readUnsignedByte();
            if (this.rfb.rec != null) {
                this.rfb.rec.writeByte(filter_id);
            }
            if (filter_id == 1) {
                numColors = this.rfb.is.readUnsignedByte() + 1;
                if (this.rfb.rec != null) {
                    this.rfb.rec.writeByte(numColors - 1);
                }
                if (this.bytesPixel == 1) {
                    if (numColors != 2) {
                        throw new Exception("Incorrect tight palette size: " + numColors);
                    }
                    this.rfb.is.readFully(palette8);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(palette8);
                    }
                } else {
                    buf = new byte[numColors * 3];
                    this.rfb.is.readFully(buf);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(buf);
                    }
                    i = 0;
                    while (i < numColors) {
                        palette24[i] = (buf[i * 3] & 0xFF) << 16 | (buf[i * 3 + 1] & 0xFF) << 8 | buf[i * 3 + 2] & 0xFF;
                        ++i;
                    }
                }
                if (numColors == 2) {
                    rowSize = (w + 7) / 8;
                }
            } else if (filter_id == 2) {
                useGradient = true;
            } else if (filter_id != 0) {
                throw new Exception("Incorrect tight filter id: " + filter_id);
            }
        }
        if (numColors == 0 && this.bytesPixel == 4) {
            rowSize *= 3;
        }
        if ((dataSize = h * rowSize) < 12) {
            if (numColors != 0) {
                byte[] indexedData = new byte[dataSize];
                this.rfb.is.readFully(indexedData);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(indexedData);
                }
                if (numColors == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(x, y, w, h, indexedData, palette8);
                    } else {
                        this.decodeMonoData(x, y, w, h, indexedData, palette24);
                    }
                } else {
                    i = 0;
                    int dy = y;
                    while (dy < y + h) {
                        int dx = x;
                        while (dx < x + w) {
                            this.pixels24[dy * this.rfb.framebufferWidth + dx] = palette24[indexedData[i++] & 0xFF];
                            ++dx;
                        }
                        ++dy;
                    }
                }
            } else if (useGradient) {
                buf = new byte[w * h * 3];
                this.rfb.is.readFully(buf);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(buf);
                }
                this.decodeGradientData(x, y, w, h, buf);
            } else if (this.bytesPixel == 1) {
                int dy = y;
                while (dy < y + h) {
                    this.rfb.is.readFully(this.pixels8, dy * this.rfb.framebufferWidth + x, w);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(this.pixels8, dy * this.rfb.framebufferWidth + x, w);
                    }
                    ++dy;
                }
            } else {
                buf = new byte[w * 3];
                int dy = y;
                while (dy < y + h) {
                    this.rfb.is.readFully(buf);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(buf);
                    }
                    int offset = dy * this.rfb.framebufferWidth + x;
                    i = 0;
                    while (i < w) {
                        this.pixels24[offset + i] = (buf[i * 3] & 0xFF) << 16 | (buf[i * 3 + 1] & 0xFF) << 8 | buf[i * 3 + 2] & 0xFF;
                        ++i;
                    }
                    ++dy;
                }
            }
        } else {
            int stream_id2;
            int zlibDataLen = this.rfb.readCompactLen();
            byte[] zlibData = new byte[zlibDataLen];
            this.rfb.is.readFully(zlibData);
            if (this.rfb.rec != null && this.rfb.recordFromBeginning) {
                this.rfb.rec.write(zlibData);
            }
            if (this.tightInflaters[stream_id2 = comp_ctl & 3] == null) {
                this.tightInflaters[stream_id2] = new Inflater();
            }
            Inflater myInflater = this.tightInflaters[stream_id2];
            myInflater.setInput(zlibData);
            byte[] buf3 = new byte[dataSize];
            myInflater.inflate(buf3);
            if (this.rfb.rec != null && !this.rfb.recordFromBeginning) {
                this.rfb.recordCompressedData(buf3);
            }
            if (numColors != 0) {
                if (numColors == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(x, y, w, h, buf3, palette8);
                    } else {
                        this.decodeMonoData(x, y, w, h, buf3, palette24);
                    }
                } else {
                    int i2 = 0;
                    int dy = y;
                    while (dy < y + h) {
                        int dx = x;
                        while (dx < x + w) {
                            this.pixels24[dy * this.rfb.framebufferWidth + dx] = palette24[buf3[i2++] & 0xFF];
                            ++dx;
                        }
                        ++dy;
                    }
                }
            } else if (useGradient) {
                this.decodeGradientData(x, y, w, h, buf3);
            } else if (this.bytesPixel == 1) {
                int destOffset = y * this.rfb.framebufferWidth + x;
                int dy = 0;
                while (dy < h) {
                    System.arraycopy(buf3, dy * w, this.pixels8, destOffset, w);
                    destOffset += this.rfb.framebufferWidth;
                    ++dy;
                }
            } else {
                int srcOffset = 0;
                int dy = 0;
                while (dy < h) {
                    myInflater.inflate(buf3);
                    int destOffset = (y + dy) * this.rfb.framebufferWidth + x;
                    int i3 = 0;
                    while (i3 < w) {
                        this.pixels24[destOffset + i3] = (buf3[srcOffset] & 0xFF) << 16 | (buf3[srcOffset + 1] & 0xFF) << 8 | buf3[srcOffset + 2] & 0xFF;
                        srcOffset += 3;
                        ++i3;
                    }
                    ++dy;
                }
            }
        }
        this.handleUpdatedPixels(x, y, w, h);
        this.scheduleRepaint(x, y, w, h);
    }

    void decodeMonoData(int x, int y, int w, int h, byte[] src, byte[] palette) {
        int i = y * this.rfb.framebufferWidth + x;
        int rowBytes = (w + 7) / 8;
        int dy = 0;
        while (dy < h) {
            int n;
            int dx = 0;
            while (dx < w / 8) {
                byte b = src[dy * rowBytes + dx];
                n = 7;
                while (n >= 0) {
                    this.pixels8[i++] = palette[b >> n & 1];
                    --n;
                }
                ++dx;
            }
            n = 7;
            while (n >= 8 - w % 8) {
                this.pixels8[i++] = palette[src[dy * rowBytes + dx] >> n & 1];
                --n;
            }
            i += this.rfb.framebufferWidth - w;
            ++dy;
        }
    }

    void decodeMonoData(int x, int y, int w, int h, byte[] src, int[] palette) {
        int i = y * this.rfb.framebufferWidth + x;
        int rowBytes = (w + 7) / 8;
        int dy = 0;
        while (dy < h) {
            int n;
            int dx = 0;
            while (dx < w / 8) {
                byte b = src[dy * rowBytes + dx];
                n = 7;
                while (n >= 0) {
                    this.pixels24[i++] = palette[b >> n & 1];
                    --n;
                }
                ++dx;
            }
            n = 7;
            while (n >= 8 - w % 8) {
                this.pixels24[i++] = palette[src[dy * rowBytes + dx] >> n & 1];
                --n;
            }
            i += this.rfb.framebufferWidth - w;
            ++dy;
        }
    }

    void decodeGradientData(int x, int y, int w, int h, byte[] buf) {
        byte[] prevRow = new byte[w * 3];
        byte[] thisRow = new byte[w * 3];
        byte[] pix = new byte[3];
        int[] est = new int[3];
        int offset = y * this.rfb.framebufferWidth + x;
        int dy = 0;
        while (dy < h) {
            int c = 0;
            while (c < 3) {
                pix[c] = (byte)(prevRow[c] + buf[dy * w * 3 + c]);
                thisRow[c] = pix[c];
                ++c;
            }
            this.pixels24[offset++] = (pix[0] & 0xFF) << 16 | (pix[1] & 0xFF) << 8 | pix[2] & 0xFF;
            int dx = 1;
            while (dx < w) {
                c = 0;
                while (c < 3) {
                    est[c] = (prevRow[dx * 3 + c] & 0xFF) + (pix[c] & 0xFF) - (prevRow[(dx - 1) * 3 + c] & 0xFF);
                    if (est[c] > 255) {
                        est[c] = 255;
                    } else if (est[c] < 0) {
                        est[c] = 0;
                    }
                    pix[c] = (byte)(est[c] + buf[(dy * w + dx) * 3 + c]);
                    thisRow[dx * 3 + c] = pix[c];
                    ++c;
                }
                this.pixels24[offset++] = (pix[0] & 0xFF) << 16 | (pix[1] & 0xFF) << 8 | pix[2] & 0xFF;
                ++dx;
            }
            System.arraycopy(thisRow, 0, prevRow, 0, w * 3);
            offset += this.rfb.framebufferWidth - w;
            ++dy;
        }
    }

    void handleUpdatedPixels(int x, int y, int w, int h) {
        this.pixelsSource.newPixels(x, y, w, h);
        this.memGraphics.setClip(x, y, w, h);
        this.memGraphics.drawImage(this.rawPixelsImage, 0, 0, null);
        this.memGraphics.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    void scheduleRepaint(int x, int y, int w, int h) {
        this.repaint(this.viewer.deferScreenUpdates, x, y, w, h);
    }

    public void keyPressed(KeyEvent evt) {
        this.processLocalKeyEvent(evt);
    }

    public void keyReleased(KeyEvent evt) {
        this.processLocalKeyEvent(evt);
    }

    public void keyTyped(KeyEvent evt) {
        evt.consume();
    }

    public void mousePressed(MouseEvent evt) {
        this.processLocalMouseEvent(evt, false);
    }

    public void mouseReleased(MouseEvent evt) {
        this.processLocalMouseEvent(evt, false);
    }

    public void mouseMoved(MouseEvent evt) {
        this.processLocalMouseEvent(evt, true);
    }

    public void mouseDragged(MouseEvent evt) {
        this.processLocalMouseEvent(evt, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLocalKeyEvent(KeyEvent evt) {
        if (this.viewer.rfb != null && this.rfb.inNormalProtocol) {
            if (!this.inputEnabled) {
                if ((evt.getKeyChar() == 'r' || evt.getKeyChar() == 'R') && evt.getID() == 401) {
                    try {
                        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                RfbProto rfbProto = this.rfb;
                synchronized (rfbProto) {
                    try {
                        this.rfb.writeKeyEvent(evt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.rfb.notify();
                }
            }
        }
        evt.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLocalMouseEvent(MouseEvent evt, boolean moved) {
        if (this.viewer.rfb != null && this.rfb.inNormalProtocol) {
            if (moved) {
                this.softCursorMove(evt.getX(), evt.getY());
            }
            RfbProto rfbProto = this.rfb;
            synchronized (rfbProto) {
                try {
                    this.rfb.writePointerEvent(evt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.rfb.notify();
            }
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    synchronized void handleCursorShapeUpdate(int encodingType, int xhot, int yhot, int width, int height) throws IOException {
        int bytesPerRow = (width + 7) / 8;
        int bytesMaskData = bytesPerRow * height;
        this.softCursorFree();
        if (width * height == 0) {
            return;
        }
        if (this.viewer.options.ignoreCursorUpdates) {
            if (encodingType == -240) {
                this.rfb.is.skipBytes(6 + bytesMaskData * 2);
            } else {
                this.rfb.is.skipBytes(width * height + bytesMaskData);
            }
            return;
        }
        this.softCursorPixels = new int[width * height];
        if (encodingType == -240) {
            byte[] rgb = new byte[6];
            this.rfb.is.readFully(rgb);
            int[] colors = new int[]{0xFF000000 | (rgb[3] & 0xFF) << 16 | (rgb[4] & 0xFF) << 8 | rgb[5] & 0xFF, 0xFF000000 | (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | rgb[2] & 0xFF};
            byte[] pixBuf = new byte[bytesMaskData];
            this.rfb.is.readFully(pixBuf);
            byte[] maskBuf = new byte[bytesMaskData];
            this.rfb.is.readFully(maskBuf);
            int i = 0;
            int y = 0;
            while (y < height) {
                int result;
                int n;
                int x = 0;
                while (x < width / 8) {
                    byte pixByte = pixBuf[y * bytesPerRow + x];
                    byte maskByte = maskBuf[y * bytesPerRow + x];
                    n = 7;
                    while (n >= 0) {
                        result = (maskByte >> n & 1) != 0 ? colors[pixByte >> n & 1] : 0;
                        this.softCursorPixels[i++] = result;
                        --n;
                    }
                    ++x;
                }
                n = 7;
                while (n >= 8 - width % 8) {
                    result = (maskBuf[y * bytesPerRow + x] >> n & 1) != 0 ? colors[pixBuf[y * bytesPerRow + x] >> n & 1] : 0;
                    this.softCursorPixels[i++] = result;
                    --n;
                }
                ++y;
            }
        } else {
            byte[] pixBuf = new byte[width * height * this.bytesPixel];
            this.rfb.is.readFully(pixBuf);
            byte[] maskBuf = new byte[bytesMaskData];
            this.rfb.is.readFully(maskBuf);
            int i = 0;
            int y = 0;
            while (y < height) {
                int result;
                int n;
                int x = 0;
                while (x < width / 8) {
                    byte maskByte = maskBuf[y * bytesPerRow + x];
                    n = 7;
                    while (n >= 0) {
                        if ((maskByte >> n & 1) != 0) {
                            if (this.bytesPixel == 1) {
                                result = 0;
                                switch (this.viewer.options.eightBitColors) {
                                    case 1: {
                                        result = this.cm8_256c.getRGB(pixBuf[i]);
                                        break;
                                    }
                                    case 2: 
                                    case 4: {
                                        result = this.cm8_64c.getRGB(pixBuf[i]);
                                        break;
                                    }
                                    case 3: 
                                    case 5: {
                                        result = this.cm8_8c.getRGB(pixBuf[i]);
                                    }
                                }
                            } else {
                                result = 0xFF000000 | (pixBuf[i * 4 + 1] & 0xFF) << 16 | (pixBuf[i * 4 + 2] & 0xFF) << 8 | pixBuf[i * 4 + 3] & 0xFF;
                            }
                        } else {
                            result = 0;
                        }
                        this.softCursorPixels[i++] = result;
                        --n;
                    }
                    ++x;
                }
                n = 7;
                while (n >= 8 - width % 8) {
                    if ((maskBuf[y * bytesPerRow + x] >> n & 1) != 0) {
                        if (this.bytesPixel == 1) {
                            result = 0;
                            switch (this.viewer.options.eightBitColors) {
                                case 1: {
                                    result = this.cm8_256c.getRGB(pixBuf[i]);
                                    break;
                                }
                                case 2: 
                                case 4: {
                                    result = this.cm8_64c.getRGB(pixBuf[i]);
                                    break;
                                }
                                case 3: 
                                case 5: {
                                    result = this.cm8_8c.getRGB(pixBuf[i]);
                                }
                            }
                        } else {
                            result = 0xFF000000 | (pixBuf[i * 4 + 1] & 0xFF) << 16 | (pixBuf[i * 4 + 2] & 0xFF) << 8 | pixBuf[i * 4 + 3] & 0xFF;
                        }
                    } else {
                        result = 0;
                    }
                    this.softCursorPixels[i++] = result;
                    --n;
                }
                ++y;
            }
        }
        this.softCursorSource = new MemoryImageSource(width, height, this.softCursorPixels, 0, width);
        this.softCursor = this.createImage(this.softCursorSource);
        this.cursorWidth = width;
        this.cursorHeight = height;
        this.hotX = xhot;
        this.hotY = yhot;
        this.showSoftCursor = true;
        this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
    }

    synchronized void handleCursorPosUpdate(int x, int y) {
        if (x >= this.rfb.framebufferWidth) {
            x = this.rfb.framebufferWidth - 1;
        }
        if (y >= this.rfb.framebufferHeight) {
            y = this.rfb.framebufferHeight - 1;
        }
        this.softCursorMove(x, y);
    }

    synchronized void softCursorMove(int x, int y) {
        if (this.showSoftCursor) {
            this.repaint();
        }
        this.cursorX = x;
        this.cursorY = y;
    }

    synchronized void softCursorFree() {
        if (this.showSoftCursor) {
            this.showSoftCursor = false;
            this.softCursor = null;
            this.softCursorSource = null;
            this.softCursorPixels = null;
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
        }
    }
}

