#include <stdlib.h>
#include <stdio.h>

#include <sys/stat.h>
#include <unistd.h>

#include <sys/types.h>
#include <dirent.h>


// This is cool for ext2.
#define MAXLEN 256
#define maxdepth 4096

enum {Tdir,Tfile,Tlink,Tdangling};

struct dnode {
 dnode *sister;
 char name[MAXLEN];
 char type;
};

const char *look;
int show_files=0,show_links=0;
const char *l_ascii="|+`-";
const char l_ibm[5]={179,195,192,196,0};

int d_tot,f_tot,l_tot;

char map[maxdepth];

void generate_header(int level) {
 int i;
 for (i=0;i<level;i++) printf(" %c ",(map[i]?look[0]:32));
 printf (" %c%c ",(map[level]?look[1]:look[2]),look[3]);
}

dnode* reverselist(dnode *last) {
 dnode *first,*current;
 first=NULL;
 current=last;

 // Put it back in order:
 // Pre: last==current, first==NULL, current points to backwards linked list
 while (current != NULL) {
  last=current->sister;
  current->sister=first;
  first=current;
  current=last;
 }

 return first;
} 

void buildtree(int level) {
 dnode *first,*current,*last;
 first=current=last=NULL;
 char *cwd;
 struct stat st,st2;
 
 if (level>=maxdepth) return;
 
 // This is LINUX SPECIFIC: (ie it may not work on other platforms)
 cwd=getcwd(NULL,maxdepth);
 if (cwd==NULL) return;
 
 // Get (backwards) Dirlist:
 DIR *dir;
 dirent *de;
 
 dir=opendir(cwd);
 if (dir==NULL) return;
 
 while ((de=readdir(dir))) {
  int ftype;
  // use de->d_name for the filename
  if (lstat(de->d_name,&st) != 0) continue; // ie if not success go on.
  if ((show_files) && S_ISREG(st.st_mode)) ftype=Tfile;
  else if ((show_links) && S_ISLNK(st.st_mode)) {
   ftype=Tlink;
   if (stat(de->d_name,&st2) != 0) ftype=Tdangling;
   if (!show_files) {
    if (ftype==Tdangling) continue;
    if (!S_ISDIR(st2.st_mode)) continue;
   }
  } else {
   if (S_ISDIR(st.st_mode)) ftype=Tdir;
   else continue;
  }
  if (!(show_files||show_links) && !S_ISDIR(st.st_mode)) continue; // if not dir go on.
  if (!(strcmp(".",de->d_name) && strcmp("..",de->d_name))) continue; // skip ./..
  current=new dnode;
  current->sister=last;
  strcpy(current->name,de->d_name);
  current->type=ftype;
  // Save the readlink(2) for later.
  last=current;
 }
 
 closedir(dir);
 
 first=reverselist(last);
 
 // go through each printing names and subtrees
 
 while (first != NULL) {
  map[level]=(first->sister != NULL);
  generate_header(level);
  switch (first->type) {
   case Tdir:
    puts(first->name);
    // consider recursion here....  
    if (chdir (first->name) == 0) {
     buildtree(level+1);
     if (chdir (cwd) != 0) return;
    }
    d_tot++;
   break;
   
   case Tfile:
    puts(first->name);
    f_tot++;
   break;
   
   case Tlink:
   case Tdangling:
    static char buf[1024];
    buf[readlink(first->name,buf,1023)]=0;
    printf("%s -> %s\n",first->name,buf);
    l_tot++;
   break;
  }
   
  current=first->sister;
  delete first;
  first=current;
 }
 free (cwd);
}  

void tree() {
 char *cwd;
 cwd=getcwd(NULL,maxdepth);
 if (cwd==NULL) return;
 printf("Tree of %s:\n\n",cwd);
 free (cwd);
 d_tot=0;
 buildtree(0);
 printf("\nTotal directories = %d\n",d_tot);
 if (show_files) printf("Total files = %d\n",f_tot);
 if (show_links) printf("Total links = %d\n",l_tot);
}

void usage() {
 printf("\
usage: tree {-[option],dirname} ...\n\n\
Tree version 1.0 - Copyright 1997 by Brooke Kjos <beth13@mail.utexas.edu>\n\
This program is covered by the Gnu General Public License version 2.0\n\
or later (copyleft). Distribution and use permitted as long as\n\
source code accompanies all executables and no additional\n\
restrictions are applied\n\
\n\n Options:\n\t-a use ascii for drawings\n\
\t-[ig] use IBM(tm) graphics characters\n\
\t-f show files as well as directories\n\
\t-l show links as well as directories\n\
\t--[fl] invert sense of switch\n\
\t-v Show version number and exit successfully\n\
");
};

void main (int argc,char ** argv)  {
 look=l_ascii;
 int i=1;
 int dirshown=0;
 char *cwd;
 
 cwd=getcwd(NULL,maxdepth);
 if (cwd==NULL) {
  printf("Failed to getcwd:\n");
  perror("getcwd");
  exit(1);
 }
 
 while (i<argc) { // while
     if (argv[i][0]=='-') { // if1
       switch ((argv[i])[1]) // switch
	 {
	 
	 case '-':
	   switch (argv[i][2]) // switch2
	     {
	     
	     case 'f':
	     case 'F':
	       show_files=0;
	       break;

	     case 'l':
	     case 'L':
	       show_links=0;
	       break;
	     
	     } // switch2
	   break;
	 
	 case 'i':
	 case 'I':
	 case 'g':
	 case 'G':
	   look = l_ibm;
	   break;

	 case 'a':
	 case 'A':
	   look = l_ascii;
	   break;

	 case 'f':
	 case 'F':
	   show_files=1;
	   break;
	 
	 case 'l':
	 case 'L':
	   show_links=1;
	   break;

	 case 'v':
	 case 'V':
	   usage();
	   exit(0);
	 default: 
	   printf ("Unknown option: %s\n\n",argv[1]);
	   usage();
	   exit(1);
	 } // switch
     } // if1
     else {
	   if (chdir(argv[i]) == 0) { // if2
	    if (dirshown) printf("\n\n");
	    tree();
	    dirshown=1;
	    if (chdir(cwd) != 0) { // if3
	     printf("Failed to chdir to cwd\n");
	     exit(1);
	    } // if3
	   } // if2
	   else printf("Failed to chdir to %s\n\n",argv[i]);
     } // if1
     i++;
 } // while
 free (cwd);
 if (dirshown == 0) tree();
}
