#include "SCSI_eject.H"

#include "scsi/scsi.h"
#include "scsi/sg.h"

#include <iostream.h>

#include <sys/file.h>
#include <unistd.h>

static char *id __attribute__ ((unused))
            = "@(#) $Id: SCSI_eject.cc,v 1.5 1999/10/15 09:12:25 heyder Exp $";

struct sg_request {
  struct sg_header header;
  unsigned char bytes[100];
};

struct sg_reply {
  struct sg_header header;
  unsigned char bytes[100];
};


// use dev to eject without further testing
// which is asumed to be done allready
int scsi_eject(string dev, int eject)
{
  int count;
  int fd_sg;
  struct sg_reply reply;
  struct sg_request request;
  int reply_len, exp_size, act_size;
  
  if ( (fd_sg = open(dev.c_str(), O_RDWR)) < 0 ) return -1;
  
  reply_len = sizeof(struct sg_reply);
  bzero (&reply, sizeof(reply_len));
  bzero (&request, sizeof(request));
  
  request.header.pack_len = sizeof(struct sg_header) + 6;
  request.header.reply_len = reply_len + sizeof(struct sg_header);
  request.header.pack_id = 0;
  request.header.result = 0;

  request.bytes[0] = START_STOP;
  request.bytes[1] = 0;
  request.bytes[2] = 0;
  request.bytes[3] = 0;
  request.bytes[4] = eject ? 2 : 3;
  request.bytes[5] = 0;

  exp_size = sizeof(struct sg_header) + 6;
  count=0;
  do {
    act_size = write(fd_sg, &request, exp_size);
    if (act_size < 0) {
      return -1;
    }
    else if (act_size != exp_size) {
      cerr << "wrote " << act_size << " bytes, expected to write "
	   << exp_size << "." << endl;
    }
    
    reply_len = read(fd_sg, &reply, sizeof(struct sg_reply));
    
    count++;
  } while (reply.header.result!=0 && count<MAX_TRIES);
  
  if (reply.header.result!=0) return -1;

  close(fd_sg);
  return 0;
}
