#include "Options.H"

#include <iostream.h>

#include <getopt.h>

static char *id __attribute__ ((unused))
            = "@(#) $Id: Options.cc,v 1.6 1999/10/15 09:12:25 heyder Exp $";

void parse_options(int argc, char *argv[], device_set &list, int &verbose,
		  int &eject, int &force_umount)
{
  int index  = 0;
  int mode   = 0;
  int umount = 0;
  char c;
  static struct option long_options[] =
  {
    {"verbose",  0, &verbose, 1 },
    {"load",     0, 0,        'l' },
    {"eject",    0, 0,        'e' },
    {"help",     0, 0,        'h' },
    {"umount",   0, 0,        'u' },
    {"noumount", 0, 0,        'n' },
    {0, 0, 0, 0}
  };

  while (EOF != (c=getopt_long(argc, argv, "vlehun", long_options, &index))) {
    switch(c) {
    case 0:
      break;
    case 'v':
      verbose=1;
      break;
    case 'l':
      if (!mode) {
	eject=0;
	mode=1;
      } else {
	cerr << "Error: Can't use -l and -e together" << endl;
	usage(argv[0]);
      }
      break;
    case 'u':
      if (!umount) {
	force_umount=1;
	umount=1;
      } else {
	cerr << "Error: Can't use -u and -n together" << endl;
	usage(argv[0]);
      }
      break;
    case 'n':
      if (!umount) {
	force_umount=0;
	umount=1;
      } else {
	cerr << "Error: Can't use -u and -n together" << endl;
	usage(argv[0]);
      }
      break;
    case 'e':
      if (!mode) {
	eject=1;
	mode=1;
      } else {
	cerr << "Error: Can't use -l and -e together" << endl;
	usage(argv[0]);
      }
      break;
    case '?':
    case 'h':
      usage(argv[0]);
      break;
    default:
      ;
    }
  }
  while (optind < argc) {
    // insert argv[optind] in devlist;
    list.insert(argv[optind]);
    optind++;
  }
}

void usage(string name)
{
  cerr << " Usage: " << name << " [-v] [-l | -e] [-u | -n] [device|nickname]" 
       << endl
       << "        -v be verbose " << endl
       << "        -l load medium" << endl
       << "           default if _not_ invoked as 'eject' or 'unload'" << endl
       << "        -e eject medium" << endl
       << "           default if invoked as 'eject' or 'unload'" << endl
       << "        -u try umount before ejecting "
#if FORCE_UMOUNT
       << "(default)"
#endif
       << endl
       << "        -n don't umount before ejecting "
#if !FORCE_UMOUNT
       << "(default)"
#endif
       << endl
       << "        device - SCSI-generic or CD-ROM device or nickname" << endl
       << " FH-Eject V" << VERSION << endl;
  exit(0);
}
