#include "Handle_List.H"
#include "Nicknames.H"
#include "SCSI_map.H"
#include "SCSI_eject.H"
#include "ioctl_eject.H"
#include "Values.H"

#include <iostream.h>

#include <sys/stat.h>
#include <sys/sysmacros.h>
#include <linux/major.h>
#include <stdio.h>
#include <unistd.h>

static char *id __attribute__ ((unused))
            = "@(#) $Id: Handle_List.cc,v 1.8 1999/10/15 09:12:24 heyder Exp $";

static eject_type get_eject_type(string dev)
{
  struct stat devstat;
  int ret;

  ret = stat(dev.c_str(), &devstat);
  
  if (ret) return UNKNOWN;

  switch(major(devstat.st_rdev)) {
  case SCSI_GENERIC_MAJOR:
  case SCSI_DISK0_MAJOR:
  case SCSI_DISK1_MAJOR:
  case SCSI_DISK2_MAJOR:
  case SCSI_DISK3_MAJOR:
  case SCSI_DISK4_MAJOR:
  case SCSI_DISK5_MAJOR:
  case SCSI_DISK6_MAJOR:
  case SCSI_DISK7_MAJOR:
  case SCSI_TAPE_MAJOR:
  case SCSI_CDROM_MAJOR:
    return GENERIC_SCSI;
  default:
    return IOCTL;
  }
}

static string follow_links(string dev, int verbose)
{
  char buffer[BUFFERSIZE];
  int len;
  string device;

  do {
    len = readlink(dev.c_str(), buffer, BUFFERSIZE);
    if (len>0) {
      device=dev;
      buffer[len]=0;
      if (buffer[0]!='/') {
	dev.erase(dev.rfind("/")+1);
	dev += buffer;
      } else
	dev = buffer;
      if (verbose)
	cout << "Device " << device << " is " << dev << endl;
    }
  } while (len>0);
  return dev;
}

void prepare_list(device_set &list, nick_table table, int verbose)
{
  device_set todo, done, nicks;
  string name;
  device_set::iterator pos;

  // default entry
  if (list.size()==0)
    list = table[""];
  // nicknames
  todo = list;
  list.erase(list.begin(), list.end());
  while (todo.size()>0) {
    name=*todo.begin();
    todo.erase(name);
    if (done.count(name) > 0) continue;
    nicks = table[name];
    if (nicks.size() > 0) {
      if (verbose)
	cout << "Matching " << name << " to ";
      for (pos=nicks.begin(); pos!=nicks.end(); pos++) {
	if (verbose)
	  cout << *pos << ", ";
	todo.insert(*pos);
      }
      if (verbose)
	cout << "..." << endl;;
      done.insert(name);
    } else {
      if (name[0]!='/') name = "/dev/"+name;
      name = follow_links(name, verbose);
      list.insert(name);
    }
  };
}

int do_eject(device_set list, int eject, int verbose)
{
  device_set::iterator pos;
  int errors=0;
  int ret;
  string gdev;
  string device;
  eject_type type;
  
  for (pos=list.begin(); pos!=list.end(); pos++) {
    device = *pos;
    if (verbose)
      cout << "Ejecting " << device << " ... " << flush;
    type = get_eject_type(device);
    if (type == UNKNOWN) {
      cerr << "Error: Can't eject unknown device type" << endl;
      errors++;
    }
    if (type == IOCTL) {
      ret =ioctl_eject(device, eject);
      if (ret) errors++;
    }
    if (type == GENERIC_SCSI) {
      gdev = scsi_remap_device(device);
      if (gdev != "") {
	if (verbose)
	  cout << "Mapping to" << gdev << " ... Unlocking ... " << flush;
	ret=scsi_eject(gdev, eject);
	if (ret) errors++;
      } else {
	if (verbose) {
	  cout << "Can't map to generic device using ioctl ... " << flush;
	}
	errors++;
	ret = ioctl_eject(device, eject);
	if (ret) errors++;
      }
    }
    if (verbose)
      cout << "done" << endl;
  }
  return -errors;
}
