/*
 *	$Id: diskwrite.h,v 1.2 1999/11/22 02:17:59 solyga Exp $
 */

#define	DEBUG
#undef	DEBUG
#define	HAVE_LONGLONG
#undef	HAVE_LONGLONG


/********  program specific stuff  ********************************************/

#include	<stdio.h>
#include	<errno.h>
#include	<unistd.h>	/* getopt(), read(), write(), close(), FILENO */
#include	<stdlib.h>	/* strtol(), malloc() */
#include	<sys/types.h>	/* open(), socket(), connect(), ulong */
#include	<sys/stat.h>	/* open() */
#include	<fcntl.h>	/* open(), O_RDONLY */
#include	<limits.h>	/* INT_MAX, INT_MIN */
#include	<time.h>	/* time() */


#define	HELP_CHANNEL	stdout
#define	VERSION_CHANNEL	stdout
#define	ERROR_CHANNEL	stderr
#define	VERBOSE_CHANNEL	stderr
#define	DEBUG_CHANNEL	stderr


#define	RETVAL_OK	 0
#define	RETVAL_BUG	 1
#define	RETVAL_ERROR	 2


#ifdef	HAVE_LONGLONG
#define	OFF_T			loff_t
#define	SIZE_MAX		0x7ffffffffffffffell
loff_t	llseek( int fd, loff_t offset, int whence );
#define	LSEEK( A, B, C )	llseek( (A), (B), (C) )
#define	STRTOL( A, B, C )	strtoq( (A), (B), (C) )
#else	/* HAVE_LONGLONG */
#define	OFF_T			off_t
#define	SIZE_MAX		(LONG_MAX-1)
#define	LSEEK( A, B, C )	lseek( (A), (B), (C) )
#define	STRTOL( A, B, C )	strtol( (A), (B), (C) )
#endif	/* HAVE_LONGLONG */


#define	BUFFER_SIZE		0x1000
#define	VERBOSE_LEVEL_MAX	1	/* check this, may have changed */
#define	PERMISSIONS		( S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH )


#define	VERSION_NUMBER		"0.01.01"
#define	DATE_OF_LAST_MOD	"1999-11-22"
#define	MY_EMAIL_ADDRESS	"Steffen Solyga <solyga@absinth.net>"

/********  general stuff  *****************************************************/

/*
 *	some useful macros
 */
#define	MIN( A, B )		( (A)<(B) ? (A) : (B) )
#define	MAX( A, B )		( (A)>(B) ? (A) : (B) )


/*
 *	often used types
 */
typedef	unsigned char	UCHAR;


/*
 *	network specific error messages
 *	taken from resolv/herror.c of glibc-2.0.7
 */
#define N_( A )		A
const char *h_errlist[] = {
        N_("Resolver Error 0 (no error)"),
        N_("Unknown host"),                     /* 1 HOST_NOT_FOUND */
        N_("Host name lookup failure"),         /* 2 TRY_AGAIN */
        N_("Unknown server error"),             /* 3 NO_RECOVERY */
        N_("No address associated with name"),  /* 4 NO_ADDRESS */
};
