#define IPCTST
#undef IPCTST
/* -------------------------------------------------------------------- */
/*        semshm.c                                                      */
/* -------------------------------------------------------------------- */
/*               int seminstall(key,amount)                             */
/*               int semrequest(semid,semnum)                           */
/*               int semrelease(semid,semnum)                           */
/* -------------------------------------------------------------------- */

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include "interface.h"
#include "ringbuff.h"
#include "semshm.h"

int sem_id;
int shm_id;
/*-----------------------------------------------------------------*/
int seminstall(key_t key, int amount)
{
  int           ret_val;
  int           semflag;

  semflag = IPC_CREAT | 0600;
#ifdef IPCTST
  fprintf(stderr,"seminstall: key: %d, #sems %d, flags %4x\n",
          key,amount,semflag);
#endif
  ret_val = semget(key,amount,semflag);
  if ( ret_val == -1 )
  {
    fprintf(stderr,"semget: (Key %x, #%d) failed: ",
            key,amount);
    perror("");
  }
  return ret_val;
}

/*-----------------------------------------------------------------*/
int semrequest(int semid, short semnum)
{
  struct sembuf sops[1];
  int    ret_val;

#ifdef IPCTST
  fprintf(stderr,"pid %d, ReQuest id:num %d:%d\n",getpid(),semid,semnum);
#endif
  sops[0].sem_op  = -1;
  sops[0].sem_num = semnum;
  sops[0].sem_flg = 0;

  do {
    errno = 0;
    ret_val = semop(semid,sops,1);
    if (ret_val == -1 && errno != EAGAIN && errno != EINTR)
      {
	fprintf(stderr,"Request Sema%d(%d) failed: ",semid,semnum);
	perror("");
      }
  } while (errno == EAGAIN || errno == EINTR);
  return(ret_val);
}

/*-----------------------------------------------------------------*/
int semrelease(int semid, short semnum)
{
  struct sembuf sops[1];
  int    ret_val;

#ifdef IPCTST
  fprintf(stderr,"%d RL %d:%d\n",getpid(),semid,semnum);
#endif
  sops[0].sem_op  = 1;
  sops[0].sem_num = semnum;
  sops[0].sem_flg = 0;
  ret_val = semop(semid,sops,1);
  if ( ret_val == -1 && errno != EAGAIN)
  {
    fprintf(stderr,"Release Sema%d(%d) failed: ",semid,semnum);
    perror("");
  }
  return(ret_val);
}


/* release semaphores and shared memory */
void free_semshm(void)
{
  int   mycmd;
  union my_semun myarg;

  mycmd = IPC_RMID;
  semctl(sem_id,0,mycmd,myarg);
  shmctl(shm_id,mycmd,0L);
}

void *request_shm_sem(unsigned int amount_of_sh_mem, unsigned char **pointer)
{
    /* install semaphores for double buffer usage */
    sem_id = seminstall(IPC_PRIVATE,2);
    if ( sem_id == -1 ) {
      perror("seminstall");
      exit(1);
    }

    /* request a doublebuffer for cdda sector audio data */
    shm_id = shm_request(IPC_PRIVATE, amount_of_sh_mem, pointer);
    if ( shm_id == -1 ) {
	perror("sem_request");
	exit(1);
    }
    return *pointer;
}
