/*  cdrdao - write audio CD-Rs in disc-at-once mode
 *
 *  Copyright (C) 1998  Andreas Mueller <mueller@daneb.ping.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __TOC_H__
#define __TOC_H__

#include <iostream.h>
#include "Track.h"

class Toc {
public:
  Toc();
  ~Toc();

  const Track *first(Msf &start, Msf &end) const;
  const Track *next(Msf &start, Msf &end) const;
  int nofTracks() const { return nofTracks_; }

  Msf length() const { return length_; }

  int append(const Track *);
  void insert(int, const Track *);
  void remove(int);

  int openData() const;
  long readData(char *buf, long len) const;
  void closeData() const;

  int check() const;

  static Toc *read(const char *);

  int catalogValid() const { return catalogValid_; }

  int catalog(const char *); // sets catalog number

  char catalog(int i) const { return catalog_[i]; } // BCD

  void print(ostream &) const;
private:
  struct TrackEntry {
    TrackEntry() : start(0), end(0) { track = 0; next = 0; }
    Track *track;
    Msf start;
    Msf end;

    struct TrackEntry *next;
  };

  int nofTracks_;
  TrackEntry *tracks_;
  TrackEntry *lastTrack_;

  Msf length_; // total length of disc

  char catalog_[13];
  int catalogValid_;

  TrackEntry *iterator_; // actual iterated track

  const TrackEntry *readTrack_; // actual read track
  long readPos_; // actual read position (blocks)
  int open_; // != 0 indicates that toc was opened for reading data

  void update();
};

#endif
