/*  cdrdao - write audio CD-Rs in disc-at-once mode
 *
 *  Copyright (C) 1998  Andreas Mueller <mueller@daneb.ping.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: AudioData.h,v $
 * Revision 1.2  1998/07/28 13:46:39  mueller
 * Automatic length determination of audio files is now done in 'AudioData'.
 *
 */


#ifndef __AUDIODATA_H__
#define __AUDIODATA_H__

#include <iostream.h>
#include "Sample.h"

class AudioData {
public:
  enum Type { FILE, SILENCE };

  AudioData(const char *filename, unsigned long start, unsigned long length);
  AudioData(Type, unsigned long length);
  AudioData(const AudioData &);

  ~AudioData();

  Type type() const;
  const char *filename() const;
  unsigned long startPos() const;
  unsigned long length() const;
  void length(unsigned long l);
  
  int check() const;

  int openData() const;
  void closeData() const;
  long readData(Sample *buffer, long len) const;

  void print(ostream &) const;
private:
  Type type_; // type of data

  int open_;  // 1: data can be retrieved with 'readData()', 'fd_' is valid if
              // object type is 'FILE'

  int fileType_; // 1: raw data, 2 WAVE file
  char *filename_; // used for object type 'FILE'
  int fd_;         // used for object type 'FILE'
  unsigned long startPos_; // starting sample within file, 
                           // used for object type 'FILE'

  int autoLength_; // 1 if length of audio file is automatically determined
  int autoLengthFailed_; // set to 1 if audio file length could not be
                         // determined
  unsigned long length_; // length of audio data (samples), used for all types

  unsigned long readPos_; // actual read position (samples) (0 .. length_-1)
};

inline
AudioData::Type AudioData::type() const
{
  return type_;
}

inline
const char *AudioData::filename() const
{
  return filename_;
}

inline
unsigned long AudioData::startPos() const
{
  return startPos_;
}

inline
void AudioData::length(unsigned long l)
{
  length_ = l;
}

#endif
