#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pwd.h>
#include <string.h>
#include <fcntl.h>
#include <dirent.h>
#include <ctype.h>
#include <stdlib.h>
#include "top_proc.h"

int readcpui(cpui &in){
 char buf[1024];
 int desc=open("/proc/stat",O_RDONLY);
 if (desc==-1) return -1;
 int len=read(desc,buf,1023);
 if (len==-1) return -2;
 close(desc);
 if(sscanf(buf,"cpu %d %d %d %d",&in.user,&in.nice,&in.system,&in.idle)==0)
  return -3;
 return 0; 
}

int readmemi(memi &in){
 char buf[1024];
 int desc=open("/proc/meminfo",O_RDONLY);
 if (desc==-1) return -1;
 int len=read(desc,buf,1023);
 if (len==-1) return -2;
 close(desc);
 char *p=buf;
 do{p++;}while(*p!='\n');p++;
 if(sscanf(p,"Mem: %d %d %d %d %d %d\nSwap: %d %d %d",&in.total,&in.used,&in.free,
                                         &in.shared,&in.buffers,&in.cached,
					 &in.stotal,&in.sused,&in.sfree)==0)
  return -3;
 return 0; 
}

int readnproc(){
 char buf[1024];
 int n,m;
 float f;
 int desc=open("/proc/loadavg",O_RDONLY);
 if (desc==-1) return -1;
 int len=read(desc,buf,1023);
 if (len==-1) return -2;
 close(desc);
 if(sscanf(buf,"%f %f %f %d/%d",&f,&f,&f,&m,&n)==0)
  return -3;
 return n-1; 
}

int readproci(proci &in){
 char buf[1024];
 struct stat st;
 int i;unsigned ut,kt;
 sprintf(buf,"/proc/%d/stat",in.pid);
 int desc=open(buf,O_RDONLY);
 if (desc==-1) return -1;
 fstat(desc,&st);
 in.uid=st.st_uid;
 int len=read(desc,buf,1023);
 if (len==-1) return -2;
 close(desc);
 if(
 sscanf(buf,"%d %30s %c %d %d %d %d %d %u %u %u %u %u %d %d %d %d %d %d",
                &in.pid,&in.command,&in.state,&i,
		&i,&i,&i,&i,&i,&i,&i,&i,&i,&ut,&kt,&i,&i,&in.pri,&in.nice)==0)
  return -3;
 i=0;
 while(in.command[++i]!=')'&&in.command[i]!='\0')in.command[i-1]=in.command[i];
 in.command[i-1]='\0';
 in.time=ut+kt; 
 sprintf(buf,"/proc/%d/status",in.pid);
 desc=open(buf,O_RDONLY);
 if (desc==-1) return -1;
 len=read(desc,buf,1023);
 if (len==-1) return -2;
 close(desc);
 char *p=buf;
 for(i=0;i<6;i++)do{p++;}while(*p!='\n');p++;
 if(sscanf(p,"VmSize: %d kB",&in.size)==0) in.size=0;
 for(i=0;i<2;i++)do{p++;}while(*p!='\n');p++;
 if(sscanf(p,"VmRSS: %d kB",&in.rss)==0) in.rss=0;
 return 0;
}

struct ncitem{int uid;char name[30];};
ncitem namecache[200];
int ncitems=0,ncpos=0;
void uid2name(char *name,int uid) {
 for (int i=0;i<ncitems;i++) if (namecache[i].uid==uid) {strncpy(name,namecache[i].name,30);return;}
 namecache[ncpos].uid=uid;
 strncpy(namecache[ncpos].name,getpwuid(uid)->pw_name,30);
 strncpy(name,namecache[ncpos++].name,30);
 if(ncpos>200) ncpos=0;
 if(ncitems<ncpos) ncitems=ncpos;
}

struct oldp{int time,pid;}; 
oldp *oldpin;
int noldproc=0;

int fillproci(int n,proci *pin,int j, int mems){
 int err; 
 DIR *dir=opendir("/proc");
 struct dirent *ent;
 int i=0;
 int timec=0;
 while((ent=readdir(dir))!=0) {
  if (!isdigit(ent->d_name[0])) continue;
  if (i>n) return -5;
  pin[i].pid=atoi(ent->d_name);
  if((err=readproci(pin[i]))<0) return err;
  uid2name(pin[i].user,pin[i].uid);
// Calculate CPU usage for i-th process   
  for (int a=0;a<noldproc;a++) if (oldpin[a].pid==pin[i].pid) {
  timec=pin[i].time-oldpin[a].time;break;}
  pin[i].cpu=(float)timec/j;
  pin[i].mem=1024.0*pin[i].rss/mems;
  i++;
 } 
 if (noldproc<n) {delete[]oldpin;oldpin=new oldp[n];noldproc=n;} 
 for (i=0;i<n;i++) {oldpin[i].pid=pin[i].pid;oldpin[i].time=pin[i].time;}
}

