/*****************************************************************************
 * CPULOAD 0.2 by Marc De Scheemaecker <marc@netvision.be>
 */

#include <stdio.h>
#include <stdlib.h>
#include "proc.h"


void
getProcStatInfo(type1, value1, total1, type2, value2, total2)
     int  type1;
     int* value1;
     int* total1;
     int  type2;
     int* value2;
     int* total2;
{
  static int last_values[2][4] = { { 0, 0, 0, 0 }, { 0, 0, 0, 0 } };
  static int last_results[2][2] = { { 0, 1 }, { 0, 1 } };
  FILE* proc_stat = fopen("/proc/stat", "r");
  char tag1[8] = "";
  char tag2[8] = "";
  
  if (! proc_stat) {
    fprintf(stderr, "ERROR: Could not open /proc/stat");
    return;
  }

  if (type1 == PROC_CPU_SUM) {
    sprintf(tag1, "cpu ");
  } else if (type1 >= PROC_CPU) {
    sprintf(tag1, "cpu%i ", (type1 - PROC_CPU));
  }

  if (type2 == PROC_CPU_SUM) {
    sprintf(tag2, "cpu ");
  } else if (type2 >= PROC_CPU) {
    sprintf(tag2, "cpu%i ", (type2 - PROC_CPU));
  }
  while (!feof(proc_stat)) {
    char line[128];
    int index = -1;
    int* value_res = 0;
    int* total_res = 0;

    fgets(line, 128, proc_stat);
    
    if ((*tag1 != '\0') && (strncmp(line, tag1, strlen(tag1)) == 0)) {
      index = 0;
      value_res = value1;
      total_res = total1;
    } else if ((*tag2 != '\0') && (strncmp(line, tag2, strlen(tag2)) == 0)) {
      index = 1;
      value_res = value2;
      total_res = total2;
    }

    if (index >= 0) {
      int user_read, system_read, nice_read, idle_read;
      int user, system, nice, idle;
      sscanf(line, "%*s %i %i %i %i", &user_read, &system_read, &nice_read,
	     &idle_read);
      user = user_read - last_values[index][0];
      system = system_read - last_values[index][1];
      nice = nice_read - last_values[index][2];
      idle = idle_read - last_values[index][3];
      if ((user + system + nice + idle) > 0) {
	/* prevent division by zero */
	last_results[index][0] = user + system + nice;
	last_results[index][1] = last_results[index][0] + idle;
      }
      *value_res = (100 * last_results[index][0]) / last_results[index][1];
      *total_res = 100;
      last_values[index][0] = user_read;
      last_values[index][1] = system_read;
      last_values[index][2] = nice_read;
      last_values[index][3] = idle_read;
    }
  }

  fclose(proc_stat);
}


void
setMemValue(type, value_res, total_res, mem_total, mem_used, mem_buffer,
	    mem_cache, swap_total, swap_used)
     int  type;
     int* value_res;
     int* total_res;
     int  mem_total, mem_used, mem_buffer, mem_cache;
     int  swap_total, swap_used;
{
  switch (type) {
    case PROC_MEM:
      *value_res = mem_used - mem_buffer - mem_cache;
      *total_res = mem_total;
      break;
      
    case PROC_SWAP:
      *value_res = swap_used;
      *total_res = swap_total;
      break;
      
    case PROC_MEM_SWAP:
      *value_res = swap_used + mem_used - mem_buffer - mem_cache;
      *total_res = swap_total + mem_total;
      break;
      
    case PROC_MEM_BUF:
      *value_res = mem_used;
      *total_res = mem_total;
      break;
      
    case PROC_MEM_BUF_SWAP:
      *value_res = swap_used + mem_used;
      *total_res = swap_total + mem_total;
      break;
  } 
}


void
getProcMemInfo(type1, value1, total1, type2, value2, total2)
     int  type1;
     int* value1;
     int* total1;
     int  type2;
     int* value2;
     int* total2;
{
  int mem_total, mem_used, mem_buffer, mem_cache;
  int swap_total, swap_used;
  char line[128];
  
  FILE* proc_meminfo = fopen("/proc/meminfo", "r");
  
  if (! proc_meminfo) {
    fprintf(stderr, "ERROR: Could not open /proc/meminfo");
    return;
  }
  
  fgets(line, 128, proc_meminfo); /* ignore the title line */
  fgets(line, 128, proc_meminfo);
  sscanf(line, "%*s %i %i %*i %*s %i %i", &mem_total, &mem_used, &mem_buffer,
	 &mem_cache);
  fgets(line, 128, proc_meminfo);
  sscanf(line, "%*s %i %i", &swap_total, &swap_used);
  fclose(proc_meminfo);

  setMemValue(type1, value1, total1, mem_total, mem_used, mem_buffer,
	      mem_cache, swap_total, swap_used);
  setMemValue(type2, value2, total2, mem_total, mem_used, mem_buffer,
	      mem_cache, swap_total, swap_used);
}


void
getInfo(type1, value1, total1, type2, value2, total2)
     int  type1;
     int* value1;
     int* total1;
     int  type2;
     int* value2;
     int* total2;
{
  *value1 = *value2 = -1;
  
  if ((type1 >= PROC_CPU_SUM) || (type2 >= PROC_CPU_SUM)) {
    getProcStatInfo(type1, value1, total1, type2, value2, total2);
  }
  if (((type1 >= PROC_MEM) && (type1 <= PROC_MEM_BUF_SWAP))
      || ((type2 >= PROC_MEM) && (type2 <= PROC_MEM_BUF_SWAP))) {
    getProcMemInfo(type1, value1, total1, type2, value2, total2);
  }
}
