#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>

#include <config.h>
#ifdef HAVE_LIBXEXT
#  include <X11/extensions/shape.h>
#endif
#include "proc.h"
#include "back1.xpm"
#include "back2.xpm"
#include "light.xpm"
#include "mask1.xbm"
#include "mask2.xbm"


#ifndef VERSION
#  define VERSION ""
#endif


#define MW_EVENTS (ExposureMask | ButtonPressMask | StructureNotifyMask)

Pixmap back, back0, back1, back2, light;

void redraw_window __P((Display*, Window, Window, GC, int, int, int));

Pixel get_color __P((Display*, Window, char*));

void parse_arguments __P((int*, char*[], int*, int*, int*, int*));


void
redraw_window(display, window, icon, gc, use_shape, tag1, tag2)
     Display* display;
     Window   window, icon;
     GC       gc;
     int      use_shape, tag1, tag2;
{
  int value1, total1, value2, total2;
  int no_shape = !use_shape;
  getInfo(tag1, &value1, &total1, tag2, &value2, &total2);
  XCopyArea(display, back, window, gc, 0, 0, 64, 64,
	    -8*use_shape, -8*use_shape);
  XCopyArea(display, back, icon, gc, 0, 0, 64, 64,
	    -8*use_shape, -8*use_shape);
    
  
  if (back == back1) {
    XCopyArea(display, light, icon, gc,
	      0,  45 - ((value1 * 45) / total1),
	      16, ((value1 * 45) / total1),
	      16+8*no_shape,  1+8*no_shape + 45 - ((value1 * 45) / total1));
    XCopyArea(display, light, window, gc,
	      0,  45 - ((value1 * 45) / total1),
	      16, ((value1 * 45) / total1),
	      16+8*no_shape,  1+8*no_shape + 45 - ((value1 * 45) / total1));
  }
  else {
    XCopyArea(display, light, window, gc,
	      0,  45 - ((value1 * 45) / total1),
	      16, ((value1 * 45) / total1),
	      1+8*no_shape,  1+8*no_shape+45 - ((value1 * 45) / total1));
    
    XCopyArea(display, light, window, gc,
	      0,  45 - ((value2 * 45) / total2),
	      16, ((value2 * 45) / total2),
	      1+8*no_shape+29,  1+8*no_shape+45 - ((value2 * 45) / total2));
    
    XCopyArea(display, light, icon, gc,
	      0,  45 - ((value1 * 45) / total1),
	      16, ((value1 * 45) / total1),
	      1+8*no_shape,  1+8*no_shape+45 - ((value1 * 45) / total1));
    
    XCopyArea(display, light, icon, gc,
	      0,  45 - ((value2 * 45) / total2),
	      16, ((value2 * 45) / total2),
	      1+8*no_shape+29,  1+8*no_shape+45 - ((value2 * 45) / total2));
  }
}


Pixel
get_color(display, root, name)
     Display* display;
     Window   root;
     char*    name;
{
  XColor            color;
  XWindowAttributes attr;
  
  XGetWindowAttributes(display, root, &attr);
  color.pixel = 0;
  XParseColor(display, attr.colormap, name, &color);
  XAllocColor(display, attr.colormap, &color);

  return color.pixel;
}


#define OPT_HELP          'h'
#define OPT_VERSION       1
#define OPT_ICONIC        'i'
#define OPT_WITHDRAWN     'w'
#define OPT_TWO_CPUS      '2'
#define OPT_SHAPE         's'
#define OPT_CPU_SUM       2
#define OPT_CPU           'c'
#define OPT_MEM           'm'
#define OPT_SWAP          3
#define OPT_MEM_SWAP      4
#define OPT_MEM_BUF       5
#define OPT_MEM_BUF_SWAP  6


static struct option option_def[] = {
  { "help",         0, 0, OPT_HELP         },
  { "version",      0, 0, OPT_VERSION      },
  { "iconic",       0, 0, OPT_ICONIC       },
  { "withdrawn",    0, 0, OPT_WITHDRAWN    },
#ifdef HAVE_LIBXEXT
  { "shape",        0, 0, OPT_SHAPE        },
#endif
  { "two-cpus",     0, 0, OPT_TWO_CPUS     },
  { "cpu-sum",      0, 0, OPT_CPU_SUM      },
  { "cpu",          1, 0, OPT_CPU          },
  { "mem",          0, 0, OPT_MEM          },
  { "swap",         0, 0, OPT_SWAP         },
  { "mem+swap",     0, 0, OPT_MEM_SWAP     },
  { "mem+buf",      0, 0, OPT_MEM_BUF      },
  { "mem+swap+buf", 0, 0, OPT_MEM_BUF_SWAP },
  { 0, 0, 0, 0 }
};


void
parse_arguments(argc_ptr, argv, wmstate_ptr, use_shape_ptr,
		tag1_ptr, tag2_ptr)
     int*  argc_ptr;
     char* argv[];
     int*  wmstate_ptr;
     int*  use_shape_ptr;
     int*  tag1_ptr;
     int*  tag2_ptr;
{
  int option = 0;
  int* tag_ptr = tag1_ptr;
  *tag1_ptr = PROC_CPU_SUM;
  *tag2_ptr = PROC_NONE;
  
  while (option != -1) {
    option = getopt_long_only(*argc_ptr, argv, "hiw2s", option_def, 0);

    switch (option) {
      case OPT_VERSION:
	printf("cpuload "VERSION
	       " -- WindowMaker/AfterStep CPU Load Monitor\n");
	printf("Copyright (C) 1997 Marc De Scheemecker\n");
	printf("cpuload comes with NO WARRANTY, "
	       "to the extent permitted by law.\n");
	printf("You may redistribute copies of cpuload under the "
	       "terms of \nthe GNU General Public License.\n");
	printf("For more information about these matters, "
	       "see the file named COPYING.\n");
	exit(2);
	break;
	
      case OPT_HELP:
	printf("Usage: %s [OPTION]... [ELEMENT]...\n", argv[0]);
	printf("Displays an indicator representing the indicated elements.\n");
	printf("\n");
	printf("  -2, --two-cpus     same as --cpu 0 --cpu 1\n");
	printf("  -h, --help         display this help and exit\n");
	printf("  -i, --iconic       start as an icon\n");
#ifdef HAVE_LIBXEXT
	printf("  -s, --shape        make a shaped window\n");
#endif
	printf("  -w, --withdrawn    withdraw the window\n");
	printf("      --version      output version information and exit\n\n");
	printf("Elements:\n");
	printf("  --cpu id           relative load of cpu id (SMP only)\n");
	printf("  --cpu-sum          summary (average) of all cpu's\n");
	printf("  --mem              core memory usage\n");
	printf("  --mem+buf          core memory usage including buffers and "
	       "cache\n");
	printf("  --swap             swap space usage\n");
	printf("  --mem+swap         sum of core memory and swap\n");
	printf("  --mem+swap+buf     same as --mem+swap including buffers and "
	       "cache\n\n");
	printf("Report bugs to marc@netvision.be\n");
	exit(2);
	break;

      case OPT_ICONIC:
	*wmstate_ptr = IconicState;
	break;
	
      case OPT_WITHDRAWN:
	*wmstate_ptr = WithdrawnState;
	break;
	
      case OPT_TWO_CPUS:
	*tag1_ptr = PROC_CPU+0;
	*tag2_ptr = PROC_CPU+1;
	tag_ptr = tag2_ptr;
	break;

#ifdef HAVE_LIBXEXT
      case OPT_SHAPE:
	*use_shape_ptr = 1;
	break;
#endif

      case OPT_CPU_SUM:
	*tag_ptr = PROC_CPU_SUM;
	tag_ptr = tag2_ptr;
	break;
	
      case OPT_CPU:	
	*tag_ptr = PROC_CPU + atoi(optarg);
	tag_ptr = tag2_ptr;
	break;
	
      case OPT_MEM:
	*tag_ptr = PROC_MEM;
	tag_ptr = tag2_ptr;
	break;
	
      case OPT_SWAP:
	*tag_ptr = PROC_SWAP;
	tag_ptr = tag2_ptr;
	break;
	
      case OPT_MEM_SWAP:
	*tag_ptr = PROC_MEM_SWAP;
	tag_ptr = tag2_ptr;
	break;
	
      case OPT_MEM_BUF:
	*tag_ptr = PROC_MEM_BUF;
	tag_ptr = tag2_ptr;
	break;
	
      case OPT_MEM_BUF_SWAP:
	*tag_ptr = PROC_MEM_BUF_SWAP;
	tag_ptr = tag2_ptr;
	break;
    }
  }

  if (*tag2_ptr != PROC_NONE) {
    back = back2;
  }
}


int
main(argc, argv)
     int   argc;
     char* argv[];
{
  Display*          display = 0;
  int               screen  = 0;
  Window            root    = 0;
  Window            window  = 0;
  Window            icon    = 0;
  GC                gc      = 0;
  unsigned long     gcm     = GCForeground|GCBackground|GCGraphicsExposures;
  XGCValues         gcv;
  XWindowAttributes attr;
  Pixel             black, white;
  XWMHints          wmhints;
  XSizeHints        sizehints;
  XClassHint        classhint;
  char*             geometry = "";
  int               dummy = 0;
  char*             wname = "cpuload";
  XTextProperty     name;
  int               use_shape = 0;
  int               tag1, tag2;

  display = XOpenDisplay(0);
  screen = DefaultScreen(display);
  root = RootWindow(display, screen);

  XGetWindowAttributes(display, root, &attr);
  XpmCreatePixmapFromData(display, root, back1_xpm, &back1, 0,
                          (XpmAttributes*)&attr);
  XpmCreatePixmapFromData(display, root, back2_xpm, &back2, 0,
                          (XpmAttributes*)&attr);
  XpmCreatePixmapFromData(display, root, light_xpm, &light, 0,
                          (XpmAttributes*)&attr);
  back = back1;

  black = get_color(display, root, "black");
  white = get_color(display, root, "white");

  sizehints.flags= USSize|USPosition;
  sizehints.x = 0;
  sizehints.y = 0;
  wmhints.initial_state = NormalState;

  parse_arguments(&argc, argv, &(wmhints.initial_state), &use_shape,
		  &tag1, &tag2);
  
  XWMGeometry(display, screen, geometry, NULL, 1, &sizehints,
	      &(sizehints.x), &(sizehints.y),
	      &(sizehints.width) ,&(sizehints.height), &dummy);
  sizehints.width  = attr.width;
  sizehints.height = attr.height;

  if (use_shape) {
    if (back == back1) {
      sizehints.width = mask1_width;
      sizehints.height = mask1_height;
    }
    else {
      sizehints.width = mask2_width;
      sizehints.height = mask2_height;
    }
  }
  else {
    sizehints.width = sizehints.height = 64;
  }
  
  window = XCreateSimpleWindow(display, root, 0, 0,
			       sizehints.width, sizehints.height,
			       0, black, white);
  icon = XCreateSimpleWindow(display, root, 0, 0,
			     sizehints.width, sizehints.height,
			     0, black, white);
  XSetWMNormalHints(display, window, &sizehints);
  classhint.res_name =  "cpuload";
  classhint.res_class = "CPULoad";
  XSetClassHint(display, window, &classhint);
  XSelectInput(display, window, MW_EVENTS);
  XSelectInput(display, icon, MW_EVENTS);
  XSetCommand(display, window, argv, argc);
  XStringListToTextProperty(&wname, 1, &name);
  XSetWMName(display, window, &name);
  
  gcv.foreground = black;
  gcv.background = white;
  gcv.graphics_exposures = 0;
  gc = XCreateGC(display, root, gcm, &gcv);  

#ifdef HAVE_LIBXEXT
  if (use_shape) {
    Pixmap mask;

    if (back == back1) {
      mask = XCreateBitmapFromData(display, icon, mask1_bits,
				   mask1_width, mask1_height);
    }
    else {
      mask = XCreateBitmapFromData(display, icon, mask2_bits,
				   mask2_width, mask2_height);
    }
    
    XShapeCombineMask(display, window, ShapeBounding, 0, 0, mask, ShapeSet);
    XShapeCombineMask(display, icon, ShapeBounding, 0, 0, mask, ShapeSet);
  }
#endif
  
  wmhints.icon_window = icon;
  wmhints.icon_x = sizehints.x;
  wmhints.icon_y = sizehints.y;
  wmhints.window_group = window;
  wmhints.flags = StateHint|IconWindowHint|IconPositionHint|WindowGroupHint;
  XSetWMHints(display, window, &wmhints); 

  XMapWindow(display, window);

  for (;;) {
    redraw_window(display, window, icon, gc, use_shape, tag1, tag2);
    while (XPending(display)) {
      XEvent event;
      XNextEvent(display, &event);
      switch (event.type)
	{
	case Expose:
	  if (event.xexpose.count == 0) {
	    redraw_window(display, window, icon, gc, use_shape, tag1, tag2);
	  }
	  break;
	  
	case DestroyNotify:
	  XFreeGC(display, gc);
	  XDestroyWindow(display, window);
	  XDestroyWindow(display, icon);
	  XCloseDisplay(display);
	  exit(0);
	  break;

	default:
	  break;
	}
    }
    XFlush(display);
    usleep(200000L);
  }

  return 0;
}
