/*************************************************************************
** interpcom-3.1    (command interpreter)                                **
** messg.c : Messages and command names                                  **
**                                                                       **
** Copyright (C) 2003  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      UMR 7586 du CNRS                                                 **
**      173, rue du Chevaleret                                           **
**      75013 Paris                                                      **
**      France                                                           **
**                                                                       **
 *************************************************************************/


/*--------------------------------------------------------------------
        English
--------------------------------------------------------------------*/
#ifdef _ENG_LANG
char           *mess_interp[] =
{
    "Missing parameter",                                      /* 0    */
    "Incorrect file name",                                    /* 1    */
    "Incorrect numerical parameter",                          /* 2    */
    "Incorrect second parameter",                             /* 3    */
    "Too many conditional variables",                         /* 4    */
    "Too many open files",                                    /* 5    */
    "Non opened file",                                        /* 6    */
    "Incorrect question file",                                /* 7    */
    "Incorrect object name",                                  /* 8    */
    "Too long object name",                                   /* 9    */
    "Too many objects of this type",                          /* 10   */
    "Already used name",                                      /* 11   */
    "Unknown object",                                         /* 12   */
    "Incorrect number of object or structure types",          /* 13   */
    "Incorrect objects",                                      /* 14   */
    "Incorrect saved object",                                 /* 15   */
    "Too long structure name",                                /* 16   */
    "Too many structures of this type",                       /* 17   */
    "Unknown structure",                                      /* 18   */
    "Incorrect member name",                                  /* 19   */
    "Incorrect command file name",                            /* 20   */
    "Incorrect structure name",                               /* 21   */
    "Incorrect program file",                                 /* 22   */
    "Incorrect program file name",                            /* 23   */
    "Unknown program",                                        /* 24   */
    "Incorrect command in this context",                      /* 25   */
    "Already used program name",                              /* 26   */
    "Too many lines",                                         /* 27   */
    "Unknown program",                                        /* 28   */
    "File already open for reading",                          /* 29   */
    "File already open for writing",                          /* 30   */
    "Too many threads",                                       /* 31   */
    "Already used thread name",                               /* 32   */
    "Incorrect first parameter",                              /* 33   */
    "Too long directory name",                                /* 34   */
    "Non global variable",                                    /* 35   */
    "Only the main thread is running",                        /* 36   */
    "Too many string variables",                              /* 37   */
    "Unknown string variable",                                /* 38   */
    "This command can be used only in the main thread",       /* 39   */
    "Other threads are running",                              /* 40   */
    "Already used string variable",                           /* 41   */
    "Initialization file not found",                          /* 42   */
    "Incorrect program name",                                 /* 43   */
    "Incorrect program",                                      /* 44   */
    "Incorrect number of parameters",                         /* 45   */
    "Already used command name",                              /* 46   */
    "Incorrect parameter",                                    /* 47   */
    "Incorrect type of variable",                             /* 48   */
    "Too many object types",                                  /* 49   */
    "Incorrect number of dimensions",                         /* 50   */
    "Incorrect maximal number of objects",                    /* 51   */
    "Alias of an undefined object type",                      /* 52   */
    "Too many structure types",                               /* 53   */
    "Incorrect number of members",                            /* 54   */
    "Unknown variable",                                       /* 55   */
    "Unknown thread",                                         /* 56   */
    "Type 'exit' to kill the main thread",                    /* 57   */
    "Objects of undefined data type",                         /* 58   */
    "Incorrect object type(s)",                               /* 59   */
    "Incorrect expression evaluator",                         /* 60   */
    "Unknown color",                                          /* 61   */
    "Unknown object or structure",                            /* 62   */
    "The file ",                                              /* 63   */
    " has been created",                                      /* 64   */
    "No thread support",                                      /* 65   */
    "Too many programs",                                      /* 66   */
    "Incorrect function name",                                /* 67   */
    "Too many variables",                                     /* 68   */
    "Incorrect variable name",                                /* 69   */
    "Too many functions",                                     /* 70   */
    "Unknown function",                                       /* 71   */

    ""
};

/* English command names */
char           *names_interp[]  =
{
    "add",                                                    /* 67   */
    "assign",                                                 /* 68   */
    "ch_expr",                                                /* 69   */
    "clock",                                                  /* 70   */
    "close",                                                  /* 71   */
    "cmultiply",                                              /* 72   */
    "color_echo",                                             /* 73   */
    "conjg",                                                  /* 74   */
    "const",                                                  /* 75   */
    "const_c",                                                /* 76   */
    "const_r",                                                /* 77   */
    "const_th",                                               /* 78   */
    "copy",                                                   /* 79   */
    "delcom",                                                 /* 80   */
    "deldat",                                                 /* 81   */
    "delprog",                                                /* 82   */
    "delres",                                                 /* 83   */
    "delstring",                                              /* 84   */
    "depend",                                                 /* 85   */
    "desassign",                                              /* 86   */
    "desc",                                                   /* 87   */
    "destroy",                                                /* 88   */
    "echo",                                                   /* 89   */
    "echof",                                                  /* 90   */
    "echoi",                                                  /* 91   */
    "editor",                                                 /* 92   */
    "end_mon",                                                /* 93   */
    "eval",                                                   /* 94   */
    "exit",                                                   /* 95   */
    "fillobj",                                                /* 96   */
    "flush",                                                  /* 97   */
    "functdef",                                               /* 98   */
    "greet",                                                  /* 99   */
    "help",                                                   /* 100  */
    "hist",                                                   /* 101  */
    "Imag",                                                   /* 102  */
    "initvar",                                                /* 103  */
    "is",                                                     /* 104  */
    "kill",                                                   /* 105  */
    "list",                                                   /* 106  */
    "listfunc",                                               /* 107  */
    "liststr",                                                /* 107  */
    "listt",                                                  /* 108  */
    "load",                                                   /* 109  */
    "loop",                                                   /* 110  */
    "loopf",                                                  /* 111  */
    "mkcomplex",                                              /* 112  */
    "mkpolaire",                                              /* 113  */
    "mon",                                                    /* 114  */
    "mult",                                                   /* 115  */
    "multiply",                                               /* 116  */
    "numcom",                                                 /* 117  */
    "objdef",                                                 /* 118  */
    "pause",                                                  /* 119  */
    "phase",                                                  /* 120  */
    "proglist",                                               /* 121  */
    "question",                                               /* 122  */
    "radius",                                                 /* 123  */
    "read",                                                   /* 124  */
    "Real",                                                   /* 125  */
    "repete",                                                 /* 126  */
    "restore",                                                /* 127  */
    "send_print",                                             /* 128  */
    "setdir",                                                 /* 129  */
    "setobj",                                                 /* 130  */
    "shell",                                                  /* 131  */
    "si",                                                     /* 132  */
    "silence",                                                /* 133  */
    "string",                                                 /* 134  */
    "strucdef",                                               /* 135  */
    "substract",                                              /* 136  */
    "svg",                                                    /* 137  */
    "thread",                                                 /* 138  */
    "time",                                                   /* 139  */
    "trace",                                                  /* 140  */
    "undef",                                                  /* 141  */
    "undepend",                                               /* 142  */
    "update",                                                 /* 143  */
    "varlist",                                                /* 144  */
    "wait",                                                   /* 145  */
    "write",                                                  /* 146  */
};


/* Expression evaluator error messages */
char           *_EXPREV_errmessg[] = {
    "Syntax error",                                           /* 147  */
    "Unbalanced parenthesis",                                 /* 148  */
    "Division by zero",                                       /* 149  */
    "Unknown variable",                                       /* 150  */
    "Too many variables",                                     /* 151  */
    "Unknown function",                                       /* 152  */
    "Wrong number of arguments",                              /* 153  */
    "Wrong number of arguments",                              /* 154  */
};

char           *_TIME_messg[] = {
    " ; Execution time : ",                                   /* 155  */
    "Time : ",                                                /* 156  */
};

char           *_PROGREPL_messg[] = {
    "Program ",                                               /* 157  */
    " replaced ",                                             /* 158  */
};

char           *_INITERR_messg[] = {
    "Error in the section ",                                  /* 159  */
    " of the initialization file",                            /* 160  */
    "Error in the initialization file",                       /* 161  */
    "Line ",                                                  /* 162  */
};

char           *_DELPROG_messg[] = {
    "Destruction of program ",                                /* 163  */
    " not allowed",                                           /* 164  */
};

char           *_MEMMC_messg[] = {
    "Incorrect arrays",                                       /* 165  */
    "Incorrect stored array",                                 /* 166  */
};

char           *_INTCOM_colors[] = {
    "black",                                                  /* 167  */
    "red",                                                    /* 168  */
    "green",                                                  /* 169  */
    "yellow",                                                 /* 170  */
    "blue",                                                   /* 171  */
    "violet",                                                 /* 172  */
    "lightblue",                                              /* 173  */
    "white",                                                  /* 174  */
};

#endif
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    French
--------------------------------------------------------------------*/
#ifdef _FR_LANG
char           *mess_interp[] =
{
    "Param?tre manquant",                                     /* 0    */
    "Nom de fichier incorrect",                               /* 1    */
    "Param?tre num?rique incorrect",                          /* 2    */
    "Second param?tre incorrect",                             /* 3    */
    "Trop de variables conditionnelles",                      /* 4    */
    "Trop de fichiers ouverts",                               /* 5    */
    "Fichier non ouvert",                                     /* 6    */
    "Fichier de questions incorrect",                         /* 7    */
    "Nom d'objet incorrect",                                  /* 8    */
    "Nom d'objet trop long",                                  /* 9    */
    "Trop d'objets de ce type d?finis",                       /* 10   */
    "Nom dej? utilis?",                                       /* 11   */
    "Objet inexistant",                                       /* 12   */
    "Numero de type d'objet ou de structure incorrect",       /* 13   */
    "Objets incorrects",                                      /* 14   */
    "Objet enregistr? incorrect",                             /* 15   */
    "Nom de structure trop long",                             /* 16   */
    "Trop de structures de ce type d?finies",                 /* 17   */
    "Structure inexistante",                                  /* 18   */
    "Nom de membre incorrect",                                /* 19   */
    "Nom de fichier de commandes incorrect\n",                /* 20   */
    "Nom de structure incorrect",                             /* 21   */
    "Fichier de programme incorrect",                         /* 22   */
    "Nom de fichier de programme incorrect",                  /* 23   */
    "Programme inconnu",                                      /* 24   */
    "Commande incorrecte dans ce contexte",                   /* 25   */
    "Nom de programme dej? utilis?",                          /* 26   */
    "Nombre de lignes trop grand",                            /* 27   */
    "Programme inexistant",                                   /* 28   */
    "Fichier dej? ouvert en lecture",                         /* 29   */
    "Fichier dej? ouvert en ecriture",                        /* 30   */
    "Trop de threads",                                        /* 31   */
    "Nom de thread dej? utilis?",                             /* 32   */
    "Premier param?tre incorrect",                            /* 33   */
    "Nom de r?pertoire trop long",                            /* 34   */
    "Variable non globale",                                   /* 35   */
    "Seul le thread principal existe",                        /* 36   */
    "Trop de chaines de caract?res",                          /* 37   */
    "Chaine de caract?res inconnues",                         /* 38   */
    "Commande utilisable seulement dans le thread principal", /* 39   */
    "D'autres threads sont en cours d'ex?cution",             /* 40   */
    "Nom de chaine de caract?res dej? utilis?",               /* 41   */
    "Fichier d'initialisation non trouv?",                    /* 42   */
    "Nom de programme incorrect",                             /* 43   */
    "Programme incorrect",                                    /* 44   */
    "Nombre de param?tres incorrect",                         /* 45   */
    "Nom de commande dej? utilis?",                           /* 46   */
    "param?tre incorrect",                                    /* 47   */
    "Type de variable incorrect",                             /* 48   */
    "Trop de types d'objet"                                   /* 49   */
    "Nombre de dimensions incorrect",                         /* 50   */
    "Nombre maximal d'objets incorrect",                      /* 51   */
    "Alias d'un type d'objet inconnu",                        /* 52   */
    "Trop de types de structure",                             /* 53   */
    "Nombre de membres incorrect",                            /* 54   */
    "Variable inconnue",                                      /* 55   */
    "Thread inconnu",                                         /* 56   */
    "Faire 'exit' pour tuer le thread main",                  /* 57   */
    "Objets de type ind?termin?",                             /* 58   */
    "Type d'objet incorrect",                                 /* 59   */
    "Evaluateur d'expressions incorrect",                     /* 60   */
    "Couleur inconnue",                                       /* 61   */
    "Objet ou structure inconnu",                             /* 62   */
    "Le fichier ",                                            /* 63   */
    " a ?t? cr??",                                            /* 64   */
    "threads non impl?ment?s",                                /* 65   */
    "Trop de programmes",                                     /* 66   */
    "Nom de fonction incorrect",                              /* 67   */
    "Trop de variables",                                      /* 68   */
    "Nom de variable incorrect",                              /* 69   */
    "Trop de fonctions",                                      /* 70   */

    ""
};

/* French command names */
char           *names_interp[]  =
{
    "ajoute",
    "assign",
    "ch_expr",
    "horloge",
    "close",
    "cmultiplie",
    "color_echo",
    "conjg",
    "const",
    "const_c",
    "const_r",
    "const_th",
    "copie",
    "delcom",
    "deldat",
    "delprog",
    "delres",
    "delstring",
    "depend",
    "desassign",
    "desc",
    "detruit",
    "echo",
    "echof",
    "echoi",
    "editeur",
    "fin_mon",
    "eval",
    "exit",
    "fillobj",
    "flush",
    "functdef",
    "greet",
    "help",
    "hist",
    "Imag",
    "initvar",
    "is",
    "kill",
    "list",
    "listfunc",
    "liststr",
    "listt",
    "load",
    "boucle",
    "bouclef",
    "mkcomplex",
    "mkpolaire",
    "mon",
    "mult",
    "multiplie_",
    "numcom",
    "objdef",
    "pause",
    "phase",
    "progliste",
    "question",
    "radius",
    "lit",
    "Real",
    "repete",
    "restore",
    "send_print",
    "setdir",
    "setobj",
    "shell",
    "si",
    "silence",
    "string",
    "strucdef",
    "soustrait_",
    "svg",
    "thread",
    "time",
    "trace",
    "undef",
    "undepend",
    "update",
    "varlist",
    "attends",
    "ecrit",
};

/* Expression evaluator error messages */
char           *_EXPREV_errmessg[] = {
    "Erreur de syntaxe",
    "Probl?me de parenth?se",
    "Division par z?ro",
    "Variable inconnue",
    "Trop de variables",
    "Fonction inconnue",
    "Nombre d'arguments incorrect",
    "Argument manquant",
};

char           *_TIME_messg[] = {
    " ; Temps d'ex?cution : ",
    "Temps : ",
};

char           *_PROGREPL_messg[] = {
    "Programme ",
    " remplace ",
};

char           *_INITERR_messg[] = {
    "Erreur dans la section ",
    " du fichier d'initialisation",
    "Erreur dans le fichier d'initialisation",
    "Ligne ",
};

char           *_DELPROG_messg[] = {
    "Destruction du programme ",
    " interdite",
};

char           *_MEMMC_messg[] = {
    "Tableaux incorrects",
    "Tableau enregistr? incorrect",
};

char           *_INTCOM_colors[] = {
    "noir",
    "rouge",
    "vert",
    "jaune",
    "bleu",
    "violet",
    "bleuclair",
    "blanc",
};
#endif
/*------------------------------------------------------------------*/
