/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995.  The Regents of the University of California.  All rights   */
/*   reserved.                                                             */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#ifndef __xdir_h
#define __xdir_h

#include <sys/param.h>
#include <Xm/Xm.h>
#ifdef ISC    /* SunSoft ISC Unix 4.0 */
#include <sys/limits.h>
#endif

#define SYS_UNIX 0
#define SYS_VMS  1
#define SYS_MAC  2
#define SYS_DOS  3
#define SYS_NT   4

#define SERVER_UNKNOWN           0
#define SERVER_VMS_3_0           1
#define SERVER_VMS_MULTINET      2
#define SERVER_MAC_VERSATERM     3
#define SERVER_MAC_NCSATELNET    4
#define SERVER_MAC_FTPD          5
#define SERVER_DOS_WINQVT        6
#define SERVER_NT                7
#define SERVER_UNIX_UNITREE      8
#define SERVER_UNIX_NSL_UNITREE  9

#define MAXHOSTS     10
#define MAXHOSTDIRS  20

#define MAXVIEWERS   20

#define REPLACE    0
#define ADD        1

#define SEARCH_THIS_DIR   0
#define SEARCH_THIS_HOST  1
#define SEARCH_ALL_HOSTS  2

#define QUIET      0
#define NORMAL     1
#define VERBOSE    2
#define DEBUG      3

#define LOCAL      0

#define ASCII  0
#define BINARY 1

#define MAXFTPREPLY 500
#define MAXFTPLINE  200
#define MAXTCPBUF   1024
#define MAXT 60

#define MAXLINKS    20

#define MAXSEARCHDEPTH  20
#define MAXDIRHISTORY   25
#define MAXLAUNCH       25
#define MAXLEVELS       20

#define UNSELECTED  0
#define SELECTED    1

#define UNKNOWN_TYPE    0
#define DIRECTORY_TYPE  1
#define FILE_TYPE       2
#define LINK_TYPE       3
#define SOCKET_TYPE     4
#define EXECUTABLE_TYPE 5

#define TMARGIN   1
#define IHEIGHT   12
#define IWIDTH    12
#define IMARGIN   4
#define HMARGIN   10
#define VTMARGIN  10
#define VBMARGIN  0
#define HSPACING  6
#define VSPACING  3
#define INDENT    25
#define CWIDTH    12
#define CHEIGHT   12
#define CMARGIN   4

#define TABULAR    0
#define ICONIC     1
#define TREE       2
#define FULL_INFO  3

#define HINCREMENT 5

#ifndef MAXPATHLEN
#ifdef PATH_MAX
#define MAXPATHLEN PATH_MAX
#else
#ifdef PATHSIZE
#define MAXPATHLEN PATHSIZE
#endif
#endif
#endif

#ifndef MIN
#define MIN(a, b) (((a)<(b))?(a):(b))
#endif

#ifndef MAX
#define MAX(a, b) (((a)>(b))?(a):(b))
#endif

#if defined (SYSV) || defined (SYSV386) || defined(SVR4)
#define bzero(b, n)         memset(b, 0, n)
#define bcopy(b1, b2, n)    memcpy(b2, b1, n)
#endif

struct st_host_info {
	int		in_use;		/* Is this struct in use? */
    int     ctrl_fd;    /* For remote hosts */
	int		system;		/* System of FTP server (e.g., SYS_UNIX) */
	int		server;		/* FTP server */
    char    *homedir;   /* Home directory */
    char    *hostname;  /* Name of host */
    char    *username;  /* Name of user */
    char    *password;  /* Password */
    char    *account;   /* Account */
};

struct entry_info {
    char state;
	char original_state;
	char type;
	char expanded;
    char *name;
	char *info;
	int indx;
	int width;
	int level;
	struct dirwin_st *dirwin;
};

struct dirwin_st {
	struct dirwin_st *next;
	struct dirwin_st *prev;
	Widget w_shell;
	Widget w_form;
	Widget w_menuForm;
    Widget w_scrolledWindow;
	Widget w_drawingAreaFrame;
    Widget w_drawingArea;
	Widget w_deleteItem;
	Widget w_renameItem;
	Widget w_viewItem;
	Widget w_searchAgainItem;
	Widget w_quotedItem;
	Widget w_xferModeMenu;
	Widget w_asciiItem;
	Widget w_binaryItem;
	Widget w_ancestorsMenu;
	Widget w_ancestorsMenuItem[MAXLEVELS];
	Widget w_popupAncestorsMenu;
	Widget w_popupAncestorsMenuItem[MAXLEVELS];
	Widget w_gotoMenu;
	Widget w_gotoMenuItem[MAXDIRHISTORY];
	Widget w_launchMenu;
	Widget w_launchMenuItem[MAXLAUNCH];
	Widget w_popupLaunchMenu;
	Widget w_popupLaunchMenuItem[MAXLAUNCH];
	Widget w_winsMenu;
	Widget w_viewedFilesMenu;
	Widget w_viewedFilesMenuItem[MAXVIEWERS];
	Widget w_hostDirMenu[MAXHOSTS];
	Widget w_hostDirMenuItem[MAXHOSTS][MAXHOSTDIRS];
	Widget w_toolbarForm;
	Widget w_deleteButton;
	Widget w_tabularButton;
	Widget w_iconicButton;
	Widget w_treeButton;
	Widget w_fullInfoButton;
	Widget w_tunnelingButton;
	Widget w_dotFilesButton;
	Widget w_cacheButton;
	Widget w_upArrowButton;
	Widget w_urButton;
	Widget w_dirMenuBar;
	Widget w_cacheMsg;
   	Window input_windows[4];
	int host;
   	int has_selection;
	int layout;
    int ncols;
    int nrows;
	int nrows_visible;
	int first_visible_row;
	int nhincrements;
	int nhincrements_visible;
	int first_visible_hincrement;
	int virtual_width;
    char *dirname;
	int max_entry_width;
    int entry_height;
    int nentries;
    struct entry_info *entries;
	int temp_for_search;
	int max_host_menu_used;
	int tunneling_mode;
	int dotfiles_mode;
	int cache_mode;
};

#endif  /* __xdir_h */

