/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995.  The Regents of the University of California.  All rights   */
/*   reserved.                                                             */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <stdio.h>
#include <sys/param.h>
#include <Xm/Label.h>
#include <Xm/Form.h>
#include <Xm/TextF.h>
#include "xdir.h"

static int search_monitor_in_use = False;

static struct {
	Widget w_dialog;
	Widget w_patternLabel;
	Widget w_pattern;
	Widget w_hostLabel;
	Widget w_host;
	Widget w_userLabel;
	Widget w_user;
	Widget w_dirLabel;
	Widget w_dir;
} search_monitor;

extern Widget w_toplev;
extern Display *display;
extern struct st_host_info hinfo[];

void cb_search_monitor_close();
void cb_map_dialog();
char *cstring_to_text();


/*
 * show_search_monitor - Pop up search monitor over directory window
 *                       "dirwin".  "pattern" is the pattern being
 *                       searched for.  "host" is the host being
 *                       searched.  "directory" is the directory
 *                       being searched.
 */
show_search_monitor(dirwin, pattern, host, directory)
struct dirwin_st *dirwin;
char *pattern;
int host;
char *directory;
{
	/* If search monitor already in use, don't display another one */
	if (!search_monitor_in_use) {
		search_monitor_in_use = True;
		create_search_monitor_dialog(dirwin);
		XtManageChild(search_monitor.w_dialog);
		add_dialog_to_list(search_monitor.w_dialog);
		force_update(search_monitor.w_dialog);
	}

	/* Update the search pattern */
	set_textfield(search_monitor.w_pattern, pattern);

	/* Update host name */
	set_textfield(search_monitor.w_host, hinfo[host].hostname);

	/* Update user name */
	if (host == LOCAL)
		set_textfield(search_monitor.w_user, "Local");
	else
		set_textfield(search_monitor.w_user, hinfo[host].username);

	/* Update directory name */
	set_textfield(search_monitor.w_dir, directory);

	XSync(display, 0);
	XmUpdateDisplay(w_toplev);
}


/*
 * hide_search_monitor - Pop down the search monitor.
 */
hide_search_monitor()
{
	/* Might be already hidden */
	if (!search_monitor_in_use)
		return;
	search_monitor_in_use = False;

	/* Remove dialog from cursor linked list */
	remove_dialog_from_list(search_monitor.w_dialog);

	/* Get rid of search monitor */
	XtDestroyWidget(XtParent(search_monitor.w_dialog));
}


/*
 * create_search_monitor_dialog - Create dialog window that displays the
 *                                directory entry currently being operated 
 *                                on.  Position over directory window
 *                                "dirwin".
 */
create_search_monitor_dialog(dirwin)
struct dirwin_st *dirwin;
{
	Arg args[3];
	int i;

    /* Create form dialog to display current entry being operated on */
    i = 0;
	XtSetArg(args[i], XmNmarginWidth, 10); i++;
	XtSetArg(args[i], XmNmarginHeight, 20); i++;
	XtSetArg(args[i], XmNresizePolicy, XmRESIZE_NONE); i++;
    search_monitor.w_dialog = XmCreateFormDialog(dirwin->w_shell,
		"searchMonitor", args, i);
	XtAddCallback(search_monitor.w_dialog, XmNmapCallback, cb_map_dialog,
		(XtPointer)XtWindow(dirwin->w_shell));

	/* Add callback for the WM_DELETE_WINDOW protocol */
	add_wm_delete_window_cb(search_monitor.w_dialog, cb_search_monitor_close,
		NULL, False);

	/* Create pattern label */
    search_monitor.w_patternLabel = XtVaCreateManagedWidget(
        "patternLabel",
        xmLabelWidgetClass,
        search_monitor.w_dialog,
		XmNtopAttachment,		XmATTACH_FORM,
        XmNleftAttachment,  	XmATTACH_FORM,
        NULL
    );

	/* Create host label */
    search_monitor.w_hostLabel = XtVaCreateManagedWidget(
        "hostLabel",
        xmLabelWidgetClass,
        search_monitor.w_dialog,
		XmNtopAttachment,		XmATTACH_WIDGET,
		XmNtopWidget,			search_monitor.w_patternLabel,
        XmNleftAttachment,  	XmATTACH_FORM,
        NULL
    );

	/* Create user label */
    search_monitor.w_userLabel = XtVaCreateManagedWidget(
        "userLabel",
        xmLabelWidgetClass,
        search_monitor.w_dialog,
		XmNtopAttachment,		XmATTACH_WIDGET,
		XmNtopWidget,			search_monitor.w_hostLabel,
        XmNleftAttachment,  	XmATTACH_FORM,
        NULL
    );

	/* Create directory label */
    search_monitor.w_dirLabel = XtVaCreateManagedWidget(
        "dirLabel",
        xmLabelWidgetClass,
        search_monitor.w_dialog,
		XmNtopAttachment,		XmATTACH_WIDGET,
		XmNtopWidget,			search_monitor.w_userLabel,
        XmNleftAttachment,  	XmATTACH_FORM,
		XmNbottomAttachment,	XmATTACH_FORM,
        NULL
    );

    /* Create directory path */
    search_monitor.w_dir= XtVaCreateManagedWidget(
        "dir",
        xmTextFieldWidgetClass,
        search_monitor.w_dialog,
		XmNshadowThickness,			0,
		XmNmarginHeight,			0,
		XmNmarginWidth,				0,
		XmNtraversalOn,				False,
		XmNeditable,				False,
		XmNcursorPositionVisible,	False,
		XmNalignment,				XmALIGNMENT_BEGINNING,
        XmNtopAttachment,   		XmATTACH_OPPOSITE_WIDGET,
        XmNtopWidget,       		search_monitor.w_dirLabel,
        XmNleftAttachment,  		XmATTACH_WIDGET,
		XmNleftWidget,				search_monitor.w_dirLabel,
        XmNleftOffset,      		5,
		XmNrightAttachment,			XmATTACH_FORM,
        NULL
    );

    /* Create user name */
    search_monitor.w_user= XtVaCreateManagedWidget(
        "user",
        xmTextFieldWidgetClass,
        search_monitor.w_dialog,
		XmNshadowThickness,			0,
		XmNmarginHeight,			0,
		XmNmarginWidth,				0,
		XmNtraversalOn,				False,
		XmNeditable,				False,
		XmNcursorPositionVisible,	False,
		XmNtopAttachment,			XmATTACH_OPPOSITE_WIDGET,
		XmNtopWidget,				search_monitor.w_userLabel,
		XmNtopOffset,				-1,
        XmNleftAttachment,  		XmATTACH_OPPOSITE_WIDGET,
		XmNleftWidget,				search_monitor.w_dir,
		XmNrightAttachment,			XmATTACH_FORM,
        NULL
    );

    /* Create host name */
    search_monitor.w_host= XtVaCreateManagedWidget(
        "host",
        xmTextFieldWidgetClass,
        search_monitor.w_dialog,
		XmNshadowThickness,			0,
		XmNmarginHeight,			0,
		XmNmarginWidth,				0,
		XmNtraversalOn,				False,
		XmNeditable,				False,
		XmNcursorPositionVisible,	False,
		XmNtopAttachment,			XmATTACH_OPPOSITE_WIDGET,
		XmNtopWidget,				search_monitor.w_hostLabel,
		XmNtopOffset,				-1,
        XmNleftAttachment,  		XmATTACH_OPPOSITE_WIDGET,
		XmNleftWidget,				search_monitor.w_user,
		XmNrightAttachment,			XmATTACH_FORM,
        NULL
    );

    /* Create pattern */
    search_monitor.w_pattern= XtVaCreateManagedWidget(
        "pattern",
        xmTextFieldWidgetClass,
        search_monitor.w_dialog,
		XmNshadowThickness,			0,
		XmNmarginHeight,			0,
		XmNmarginWidth,				0,
		XmNtraversalOn,				False,
		XmNeditable,				False,
		XmNcursorPositionVisible,	False,
		XmNtopAttachment,			XmATTACH_OPPOSITE_WIDGET,
		XmNtopWidget,				search_monitor.w_patternLabel,
		XmNtopOffset,				-1,
        XmNleftAttachment,  		XmATTACH_OPPOSITE_WIDGET,
		XmNleftWidget,				search_monitor.w_host,
		XmNrightAttachment,			XmATTACH_FORM,
        NULL
    );
}


/*
 * cb_search_monitor_close - Callback to handle closes from window manager.
 *                           A close is not allowed.
 */
void
cb_search_monitor_close(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	beep();
}

