/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995.  The Regents of the University of California.  All rights   */
/*   reserved.                                                             */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <Xm/Xm.h>
#include "xdir.h"
#include "list.h"

extern struct st_host_info hinfo[];
extern int use_last_dir;
extern struct dirwin_st *dirwin_head;
extern Display *display;

char *local_host_name();
#ifdef NEXT
char *cuserid();
#endif
#ifdef __sony_news
char *getlogin();
#endif


/*
 * init_local_host - Initialize host structure for local host.
 */
init_local_host()
{
	char *homedir;
	char *username;

	/* Local host is always in use */
	hinfo[LOCAL].in_use = True;

	/* Can assume that local host is Unix */
	hinfo[LOCAL].system = SYS_UNIX;
	hinfo[LOCAL].server = SERVER_UNKNOWN;

	/* Get host name */
	hinfo[LOCAL].hostname = local_host_name();

	/* Get user name */
#ifdef __sony_news
	if((username = getenv("USER")) || (username = getlogin()))
#else
	if((username = getenv("USER")) || (username = cuserid(NULL)))
#endif
		hinfo[LOCAL].username = XtNewString(username);
	else
		hinfo[LOCAL].username = XtNewString("");

    /* What is the home directory?  Get actual name */
    homedir = XtNewString(getenv("HOME"));
    if (local_cd(homedir, True) < 0)
        fatal_error("Unable to cd to home directory");
    XtFree(homedir);
    if (local_pwd(&homedir) != 0)
        fatal_error("Unable to get home directory");
    hinfo[LOCAL].homedir = homedir;
}


/*
 * connect_to_local - Connect to local host.  "dirwin" is the requesting
 *                    directory window (could be NULL).  Returns 0 if
 *                    successful, else -1.
 */
connect_to_local(dirwin)
struct dirwin_st *dirwin;
{
	char *wd;
	int retval;

	/* Display one of the local host's directories */
	if ((retval = starting_dir(LOCAL, &wd)) == -6)   /* Sanity check */
		fatal_error("Bug in connect_to_local()");
	else if (retval < 0)
		return -1;
	retval = display_dir(LOCAL, dirwin, wd, True, True, False, False);
	if (retval == -6)   /* Sanity check */
		fatal_error("Bug in connect_to_local()");
	XtFree(wd);
	return retval;
}


/*
 * cb_connect_to_local - Callback to "connect" to the local host.
 */
void
cb_connect_to_local(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;
	struct dirwin_st *dwin;

	/* Start operation */
	if (!start_op(False))
		return;

	/* Clear error flag */
	raise_okflag();

	/* If user is already connected, pop up one of the local host's dirwins */
	dwin = dirwin_head;
	while (dwin) {
		if (dwin->host == LOCAL) {
			info_dialog("You are already connected to the local host.",
				dirwin->w_shell);
			XMapRaised(display, XtWindow(dwin->w_shell));
			end_op();
			return;
		}
		dwin = dwin->next;
	}

	/* Do it */
	if (connect_to_local(dirwin) < 0)
		record_and_alert("Unable to connect to local host.", dirwin->w_shell);

	/* End operation */
	end_op();
}

