/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995.  The Regents of the University of California.  All rights   */
/*   reserved.                                                             */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <Xm/Xm.h>
#include "xdir.h"

#define MAX_SELECT_CHARS  30

static char select_chars[MAX_SELECT_CHARS];
static int nselect_chars = 0;
static XtIntervalId select_timer_id;

extern XtAppContext app;
extern int type_to_select_delay;

void cb_select_and_scroll();


/*
 * HandleKeyboardEvents - Process keyboard events in drawing area of
 *                        directory window.
 */
void
HandleKeyboardEvents(widget, client_data, event, continue_to_dispatch_return)
Widget widget;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch_return;
{
	char buf[2];
	int count;

	/* Is some important operation in progress? */
	if (op_in_progress())
		return;

	/* Only want to process key presses */
	if (event->type != KeyPress)
		return;

	/* Don't allow modifier keys (otherwise might get into infinite loop) */
	if (event->xkey.state&Mod1Mask)
		return;

	count = XLookupString((XKeyEvent *)event, buf, 2, (KeySym *)NULL,
		(XComposeStatus *)NULL);
	if (count == 1) {
		if (nselect_chars)
			XtRemoveTimeOut(select_timer_id);
		if (nselect_chars < MAX_SELECT_CHARS)
			select_chars[nselect_chars++] = buf[0];
		else
			beep();
		select_timer_id = XtAppAddTimeOut(app,
			(unsigned long)type_to_select_delay,
			cb_select_and_scroll, client_data);
	}
}


/*
 * cb_select_and_scroll - Timer invoked routine to select (and scroll
 *                        into view) an entry name as determined by
 *                        characters typed into the drawing area of
 *                        a directory window.
 */
void
cb_select_and_scroll(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;
	int indx;

	if (dirwin->nentries) {
		indx = select_using_chars(dirwin, select_chars, nselect_chars);
		scroll_entry_into_view(&(dirwin->entries[indx]));
		clear_selected_entries();
		toggle_entry(&(dirwin->entries[indx]));
	}
	nselect_chars = 0;
}


/*
 * select_using_chars - Returns the index into dirwin->entries of the
 *                      entry that best satisfies the "nchars" selection
 *                      characters in array "chars".  "nchars" must be
 *                      positive.  "entries" must be sorted in ascending
 *                      order.
 */
select_using_chars(dirwin, chars, nchars)
struct dirwin_st *dirwin;
char *chars;
int nchars;
{
	int i;
	char *pattern;

	/* Create string containing pattern */
	pattern = XtMalloc(nchars+1);
	bcopy(chars, pattern, nchars);
	pattern[nchars] = '\0';

	for (i=0; i<dirwin->nentries; i++)
		if ((dirwin->entries[i].level == 0)
				&& (strcmp(dirwin->entries[i].name, pattern) >= 0)) {
			XtFree(pattern);
			return i;
		}
	XtFree(pattern);
	for (i=dirwin->nentries-1; i>=0; i--)
		if (dirwin->entries[i].level == 0)
			return i;

	/* Should never get here.  This line is for making gcc compiler happy */
	return 0;
}

