
/*
 *  Copyright (C) 1999  Wolfgang Zekoll  <wzk@quietsche-entchen.de>
 *
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <errno.h>
#include <time.h>
#include <fcntl.h>

#include <sys/types.h>
#include <sys/stat.h>


#include "lib.h"


char *strlwr(char *string)
{
	unsigned int c;
	int	i, len;

	len = strlen(string);
	for (i=0; i<len; i++) {
		if (isupper(c = string[i]))
			string[i] = tolower(c);
		}

	return (string);
}	

char *skip_ws(char *string)
{
	unsigned int c;

	while ((c = *string) == ' '  ||  c == '\t')
		string++;

	return (string);
}

char *noctrl(char *buffer)
{
	int	len, i;
	unsigned char *p;

	if ((p = buffer) == NULL)
		return (NULL);

	len = strlen(p);
        for (i=len-1; i>=0; i--) {
		if (p[i] <= 32)
			p[i] = '\0';
		else
			break;
		}

	return (p);
}


char *get_word(char **from, char *to, int maxlen)
{
	unsigned int c;
	unsigned char *p;
	int	k;

	maxlen -= 2;
	while ((c = **from) != 0  &&  c <= 32)
		*from += 1;

	*(p = to) = k = 0;
	while ((c = **from) != 0) {
		if (c == ' '  ||  c == '\t'  ||  c < 32)
			break;

		*from += 1;
		if (k < maxlen)
			p[k++] = c;
		}

	p[k] = 0;
	return (to);
}

char *get_quoted(char **from, int quote, char *string, int max)
{
	int	c, k;

	string[0] = k = 0;
	max -= 2;

	while ((c = **from) != 0) {
		*from += 1;
		
		if (c == quote)
			break;
		else {
			if (k < max)
				string[k++] = c;
			}
		}

	string[k] = 0;
	return (string);
}

char *get_string(char **from, char *to, int max)
{
	unsigned int c, d;
	int	k;

	to[0] = k = 0;
	while ((c = **from) != 0  &&  c <= ' ')
		*from += 1;

	if (c == 0)
		return (to);
	else if (c != '"')
		return (get_word(from, to, max));

	*from += 1;
	max -= 2;
	d = c;
	while ((c = **from) != 0) {
		*from += 1;
		if (c == d)
			break;

		if (k < max)
			to[k++] = c;
		}

	to[k] = 0;
	return (to);
}

char *copy_string(char *y, char *x, int len)
{
	int	k;

	x = skip_ws(x);
	len -= 2;	
	for (k=0; x[k] != 0  &&  k < len; k++)
		y[k] = x[k];

	y[k] = 0;
	noctrl(y);

	return (y);
}

