/* $Id: sock.c,v 1.2 1998/08/28 14:25:16 dg8xt Exp $ */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#include "sock.h"

int open_connection(char *hostname, int port)
{
    struct sockaddr_in sa ;
    struct hostent *hp ;
    int s ;
    long addr ;


    memset(&sa, 0, sizeof(sa)) ;
    if ((addr = inet_addr(hostname)) != -1) {
        /* is Internet addr in octet notation */
        memcpy( (char *) &sa.sin_addr, &addr, sizeof(addr)) ; /* set address */
        sa.sin_family = AF_INET ;
    } else {
        /* do we know the host's address? */
        if ((hp = gethostbyname(hostname)) == NULL) {
            printf("unknown host %s\n",hostname);
            return -2 ;
        }
        memcpy((char *) &sa.sin_addr, hp->h_addr, hp->h_length) ;
        sa.sin_family = hp->h_addrtype ;
    }

    sa.sin_port = htons(port) ;

    if ((s = socket(sa.sin_family, SOCK_STREAM, 0)) < 0) { /* get socket */
        printf("cannot open connection\n");
        return -1 ;
    }
    if (connect(s, (struct sockaddr*) &sa, sizeof(sa)) < 0) { /* connect */
        close(s) ;
        printf("Sorry, cannot connect to %s\n", hostname);
        return -1 ;
    }
    return s ;
}



int connect_to(char *server, int port, char *search_for)
{
	int len;
	char st[255];

	int active_socket;
	fd_set readfds;
	int fdset_with;
	int search_for_len;

	search_for_len=strlen(search_for);
                                        
	active_socket=open_connection(server, port);
        if(active_socket == -1 || active_socket == -2)
        {
          exit(1);
        }

        write(active_socket, search_for, search_for_len); 


   	fdset_with = (IN > active_socket ? IN : active_socket) +1;

   	while (1) {
        	FD_ZERO(&readfds);
                FD_SET(IN, &readfds);
                FD_SET(active_socket, &readfds); 

		if (select(fdset_with, &readfds, NULL, NULL, NULL) < 0)
			perror("select"); 

		if (FD_ISSET(active_socket, &readfds)) {
			if ((len=read(active_socket, st, 255))==0) {
				shutdown(active_socket,2);
				close(active_socket);
				exit(0);
			}
			write(OUT, st, len); 
		} else {
                   	len=read(IN, st, 255);
                        write(active_socket, st, len);
                }
	}
	close(active_socket);
	exit(0);
}

