/* $Id: query.c,v 1.1 1998/08/01 16:03:14 dg8xt Exp $ */

/*
 * QUERY is Copyright (C) 1998 by Thomas Weinell <dg8xt@db0hht.ampr.org>
 *
 * QUERY is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; version 2 dated June, 1991
 *
 * QUERY is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QUERY; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* 
 * to use within ftpd
 * copy i.e. (wu-ftpd) to /home/ftp/usr/bin/ftpexec/query
 *
*/


#include <stdio.h>
#include <string.h>
#include "global.h"
#include "log.h"
#include "misc.h"

const char progname[255]="psearch-query";

void print_qresult(char *line)
{
   char size[10];
   char month_day[7];
   char year[5];
   char fname[1024];

   strncpy(size, line+23, 9);
   size[9]=0;
   strncpy(month_day, line+37, 6);
   month_day[6]=0;
   strncpy(year, line+53, 4);
   year[4]=0;
   strncpy(fname, line+58, 255);
   fname[strlen(line)-59]=0;

   if (line[0] == '-')
      printf(" %s  %s %s  /%s\n", size, month_day, year, fname);
}

void qsearch(char *search_for)
{
   FILE *stream;
   char line[1024];
   char fname[1024];
   char *buf;
   int found=0;

   if ((stream = fopen(FTPD_DATA_FILE,"r")) == NULL )
         error_log(FTPD_DATA_FILE);
   
   fgets(line, 1024,stream);
   fgets(line, 1024,stream); /* done this twice, because we do not
                        	need the first line */
      
   while( !feof(stream) )
   {
      strcpy(fname, (buf=strrchr(line, '/')+1) );
      convert_lower_to_upper(fname, strlen(fname));

      if (strstr(fname, search_for) != 0) {
         found++;
         print_qresult(line);
      }
      
      fgets(line, 1024,stream);
   }

   if(!found)
      printf("  %s not found.\n\n", search_for);

   fclose(stream);
}


int main(int argc, char **argv)
{
   char search_for[255];
   
   /* check if somebody is so stupid to run as uid root */
   check_root();	/* log.h */

   if( !argv[1] )
   {
      printf("Usage: quote site exec query <partial filename>\n");
      exit(1);
   }

   strcpy(search_for, argv[argc-1]);
   convert_lower_to_upper(search_for, strlen(search_for));	/* misc.h */
   check_search(search_for);	/* misc.h */

   qsearch(search_for);

   return 0;
}

