/* $Id: log.c,v 1.1 1998/08/01 16:03:14 dg8xt Exp $ */

#include <stdio.h>
#include <syslog.h>
#include <unistd.h>

extern char progname[];

/* There is no need to run as uid root	*/
/* possible security hole within popen	*/
/* so warn in log			*/
void check_root()
{
   if( getuid() == 0 || geteuid() == 0)	/* root ?  please NO NO NO */
   {
      openlog(progname,0,0);
      syslog(4, "You should not run %s as uid root", progname); /*LOG_WARNING */
      closelog();
   }
}

/* write error log and exit */
void error_log(char *error_desc)
{
   openlog(progname,0,0);
   printf("\nERROR: unable to open %s\n\n", error_desc);
   syslog(3, "ERROR: unable to open %s",error_desc); /* LOG_ERR */
   closelog();
   exit (1);
}

