/********************************************************************
 * lindner
 * 3.7
 * 1994/03/04 17:42:57
 * /home/mudhoney/GopherSrc/CVS/gopher+/object/url.c,v
 * Exp
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: url.c
 * Simplified method of getting urls..
 *********************************************************************
 * Revision History:
 * url.c,v
 * Revision 3.7  1994/03/04  17:42:57  lindner
 * Fixes from Alan Coopersmith
 *
 * Revision 3.6  1994/01/21  04:25:41  lindner
 * Add support for tn3270 and better gopher url handling
 *
 * Revision 3.5  1993/12/30  04:18:08  lindner
 * translate telnet url correctly
 *
 * Revision 3.4  1993/12/27  16:14:03  lindner
 * Enlarge buffer size, make html docs on gopher server into http: refs
 *
 * Revision 3.3  1993/11/02  06:14:09  lindner
 * Add url html hack
 *
 *
 *********************************************************************/

#include "url.h"
#include "GSgopherobj.h"
#include "Malloc.h"
#include "String.h"

Url *
URLnew()
{
     Url *temp;

     temp = (Url *) malloc(sizeof(Url));
     temp->url = STRnew();
     
     return(temp);
}


void
URLdestroy(url)
  Url *url;
{
     STRdestroy(url->url);
     free(url);
}

/*
 * Make a default url from the current Gopher Object...
 */

void
URLfromGS(url, gs)
  Url       *url;
  GopherObj *gs;
{
     char u[2048], *path, *cp;

     *u = '\0';
     path  = GSgetPath(gs);

     if (path == NULL)
	  return;

     if (GSgetType(gs) == A_TELNET) {
	  if (*path == '\0')
	       sprintf(u, "telnet://%s:%d", GSgetHost(gs), GSgetPort(gs));
	  else
	       sprintf(u, "telnet://%s@%s:%d", path, GSgetHost(gs),
		       GSgetPort(gs));
     } else if (GSgetType(gs) == A_TN3270) {
	  if (*path == '\0')
	       sprintf(u, "tn3270://%s:%d", GSgetHost(gs), GSgetPort(gs));
	  else
	       sprintf(u, "tn3270://%s@%s:%d", path, GSgetHost(gs),
		       GSgetPort(gs));
     } else if (strncmp(path, "GET /", 5) == 0) {
	  sprintf(u, "http://%s:%d/%s", GSgetHost(gs), GSgetPort(gs),
		  path+5);
     }
     else {
	  sprintf(u, "gopher://%s:%d/%c", GSgetHost(gs), GSgetPort(gs),
		  GSgetType(gs));
	  cp = u + strlen(u);
	  Tohexstr(path, cp);
     }

     URLset(url, u);
}

/*
 * Hack gopher directories into an HTML type...
 */

void
URLmakeHTML(url)
  Url *url;
{
     char *cp = URLget(url);
     char *host;

     if (cp == NULL) 
	  return;

     if (strncmp(cp, "gopher://", 9) != 0)
	  return;

     /** find the type character **/
     cp = strchr(cp+10, '/');
     
     if (cp ==NULL)
	  return;

     host = cp+10;
     
     /** Test link for current host **/
/*     if (strcasecmp(host, hostname) != 0) 
	  return;*/
     
     cp ++;
     /** cp is now pointed at the type character **/
     
     if (*cp == '1' && *(cp+1) == '1') {
	  /** It's a directory **/
	  *cp = 'h';
	  *(cp+1) = 'h';
     }
}


/*
 * Get the transport of the specified URL
 */

char *
URLgetTransport(url)
  Url *url;
{
     static char trans[16];  /** Shouldn't need more than that.. yet.. */
     char *urlcp, *cp;

     urlcp = URLget(url);
     if (urlcp == NULL)
	  return(NULL);

     cp = strchr(urlcp, ':');
     if (cp == NULL)
	  return(NULL);
     
     strncpy(trans, urlcp, (int)(cp-urlcp));
     return (trans);
}
     
     
     


