/*
 * $Id: getifname.c,v 1.5 1996/09/15 11:36:41 lf Exp $
 *
 * Copyright (C) 1995 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at lf@elemental.net 
 * and I'll send you a copy.
 *
 */

#include <stdio.h>
#include <syslog.h>
#include <unistd.h>
#include <string.h>

#include "config.h"
#include "radius.h"

static char rcsid[] = "$Id: getifname.c,v 1.5 1996/09/15 11:36:41 lf Exp $";

int main(int argc, char **argv)
{
	char *p;
	char *pname;
	
	pname = (pname = strrchr(argv[0],'/'))?pname+1:argv[0];

	rc_openlog(pname);

	if (argc > 2) {
		fprintf(stderr, "usage: %s [filename]", pname);
		return(ERROR_RC);
	} else if (argc == 2) {
	 	p = rc_getifname(argv[1]);
		if (p) fputs(p, stdout);
	} else {
		p = rc_getifname(ttyname(1));
		if (p) fputs(p, stdout);
	}	

	return 0;
}
