/*
 * $Id: options.h,v 1.2 1996/09/15 11:36:29 lf Exp $
 *
 * Copyright (C) 1996 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at lf@elemental.net 
 * and I'll send you a copy.
 *
 */

#include <sys/types.h>

#include "radius.h"

#define OPTION_LEN	64

/* ids for different option types */
#define OT_STR		(1<<0)	  /* string */
#define OT_INT		(1<<1)	  /* integer */
#define OT_SRV		(1<<2)	  /* server list */
#define OT_AUO		(1<<3)    /* authentication order */

#define OT_ANY		((unsigned int)~0) /* used internally */

/* status types */
#define ST_UNDEF	(1<<0)	  /* option is undefined */
#define ST_CLEAN	(1<<1)	  /* option is clean, i.e. not changed */
#define ST_DIRTY	(1<<2)	  /* option was modified */

typedef struct option {
	char name[OPTION_LEN];	  /* name of the option */
	int type, status;	  /* type and status    */
	off_t start,end;	  /* offsets into the config file */
	struct option *next;	  /* option read sequentially next */
	void *val;		  /* pointer to option value */
} OPTION;

static SERVER acctserver = {0};
static SERVER authserver = {0};

static OPTION config_options[] = {
/* internally used options */
{"config_file",		OT_STR, ST_UNDEF, -1, -1, NULL, NULL},
/* General options */
{"auth_order",	 	OT_AUO, ST_UNDEF, -1, -1, NULL, NULL},
{"login_tries",	 	OT_INT, ST_UNDEF, -1, -1, NULL, NULL},
{"login_timeout",	OT_INT, ST_UNDEF, -1, -1, NULL, NULL},
{"nologin",		OT_STR, ST_UNDEF, -1, -1, NULL, NULL},
{"issue",		OT_STR, ST_UNDEF, -1, -1, NULL, NULL},
/* RADIUS specific options */
{"authserver",		OT_SRV, ST_UNDEF, -1, -1, NULL, &authserver},
{"acctserver",		OT_SRV, ST_UNDEF, -1, -1, NULL, &acctserver},
{"clients",		OT_STR, ST_UNDEF, -1, -1, NULL, NULL},
{"dictionary",		OT_STR, ST_UNDEF, -1, -1, NULL, NULL},
{"login_radius",	OT_STR, ST_UNDEF, -1, -1, NULL, NULL},
{"seqfile",		OT_STR, ST_UNDEF, -1, -1, NULL, NULL},
{"mapfile",		OT_STR, ST_UNDEF, -1, -1, NULL, NULL},
{"default_realm",	OT_STR, ST_UNDEF, -1, -1, NULL, NULL},
{"radius_timeout",	OT_INT, ST_UNDEF, -1, -1, NULL, NULL},
{"radius_retries",	OT_INT,	ST_UNDEF, -1, -1, NULL, NULL},
/* local options */
{"login_local",		OT_STR, ST_UNDEF, -1, -1, NULL, NULL},
/* outbound specific options */
{"port_pool",		OT_STR, ST_UNDEF, -1, -1, NULL, NULL}
};

static int num_options = ((sizeof(config_options))/(sizeof(config_options[0])));
