/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * By Jean-Marc Jacquet <littleigloo@chez.com> 
 * Copyright (C) 1998 Little Igloo Org  http://www.chez.com/littleigloo
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include "protos.h"



void
update_main_statusbar (int message_number, char NEW)
{
  char buf[100];
  int f;

  for (f = 0; f < 4; f++)
    {
      gtk_statusbar_remove (GTK_STATUSBAR (main_statusbar[f]), main_context_id[f], main_message_id[f]);
      main_message_id[f] = gtk_statusbar_push (GTK_STATUSBAR (main_statusbar[f]), main_context_id[f], "");
    }

  gtk_statusbar_remove (GTK_STATUSBAR (main_statusbar[0]), main_context_id[0], main_message_id[0]);
  if (message_number)
    sprintf (buf, " Message #%i                                      ", message_number);
  else
    strcpy (buf, " No Message.                                     ");
  main_message_id[0] = gtk_statusbar_push (GTK_STATUSBAR (main_statusbar[0]), main_context_id[0], buf);

  if (NEW)
    {
      gtk_statusbar_remove (GTK_STATUSBAR (main_statusbar[1]), main_context_id[1], main_message_id[1]);
      main_message_id[1] = gtk_statusbar_push (GTK_STATUSBAR (main_statusbar[1]), main_context_id[1], " NEW             ");
    }

  if (total_number_of_messages)
    {
      sprintf (buf, " Total Messages : %i                                    ", total_number_of_messages);
      gtk_statusbar_remove (GTK_STATUSBAR (main_statusbar[2]), main_context_id[2], main_message_id[2]);
      main_message_id[2] = gtk_statusbar_push (GTK_STATUSBAR (main_statusbar[2]), main_context_id[2], buf);
    }

  if (new_messages)
    {
      sprintf (buf, " New : %i                         ", new_messages);
      gtk_statusbar_remove (GTK_STATUSBAR (main_statusbar[3]), main_context_id[3], main_message_id[3]);
      main_message_id[3] = gtk_statusbar_push (GTK_STATUSBAR (main_statusbar[3]), main_context_id[3], buf);
    }
}



/* -- read from data file message #message_number -- */
void
read_message (int message_number, struct linpopup_message *this_message)
{
  int file_handle;
  file_handle = open (DATA_FILE, O_RDONLY, DATA_PERM);
  lseek (file_handle, (message_number - 1) * sizeof (*this_message), SEEK_SET);
  read (file_handle, this_message, sizeof (*this_message));
  close (file_handle);
}



/* -- save to  data file message #message_number -- */
void
write_message (int message_number, struct linpopup_message *this_message)
{
  int file_handle;
  file_handle = open (DATA_FILE, O_WRONLY, DATA_PERM);
  lseek (file_handle, (message_number - 1) * sizeof (*this_message), SEEK_SET);
  write (file_handle, this_message, sizeof (*this_message));
  close (file_handle);
}



/* -- unset the is_new flag of message #message_number -- */
void
this_message_is_no_longer_new (int message_number)
{
  struct linpopup_message this_message;

  read_message (message_number, &this_message);
  this_message.is_new = FALSE;
  write_message (message_number, &this_message);
  new_messages--;
}



/* -- show_no_message -- */
void
show_no_message (void)
{
  GtkWidget *main_window_text;
  char buf[1024];

  main_window_text = gtk_object_get_data (GTK_OBJECT (window), "text");
  clear_text (main_window_text);
  realize_text (main_window_text, many_version_infos (buf));
  current_showed_message = 0;
  update_main_statusbar (0, FALSE);
}



/* -- show message #message_number -- */
void
show_message (int message_number)
{
  GtkWidget *main_window_text;
  struct linpopup_message this_message;
  char buf[50];

  read_message (message_number, &this_message);

  main_window_text = gtk_object_get_data (GTK_OBJECT (window), "text");
  clear_text (main_window_text);
  sprintf (buf, "Message received from %s on %s\n---\n\n", this_message.sender, this_message.host);
  realize_text (main_window_text, buf);
  realize_text (main_window_text, this_message.text);

  if (this_message.is_new)
    {
      update_main_statusbar (message_number, TRUE);
      this_message_is_no_longer_new (message_number);
    }
  else
    update_main_statusbar (message_number, FALSE);

  deiconify_window (window);
  current_showed_message = message_number;
  strcpy (user_rc.guess_adr, this_message.host);
}



/* -- show next message -- */
void
show_next_message (gpointer * data)
{
  if (!total_number_of_messages)
    {
      show_no_message ();
      return;
    }
  if (current_showed_message == total_number_of_messages)
    show_message (1);
  else
    show_message (current_showed_message + 1);
}



/* -- show previous message -- */
void
show_previous_message (gpointer * data)
{
  if (!total_number_of_messages)
    {
      show_no_message ();
      return;
    }
  if (current_showed_message == 1)
    show_message (total_number_of_messages);
  else
    show_message (current_showed_message - 1);
}



/* -- count  messages in data file -- */
int
count_total_number_of_messages (void)
{
  struct stat data_file;
  int data_file_len;

  if (access (DATA_FILE, F_OK))
    return 0;

  stat (DATA_FILE, &data_file);
  data_file_len = ((off_t) data_file.st_size / sizeof (struct linpopup_message));
  return data_file_len;
}



/* -- delete message current_showed message from  data file -- */
void
delete_showed_message (void)
{
  struct linpopup_message this_message;
  char *temp_filename;
  int file_handle_temp, file_handle_data;
  int f;

  if (!total_number_of_messages)
    {
      show_no_message ();
      return;
    }

  temp_filename = tmpnam (NULL);
  file_handle_data = open (DATA_FILE, O_RDONLY, DATA_PERM);
  file_handle_temp = open (temp_filename, O_RDWR | O_CREAT, DATA_PERM);
  lseek (file_handle_data, 0L, SEEK_SET);
  for (f = 1; f <= total_number_of_messages; f++)
    {
      read (file_handle_data, &this_message, sizeof (this_message));
      write (file_handle_temp, &this_message, sizeof (this_message));
    }

  close (file_handle_temp);
  close (file_handle_data);

  file_handle_data = open (DATA_FILE, O_RDWR | O_TRUNC, DATA_PERM);
  file_handle_temp = open (temp_filename, O_RDONLY, DATA_PERM);

  for (f = 1; f <= total_number_of_messages; f++)
    {

      read (file_handle_temp, &this_message, sizeof (this_message));
      if (f != current_showed_message)
	write (file_handle_data, &this_message, sizeof (this_message));
      else if (this_message.is_new == TRUE)
	new_messages--;
    }

  close (file_handle_temp);
  close (file_handle_data);

  unlink (temp_filename);

  total_number_of_messages = count_total_number_of_messages ();
  current_showed_message--;
  show_next_message (NULL);
}



/* -- delete ALL messages in the data file -- */
void
delete_all_messages (void)
{
  int file_handle_data;

  if (!total_number_of_messages)
    return;
  if (alert_dialog ("Confirm for deletion", "\n Do you really want\ndelete ALL messages ?", "Yes", "No", 2) == 2)
    return;
  file_handle_data = open (DATA_FILE, O_RDWR | O_TRUNC, DATA_PERM);
  close (file_handle_data);
  total_number_of_messages = count_total_number_of_messages ();
  new_messages = 0;
  show_no_message ();
}



/* -- return the numb of new message in data file -- */
int
are_there_new_messages_in_data_file (void)
{
  struct linpopup_message this_message;
  int file_handle;
  int compt;

  first_new_message = 0;

  if (access (DATA_FILE, F_OK))
    return 0;

  file_handle = open (DATA_FILE, O_RDONLY, DATA_PERM);
  for (compt = 1; compt <= total_number_of_messages; compt++)
    {
      read (file_handle, &this_message, sizeof (this_message));
      if (this_message.is_new == TRUE)
	{
	  new_messages++;
	  if (first_new_message == 0)
	    first_new_message = compt;
	}
    }
  close (file_handle);
  return new_messages;
}



/* -- New message regular check  -- */
gint
check_for_new_message (gpointer data)
{
  if (processing_new_message)
    return TRUE;

  total_number_of_messages = count_total_number_of_messages ();
  if (!are_there_new_messages_in_data_file ())
    return TRUE;

  processing_new_message = TRUE;
  show_message (first_new_message);
  processing_new_message = FALSE;

  return TRUE;
}





/* -- HERE IS THE FUNCTION INVOKED WHEN RUN BY SAMBA -- */
void
trap_message (int argc, char *argv[])
{
  FILE *in;
  int file_handle;
  int i;
  struct linpopup_message this_message;

  vital_check_for_read_access (argv[3]);

  strcpy (this_message.sender, argv[1]);
  strcpy (this_message.host, argv[2]);

  memset (&this_message, 0, sizeof (this_message));
  strncpy (this_message.sender, argv[1], sizeof (this_message.sender) - 1);
  strncpy (this_message.host, argv[2], sizeof (this_message.host) - 1);

  in = fopen (argv[3], "r");
  i = fread (this_message.text, 1, sizeof (this_message.text), in);
  fclose (in);
  this_message.text[i] = 0;
  this_message.is_new = TRUE;

  if (access (DATA_FILE, F_OK))
    file_handle = open (DATA_FILE, O_WRONLY | O_CREAT, DATA_PERM);
  else
    file_handle = open (DATA_FILE, O_WRONLY | O_APPEND, DATA_PERM);
  write (file_handle, &this_message, sizeof (this_message));
  close (file_handle);

  exit (0);
}
