/*
 |
 |               Copyright (C) 1993 Hewlett-Packard Company
 |                         ALL RIGHTS RESERVED.
 |
 |  The enclosed software and documentation includes copyrighted works of
 |  Hewlett-Packard Co. For as long as you comply with the following
 |  limitations, you are hereby authorized to (i) use, reproduce, and
 |  modify the software and documentation, and to (ii) distribute the
 |  software and documentation, including modifications, for
 |  non-commercial purposes only.
 |
 |  1.  The enclosed software and documentation is made available at no
 |      charge.
 |
 |  2.  You may not delete any copyright notices contained in the
 |      software or documentation. All hard copies, and copies in
 |      source code or object code form, of the software or
 |      documentation (including modifications) must contain at least
 |      one of the copyright notices.
 |
 |  3.  The enclosed software and documentation has not been subjected
 |      to testing and quality control and is not a Hewlett-Packard Co.
 |      product. At a future time, Hewlett-Packard Co. may or may not
 |      offer a version of the software and documentation as a product.
 |
 |  4.  THE SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS".
 |      HEWLETT-PACKARD COMPANY DOES NOT WARRANT THAT THE USE,
 |      REPRODUCTION, MODIFICATION OR DISTRIBUTION OF THE SOFTWARE OR
 |      DOCUMENTATION WILL NOT INFRINGE A THIRD PARTY'S INTELLECTUAL
 |      PROPERTY RIGHTS. HP DOES NOT WARRANT THAT THE SOFTWARE OR
 |      DOCUMENTATION IS ERROR FREE. HP DISCLAIMS ALL WARRANTIES,
 |      EXPRESS AND IMPLIED, WITH REGARD TO THE SOFTWARE AND THE
 |      DOCUMENTATION. HP SPECIFICALLY DISCLAIMS ALL WARRANTIES OF
 |      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 |
 |  5.  HEWLETT-PACKARD COMPANY WILL NOT IN ANY EVENT BE LIABLE FOR ANY
 |      DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 |      (INCLUDING LOST PROFITS) RELATED TO ANY USE, REPRODUCTION,
 |      MODIFICATION, OR DISTRIBUTION FOR THE SOFTWARE OR DOCUMENTATION.
 |
 |
 |	This is the source for hbiff, a program that monitors an 
 |	electronic mailbox.  
 |
 |	$Source: /home/hugh/sources/hbiff/hbiff.c,v $
 |	$Author: hugh $
 |	$State: Exp $  $Locker: hugh $
 |	$Date: 2000/12/27 04:56:21 $
 */

char copyright_notice[] = 
	"Copyright (C) 1993, 1999, 2000 Hewlett-Packard Company, ALL RIGHTS RESERVED";

char ident[] = "@(#)hbiff: $Revision: 5.37 $";	/* what string, version info	*/

#define TRUE 1
#define FALSE 0
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <string.h>
#include <signal.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <utime.h>

extern int errno;

#define MASK(f) (1 << (f))

#define max(a, b) ((a) > (b) ? (a) : (b))

#define nomail_width 64
#define nomail_height 64
static unsigned char nomail_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0xff,0x7f,0x00,
 0x00,0x00,0x08,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0xe4,0x00,0x00,0x00,0x80,
 0x00,0x00,0x00,0xb4,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x5c,0x71,0x1c,0x00,
 0x00,0x01,0x00,0x00,0xac,0x62,0x0c,0x02,0x00,0x03,0x00,0x00,0x5c,0xa3,0x0a,
 0xc5,0x09,0x02,0x00,0x00,0xac,0x22,0x89,0x88,0x08,0x02,0x00,0x00,0x5c,0x23,
 0x89,0x88,0x08,0x02,0x00,0x00,0xac,0x22,0x88,0x8f,0x08,0x02,0x00,0x00,0x5c,
 0x23,0x88,0x88,0x48,0x02,0x00,0x00,0xac,0x22,0x88,0x88,0x38,0x02,0x00,0x00,
 0x5c,0x23,0x88,0xc8,0x01,0x02,0x00,0x00,0xac,0x22,0x88,0x1c,0x80,0x03,0x00,
 0x00,0x5c,0x23,0xc8,0x01,0xf0,0x00,0x00,0x00,0xac,0x22,0x1c,0x00,0x0e,0x00,
 0x00,0x00,0x58,0x73,0x00,0xe0,0x01,0x00,0x00,0x00,0xb2,0x02,0x00,0x1e,0x00,
 0x00,0x00,0x00,0x67,0x03,0xf0,0x03,0x00,0x00,0x00,0x00,0xcd,0x02,0x1e,0x02,
 0x00,0x00,0x00,0x80,0x99,0x83,0x23,0x02,0x00,0x00,0x00,0x80,0x30,0x61,0x24,
 0x02,0x00,0x00,0x00,0xc0,0x60,0x1e,0x24,0x02,0x00,0x00,0x00,0x40,0xc0,0x00,
 0x24,0x02,0x00,0x00,0x00,0x60,0x80,0x01,0x24,0x02,0x00,0x00,0x00,0x20,0x80,
 0x01,0x24,0x02,0x00,0x00,0x00,0x30,0x80,0x01,0x24,0x02,0x00,0x00,0x00,0x10,
 0x80,0x00,0x24,0x02,0x00,0x00,0x00,0x10,0xc0,0x00,0x24,0x02,0x00,0x00,0x00,
 0x30,0x40,0x94,0x25,0x02,0x00,0x00,0x00,0x20,0x60,0x98,0x24,0x02,0x00,0x00,
 0x00,0x60,0x30,0xb4,0x24,0x02,0x00,0x00,0x00,0xc0,0x1c,0xee,0x24,0x02,0x00,
 0x00,0x00,0x80,0x07,0xf0,0x24,0xc2,0x00,0x00,0x00,0x00,0x00,0xa0,0x25,0x7a,
 0x00,0x00,0x00,0x00,0x00,0x7c,0x27,0x36,0x03,0x00,0x00,0x00,0x00,0x1c,0x26,
 0x0f,0x02,0x00,0x00,0x00,0x00,0x04,0x26,0x0b,0x00,0x00,0x00,0x00,0x00,0x00,
 0xa4,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0xa4,0x01,0x00,0x00,0x00,0x00,0x00,
 0x00,0xac,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00};

#define newmail_width 64
#define newmail_height 64
static char newmail_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd0,0x01,0x00,0x00,
 0x00,0x00,0x00,0x00,0x50,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x18,0x00,
 0x00,0x00,0x00,0x00,0x00,0x50,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x18,
 0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0xd0,
 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0xff,0x7f,0x00,
 0x00,0x00,0x18,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0xec,0x00,0x00,0x00,0x80,
 0x00,0x00,0x00,0xf4,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0xfe,0x73,0x1c,0x00,
 0x00,0x01,0x00,0xfc,0xff,0x63,0x0c,0x02,0x00,0x03,0x00,0x04,0x00,0xa2,0x0a,
 0xc5,0x09,0x02,0x00,0x64,0x82,0x23,0x89,0x88,0x08,0x02,0x00,0x04,0xd5,0x22,
 0x89,0x88,0x08,0x02,0x00,0x08,0x38,0x23,0x88,0x8f,0x08,0x02,0x00,0xc8,0x07,
 0x23,0x88,0x88,0x48,0x02,0x00,0x3e,0x80,0x22,0x88,0x88,0x38,0x02,0x00,0x06,
 0x40,0x22,0x88,0xc8,0x01,0x02,0x00,0xfe,0x3f,0x22,0x88,0x1c,0x80,0x03,0x00,
 0x02,0x00,0x22,0xc8,0x01,0xf0,0x00,0x00,0x06,0x00,0x22,0x1c,0x00,0x0e,0x00,
 0x00,0x04,0x80,0x73,0x00,0xe0,0x01,0x00,0x00,0x04,0xf8,0x02,0x00,0x1e,0x00,
 0x00,0x00,0x04,0x6f,0x03,0xf0,0x03,0x00,0x00,0x00,0xe4,0xcd,0x02,0x1e,0x02,
 0x00,0x00,0x00,0x9c,0x99,0x83,0x23,0x02,0x00,0x00,0x00,0x80,0x30,0x63,0x24,
 0x02,0x00,0x00,0x00,0xc0,0x60,0x1e,0x24,0x02,0x00,0x00,0x00,0x40,0xc0,0x00,
 0x24,0x02,0x00,0x00,0x00,0x60,0x80,0x01,0x24,0x02,0x00,0x00,0x00,0x20,0x80,
 0x01,0x24,0x02,0x00,0x00,0x00,0x30,0x80,0x01,0x24,0x02,0x00,0x00,0x00,0x10,
 0x80,0x00,0x24,0x02,0x00,0x00,0x00,0x10,0xc0,0x00,0x24,0x02,0x00,0x00,0x00,
 0x30,0x40,0x94,0x25,0x02,0x00,0x00,0x00,0x20,0x60,0x98,0x24,0x02,0x00,0x00,
 0x00,0x60,0x30,0xb4,0x24,0x02,0x00,0x00,0x00,0xc0,0x1c,0xee,0x24,0x02,0x00,
 0x00,0x00,0x80,0x07,0xf0,0x24,0xc2,0x00,0x00,0x00,0x00,0x00,0xa0,0x25,0x7a,
 0x00,0x00,0x00,0x00,0x00,0x7c,0x27,0x36,0x03,0x00,0x00,0x00,0x00,0x1c,0x26,
 0x0f,0x02,0x00,0x00,0x00,0x00,0x04,0x26,0x0b,0x00,0x00,0x00,0x00,0x00,0x00,
 0xa4,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0xa4,0x01,0x00,0x00,0x00,0x00,0x00,
 0x00,0xac,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00};

#define oldmail_width 64
#define oldmail_height 64
static char oldmail_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0xff,0x7f,0x00,
 0x00,0x00,0x18,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0xec,0x00,0x00,0x00,0x80,
 0x00,0x00,0x00,0xf4,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0xfe,0x73,0x1c,0x00,
 0x00,0x01,0x00,0xfc,0xff,0x63,0x0c,0x02,0x00,0x03,0x00,0x04,0x00,0xa2,0x0a,
 0xc5,0x09,0x02,0x00,0x64,0x82,0x23,0x89,0x88,0x08,0x02,0x00,0x04,0xd5,0x22,
 0x89,0x88,0x08,0x02,0x00,0x08,0x38,0x23,0x88,0x8f,0x08,0x02,0x00,0xc8,0x07,
 0x23,0x88,0x88,0x48,0x02,0x00,0x3e,0x80,0x22,0x88,0x88,0x38,0x02,0x00,0x06,
 0x40,0x22,0x88,0xc8,0x01,0x02,0x00,0xfe,0x3f,0x22,0x88,0x1c,0x80,0x03,0x00,
 0x02,0x00,0x22,0xc8,0x01,0xf0,0x00,0x00,0x06,0x00,0x22,0x1c,0x00,0x0e,0x00,
 0x00,0x04,0x80,0x73,0x00,0xe0,0x01,0x00,0x00,0x04,0xf8,0x02,0x00,0x1e,0x00,
 0x00,0x00,0x04,0x6f,0x03,0xf0,0x03,0x00,0x00,0x00,0xe4,0xcd,0x02,0x1e,0x02,
 0x00,0x00,0x00,0x9c,0x99,0x83,0x23,0x02,0x00,0x00,0x00,0x80,0x30,0x63,0x24,
 0x02,0x00,0x00,0x00,0xc0,0x60,0x1e,0x24,0x02,0x00,0x00,0x00,0x40,0xc0,0x00,
 0x24,0x02,0x00,0x00,0x00,0x60,0x80,0x01,0x24,0x02,0x00,0x00,0x00,0x20,0x80,
 0x01,0x24,0x02,0x00,0x00,0x00,0x30,0x80,0x01,0x24,0x02,0x00,0x00,0x00,0x10,
 0x80,0x00,0x24,0x02,0x00,0x00,0x00,0x10,0xc0,0x00,0x24,0x02,0x00,0x00,0x00,
 0x30,0x40,0x94,0x25,0x02,0x00,0x00,0x00,0x20,0x60,0x98,0x24,0x02,0x00,0x00,
 0x00,0x60,0x30,0xb4,0x24,0x02,0x00,0x00,0x00,0xc0,0x1c,0xee,0x24,0x02,0x00,
 0x00,0x00,0x80,0x07,0xf0,0x24,0xc2,0x00,0x00,0x00,0x00,0x00,0xa0,0x25,0x7a,
 0x00,0x00,0x00,0x00,0x00,0x7c,0x27,0x36,0x03,0x00,0x00,0x00,0x00,0x1c,0x26,
 0x0f,0x02,0x00,0x00,0x00,0x00,0x04,0x26,0x0b,0x00,0x00,0x00,0x00,0x00,0x00,
 0xa4,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0xa4,0x01,0x00,0x00,0x00,0x00,0x00,
 0x00,0xac,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00};

#define nomail 0
#define newmail 1
#define oldmail 2

Pixmap      pix[3];

FILE *fp;
XClassHint	class_spec;
Display *disp_ptr;
GC gc;
GC rev_gc;
GC new_mail_gc;
GC summary_gc;
XGCValues gcvalues;
int screen;
Window window_id;
Window from_wid = 0;
int width, height, swidth, sheight;
int max_lines, max_width;
int lines, new_lines;
int x_neg, y_neg, sx_neg, sy_neg;	/* flags to indicate that x and/or y are negative */
int result;
int x, y, sx, sy, i;
int pix_x_offset, pix_y_offset, text_x_offset, text_y_offset;
int border_width;
char *Display_name;
int counter;
XSetWindowAttributes win_attrib;
unsigned long background, foreground, border;
unsigned long new_mail_background, new_mail_foreground;
unsigned long summary_background, summary_foreground;
char summary_g_set = FALSE;
XFontStruct *ae_font;
int fontheight, fontwidth;
char *bg_color, *fg_color, *b_color, *nm_bg_color, *nm_fg_color;
char *summary_fg_color, *summary_bg_color;
XColor exact_def_return, screen_def_return;
Colormap colormap;
int curr_state = 255;
int new_mail_raise;
char *username;
char mail_file[128];
char hostname[128];
char real_hostname[128];
char *mail_command;
char *view_command = "LINES=24 xterm -geom =80x24 -e less %s <&- >&- 2>&-";
char view_file_name[256];
char num_of_msgs[16];
char num_of_new[16];
char *mail_locations[] = {"/var/spool/mail", "/var/mail", "/usr/mail", ""};

int hostname_len;
int timer;
char *font_name;
int reverse_video;
int new_mail_reverse;
int new_mail_beep = TRUE;
int show_new_mail = FALSE;
int reverse_on;
int no_flash = FALSE;
int reverse_list = FALSE;
int new_mail_showing = FALSE;
int show_tally = FALSE;
int global_volume = 50;
int name_set = FALSE;
int file_is_dir = FALSE;
int show_date = FALSE;

XSizeHints xsh, sxsh;

XEvent	event;
XButtonEvent *button_event;

XTextProperty property_list;

int xfd, readfds;
int ttymask;
struct timeval timeout;
int number_of_events;
int child_num = 0;
int vchild_num = 0;
time_t last_hbiff_access = 0;

int clear_child();

struct passwd *pw;

struct from_text {
	int length;		/* should include NULL character	*/
	char *string;		/* line of text				*/
	char flag;		/* flag to indicate that this is new mail */
	fpos_t from_location;	/* location of the first part of the message */
	struct from_text *prev;	/* prev line				*/
	struct from_text *next;	/* next line				*/
	};

struct from_text *old_msg_list = NULL, *new_msg_list = NULL;

fpos_t location;
fpos_t from_location;

/*
 |	Sound stuff borrowed from a program written by Roger Petersen
 */

XKeyboardControl	save_kbd;

/* 
 |	make file status global so it can be compared on call to 
 |	get_from_lines()
 */
static struct stat file_status;


int argc1;
char **argv1;

char *arglist[8];

void set_window_name(char *);
void dump_message(int);

char *getline(buff, len, fp)
char *buff;
int len;
FILE *fp;
{
	char *tmp;
	fpos_t local;
	char local_b[128];
	int retval;
	int len1, len2;

	tmp = fgets(buff, len, fp);
	if (tmp == (char *)NULL)
		return (NULL);
	do
	{
		retval = fgetpos(fp, &local);
		if ((tmp = fgets(local_b, 128, fp)) != NULL)
		{
			if (*local_b == '\t')  /* a tab */
			{
				len1 = strlen(buff);
				buff[len1 - 1] = (char)NULL;
				len2 = strlen(local_b);
				if ((len1 + len2) < len)
					strcat(buff, &local_b[1]);
				else
				{
					strncat(buff, &local_b[1], ((len - len1) - 1));
					buff[len - 1] = (char )NULL;
					len1 = len;
				}
			}
			else
				fsetpos(fp, &local);
		}
	}
	while ((local_b[0] == '\t') && (len1 < len));
	tmp = strstr(buff, "\n");
	if ((tmp != buff) && (tmp != NULL))
		*tmp = (char)NULL;
	return(buff);
}

main(argc, argv)
int argc;
char *argv[];
{
	char	text[10];
	KeySym	key;
	int done;
	int temp;
	char buffer[512];
	char *temp_ptr;
	struct stat buf;
	Status value;

	Display_name = (char *) getenv("DISPLAY");
/*
 |	Check if the user specified a display on the command line
 */
	for (counter=1; counter < argc; counter++)
	{
		if (!strcmp(argv[counter], "-display"))
		{
			counter++;
			Display_name = argv[counter];
		}
	}

	argc1 = argc;
	argv1 = argv;

/*
 |	default mail command
 */
	mail_command = "xterm -e mailx";
	x = 100;
	y = 100;
	x_neg = y_neg = sx_neg = sy_neg = FALSE;
	xsh.flags = sxsh.flags = PPosition | PSize;
	timer = 30;
	border_width = 3;
	height = width = 0;
	pw = getpwuid(getuid());
	username = pw->pw_name;
	gethostname(hostname, 32);
	gethostname(real_hostname, 128);
	temp_ptr = hostname;
	while ((*temp_ptr != '\0') && (*temp_ptr != '.'))
		temp_ptr++;
	*temp_ptr = '\0';
	hostname_len = strlen(hostname);
	mail_file[0] = '\0';
	reverse_video = new_mail_reverse = new_mail_raise = new_mail_beep = FALSE;
	reverse_on = FALSE;
	view_file_name[0] = (char) NULL;
	if ((disp_ptr = XOpenDisplay(Display_name)) == 0)
	{
		fprintf(stderr, "could not open display \"%s\"\n", Display_name);
		exit(1);
	}
	screen = DefaultScreen(disp_ptr);

/*
 |	get default values from ~/.Xdefaults file
 */
	get_defaults();

/*
 |	see what options were specified on the command line
 */
	for (counter=1; counter < argc; counter++)
	{
		if (!strcmp(argv[counter], "-display"))
		{
			counter++;
			Display_name = argv[counter];
		}
		else if (!strcmp(argv[counter], "-fg"))
		{
			counter++;
			fg_color = argv[counter];
		}
		else if (!strcmp(argv[counter], "-bg"))
		{
			counter++;
			bg_color = argv[counter];
		}
		else if (!strcmp(argv[counter], "-nmbg"))
		{
			counter++;
                	nm_bg_color = argv[counter];
		}
		else if (!strcmp(argv[counter], "-sbg"))
		{
			counter++;
			summary_bg_color = argv[counter];
		}
		else if (!strcmp(argv[counter], "-bc"))
		{
			counter++;
			b_color = argv[counter];
		}
		else if (!strcmp(argv[counter], "-fn"))
		{
			counter++;
			font_name = argv[counter];
		}
		else if (!strcmp(argv[counter], "-h"))
		{
			counter++;
			height = atoi(argv[counter]);
		}
		else if (!strcmp(argv[counter], "-d"))
		{
			show_date = TRUE;
		}
		else if (!strcmp(argv[counter], "-w"))
		{
			counter++;
			width = atoi(argv[counter]);
		}
		else if (!strcmp(argv[counter], "-t"))
		{
			counter++;
			timer = atoi(argv[counter]);
		}
		else if (!strcmp(argv[counter], "-v"))
		{
			counter++;
			global_volume = atoi(argv[counter]);
		}
		else if (!strcmp(argv[counter], "-V"))
		{
			printf("%s\n", &ident[4]);
			exit(0);
		}
		else if (!strcmp(argv[counter], "-sn"))
		{
			show_new_mail = TRUE;
		}
		else if (!strcmp(argv[counter], "-nosn"))
		{
			show_new_mail = FALSE;
		}
		else if (!strcmp(argv[counter], "-F"))
		{
			no_flash = TRUE;
		}
		else if (!strcmp(argv[counter], "-tally"))
		{
			show_tally = TRUE;
		}
		else if (!strncmp(argv[counter], "-geometry", strlen(argv[counter])))
		{
			counter++;
			
			result = XParseGeometry(argv[counter], &x, &y, &width, &height);
			xsh.flags = USPosition | USSize;
			x_neg = result & XNegative;
			y_neg = result & YNegative;
		}
		else if (!strncmp(argv[counter], "-summaryGeometry", strlen(argv[counter])))
		{
			counter++;
			
			result = XParseGeometry(argv[counter], &sx, &sy, &swidth, &sheight);
			sxsh.flags = USPosition | USSize;
			sx_neg = result & XNegative;
			sy_neg = result & YNegative;
			summary_g_set = TRUE;
		}
		else if (*argv[counter] == '=')
		{
			result = XParseGeometry(argv[counter], &x, &y, &width, &height);
			xsh.flags = USPosition | USSize;
			x_neg = result & XNegative;
			y_neg = result & YNegative;
		}
		else if (!strcmp(argv[counter], "-u"))
		{
			counter++;
			username = argv[counter];
		}
		else if (!strcmp(argv[counter], "-mc"))
		{
			counter++;
			mail_command = malloc(strlen(argv[counter]) +1);
			strcpy(mail_command, argv[counter]);
		}
		else if (!strcmp(argv[counter], "-vc"))
		{
			counter++;
			view_command = malloc(strlen(argv[counter]) +1);
			strcpy(view_command, argv[counter]);
		}
		else if (!strcmp(argv[counter], "-m"))
		{
			counter++;
			strcpy(mail_file, argv[counter]);
		}
		else if (!strcmp(argv[counter], "-pop"))
		{
			new_mail_raise = TRUE;
		}
		else if (!strcmp(argv[counter], "-nopop"))
		{
			new_mail_raise = FALSE;
		}
		else if (!strcmp(argv[counter], "-beep"))
		{
			new_mail_beep = TRUE;
		}
		else if (!strcmp(argv[counter], "-nobeep"))
		{
			new_mail_beep = FALSE;
		}
		else if (!strcmp(argv[counter], "-bw"))
		{
			counter++;
			border_width = atoi(argv[counter]);
		}
		else if (!strcmp(argv[counter], "-ro"))
		{
			reverse_list = TRUE;
		}
		else if (!strcmp(argv[counter], "-r"))
		{
			reverse_video = TRUE;
		}
		else if (!strcmp(argv[counter], "-R"))
		{
			new_mail_reverse = TRUE;
		}
		else if (!strcmp(argv[counter], "-H"))
		{
			if (!name_set)
				hostname_len = FALSE;
		}
		else if (!strcmp(argv[counter], "-name"))
		{
			counter++;
			name_set = TRUE;
			strcpy(hostname, argv[counter]);
			hostname_len = strlen(hostname);
		}
		else if (!strcmp(argv[counter], "-xrm"))
		{
			/* 
			 |	ignore 
			 */
			counter++;
		}
#ifdef DEBUG
		else if (!strcmp(argv[counter], "-DEBUG"))
		{
/*
 |	The following code will start an hpterm which will in turn execute 
 |	a debugger and "adopt" the process, so it can be debugged.
 */

			int child_id;
			char command_line[256];

			child_id = getpid();
			if (!fork())
			{
				sprintf(command_line, 
	      			"xterm -geom =80x40 -fg wheat -bg DarkSlateGrey -n %s -e gdb %s %d", 
					"hello",  argv[0], child_id);
				execl("/bin/sh", "sh", "-c", command_line, NULL);
				fprintf(stderr, "could not exec new window\n");
				exit(1);
			}

/*
 |	When in debugger, set child_id to zero (p child_id=0) to continue 
 |	executing the software.
 */

			while (child_id != 0)
				;
		}
#endif
		else if ((!strcmp(argv[counter], "-?")) || (*argv[counter] == '-'))
		{
/*
 |	if option is "-?" or unrecognized, print usage message and exit
 */

			fprintf(stderr, "usage: %s [options]\n", argv[0]);
			fprintf(stderr, "          -F (do not flash when new mail)\n");
			fprintf(stderr, "          -H (do not display hostname)\n");
			fprintf(stderr, "          -R (reverse if new mail)\n");
			fprintf(stderr, "          -d (show date in summary window)\n");
			fprintf(stderr, "          -m mailbox\n");
			fprintf(stderr, "          -mc 'command_to_open_mail %%s'\n");
			fprintf(stderr, "          -name string\n");
			fprintf(stderr, "          -r (reverse video)\n");
			fprintf(stderr, "          -ro (reverse order in summary window)\n");
			fprintf(stderr, "          -sn (show new mail when received)\n");
			fprintf(stderr, "          -nosn (do not show new mail when received)\n");
			fprintf(stderr, "          -t time between mailbox checks in seconds\n");
			fprintf(stderr, "          -u username\n");
			fprintf(stderr, "          -V   print hbiff version number\n");
			fprintf(stderr, "          -v # volume for new mail beep (0-100)\n");
			fprintf(stderr, "          -vc 'command_to_open_message %%s'\n");
			fprintf(stderr, "          -fg foreground color\n");
			fprintf(stderr, "          -bg background color\n");
			fprintf(stderr, "          -nmbg new_mail_background color\n");
			fprintf(stderr, "          -sbg summary_background color\n");
			fprintf(stderr, "          -bc border color\n");
			fprintf(stderr, "          -bw size of border in pixels\n");
			fprintf(stderr, "          -fn font name\n");
			fprintf(stderr, "          -pop (if new mail, pop to top)\n");
			fprintf(stderr, "          -nopop (if new mail, do not pop to top)\n");
			fprintf(stderr, "          -beep (if new mail, notify with sound)\n");
			fprintf(stderr, "          -npbeep (if new mail, do not notify with sound)\n");
			fprintf(stderr, "          -tally (show number of messages, and how many are new)\n");
			fprintf(stderr, "          -geometry =geometry\n");
			fprintf(stderr, "          -summaryGeometry geometry\n");
			fprintf(stderr, "          -display display name\n");
			exit(-1);
		}
	}

	if (!summary_g_set)
	{
		sx = x;
		sy = y;
		sx_neg = x_neg;
		sy_neg = y_neg;
	}

/*
 |	if no font was specified, set font to "6x10"
 */
	if (font_name == '\0')
		font_name = "6x10";

/*
 |	get the font information
 */
	if ((ae_font = XLoadQueryFont(disp_ptr, font_name)) == 0)
	{
		fprintf(stderr, "could not open font\n");
		exit(1);
	}
	fontheight = ae_font->ascent + ae_font->descent;
	fontwidth = ae_font->max_bounds.rbearing - ae_font->min_bounds.lbearing;
/*
 |	figure out how tall and wide the window should be to display 
 |	the information
 */
	max_lines = (XDisplayHeight(disp_ptr, screen)) / fontheight;
	if (lines > max_lines)
		lines = max_lines;
	max_width = XDisplayWidth(disp_ptr, screen);

/*
 |	set mailbox information if not set by options
 */

	if (mail_file[0] == '\0')
	{
		for (counter = 0; *mail_locations[counter] != (char)NULL; counter++)
		{
			if ((temp = stat(mail_locations[counter], &buf)) != -1)
			{
				strcpy(mail_file, mail_locations[counter]);
				strcat(mail_file, "/");
				strcat(mail_file, username);
			}
		}
	}

/*
 |	make sure mailbox is a file
 */
	temp = stat(mail_file, &buf);
	buf.st_mode &= ~07777;
	if ((temp != -1) && (buf.st_mode != 0100000) && (buf.st_mode != 0))
	{
		file_is_dir = TRUE;
		new_mail_showing = FALSE;
		show_tally = FALSE;
	}

/*
 |	set default color information
 */
	background = XWhitePixel(disp_ptr, screen);
	foreground = BlackPixel(disp_ptr, screen);
	if (reverse_video)
	{
		border = background;
		background = foreground;
		foreground = border;
	}
	border = foreground;
	summary_background = background;
	summary_foreground = foreground;
	new_mail_foreground = foreground;
	new_mail_background = background;

	win_attrib.background_pixel = background;
	win_attrib.border_pixel = foreground;

/*
 |	set up values for placing items in window
 */

	if (hostname_len != FALSE)
		width = max(64, max((XTextWidth(ae_font, hostname, strlen(hostname))), width));
	else
		width = max(64, width);

	if (hostname_len != FALSE)
		height = max((64+fontheight+2), height);
	else
		height = max(64, height);

	if (show_tally)
	{
		width = max(width, (XTextWidth(ae_font, "333 msgs", 8)));
		width = max(width, (XTextWidth(ae_font, "333 new", 7)));
		if (hostname_len)
			height = max((64+(3*fontheight)+2), height);
		else
			height = max((64+(2*fontheight)+2), height);
	}

/*
 |	check for negative geometry information
 */
	if (x_neg)
		x = XDisplayWidth(disp_ptr, screen) + x - width - (2 * border_width);

	if (y_neg)
		y = XDisplayHeight(disp_ptr, screen) + y - height - (2 * border_width);

/*
 |	position information for pixmap
 */
	pix_x_offset = (width - 64) / 2;
	if ((hostname_len != FALSE) && (!show_tally))
		pix_y_offset = (height - (64+fontheight)) / 2;
	else if ((hostname_len != FALSE) && (show_tally))
		pix_y_offset = (height - (64+(3*fontheight))) / 2;
	else if ((hostname_len == FALSE) && (show_tally))
		pix_y_offset = (height - (64+(2*fontheight))) / 2;
	else
		pix_y_offset = (height - 64) / 2;

/*
 |	position information for text
 */
	text_x_offset = (width - (XTextWidth(ae_font, hostname, strlen(hostname)))) / 2;
	text_y_offset = pix_y_offset + 64 + ae_font->ascent;

#ifdef FORK
	if (fork())	/* detach process from tty	*/
		exit(0);
#endif


	if ((window_id = XCreateWindow(disp_ptr, RootWindow(disp_ptr, screen), 
		x, y, width, height, border_width, DefaultDepth(disp_ptr, screen), 
		InputOutput, DefaultVisual(disp_ptr, screen), (CWBackPixel | 
		CWBackPixmap | CWColormap), &win_attrib)) 
		== 0)
	{
		fprintf(stderr, "could not create window\n");
		exit(1);
	}
	if (DisplayPlanes(disp_ptr, screen) > 1) /*check for color ability*/
	{
		if ((colormap = XDefaultColormap(disp_ptr, screen)) == 0)
		{
			fprintf(stderr, "XDefaultColormap failed with error %d \n", colormap);
			exit(1);
		}

		if (fg_color != NULL)
		{
			if (XParseColor(disp_ptr, colormap, fg_color, &exact_def_return) != 0)
			{
				XAllocColor(disp_ptr, colormap, &exact_def_return);
				foreground = exact_def_return.pixel;
			}
			else
			{
				fprintf(stderr, "unable to look up color \"%s\" \n", fg_color);
				exit(1);
			}
		}

		if (bg_color != NULL)
		{
			if (XParseColor(disp_ptr, colormap, bg_color, &exact_def_return) != 0)
			{
				XAllocColor(disp_ptr, colormap, &exact_def_return);
				background = exact_def_return.pixel;
				XSetWindowBackground(disp_ptr, window_id, background);
			}
			else
			{
				fprintf(stderr, "unable to look up color \"%s\" \n", bg_color);
				exit(1);
			}
		}

		if (nm_fg_color != NULL)
		{
			if (XParseColor(disp_ptr, colormap, nm_fg_color, &exact_def_return) != 0)
			{
				XAllocColor(disp_ptr, colormap, &exact_def_return);
				new_mail_foreground = exact_def_return.pixel;
			}
			else
			{
				fprintf(stderr, "unable to look up color \"%s\" \n", fg_color);
				exit(1);
			}
		}
		else
		{
			new_mail_foreground = foreground;
		}

		if (nm_bg_color != NULL)
		{
			if (XParseColor(disp_ptr, colormap, nm_bg_color, &exact_def_return) != 0)
			{
				XAllocColor(disp_ptr, colormap, &exact_def_return);
				new_mail_background = exact_def_return.pixel;
			}
			else
			{
				fprintf(stderr, "unable to look up color \"%s\" \n", bg_color);
				exit(1);
			}
		}
		else
		{
			new_mail_background = background;
		}

		if (summary_fg_color != NULL)
		{
			if (XParseColor(disp_ptr, colormap, summary_fg_color, &exact_def_return) != 0)
			{
				XAllocColor(disp_ptr, colormap, &exact_def_return);
				summary_foreground = exact_def_return.pixel;
			}
			else
			{
				fprintf(stderr, "unable to look up color \"%s\" \n", fg_color);
				exit(1);
			}
		}
		else
		{
			summary_foreground = foreground;
		}

		if (summary_bg_color != NULL)
		{
			if (XParseColor(disp_ptr, colormap, summary_bg_color, &exact_def_return) != 0)
			{
				XAllocColor(disp_ptr, colormap, &exact_def_return);
				summary_background = exact_def_return.pixel;
			}
			else
			{
				fprintf(stderr, "unable to look up color \"%s\" \n", bg_color);
				exit(1);
			}
		}
		else
		{
			summary_background = background;
		}

		if (b_color != NULL)
		{
			if (XParseColor(disp_ptr, colormap, b_color, &exact_def_return) != 0)
			{
				XAllocColor(disp_ptr, colormap, &exact_def_return);
				border = exact_def_return.pixel;
				XSetWindowBorder(disp_ptr, window_id, border);
			}
			else
			{
				fprintf(stderr, "unable to look up color \"%s\" \n", bg_color);
				exit(1);
			}
		}
	}
/*
 |	set up values for graphics context
 */
	gcvalues.font = ae_font->fid;
	gcvalues.foreground = foreground;
	gcvalues.background = background;
	gc = XCreateGC(disp_ptr, window_id, (GCFont | GCForeground | 
			GCBackground), &gcvalues);
	gcvalues.foreground = background;
	gcvalues.background = foreground;

/*
 |	set up values for reverse video graphics context
 */
	rev_gc = XCreateGC(disp_ptr, window_id, (GCFont | GCForeground | 
			GCBackground), &gcvalues);

/*
 |	set up values for new mail graphics context
 */
	gcvalues.foreground = new_mail_foreground;
	gcvalues.background = new_mail_background;

	new_mail_gc = XCreateGC(disp_ptr, window_id, (GCFont | GCForeground | 
			GCBackground), &gcvalues);

/*
 |	set up values for summary graphics context
 */

	gcvalues.foreground = summary_foreground;
	gcvalues.background = summary_background;

	summary_gc = XCreateGC(disp_ptr, window_id, (GCFont | GCForeground | 
			GCBackground), &gcvalues);

/*
 |	set up bitmaps for the different mailboxes 
 |	(no mail, old mail, or new mail)
 */

	pix[0] = XCreateBitmapFromData(disp_ptr, window_id, (char *) nomail_bits, 64, 64);
	pix[1] = XCreateBitmapFromData(disp_ptr, window_id, (char *) newmail_bits, 64, 64);
	pix[2] = XCreateBitmapFromData(disp_ptr, window_id, (char *) oldmail_bits, 64, 64);

/*
 |	set up values for window
 */
	xsh.height = height;
	xsh.width  = width;
	xsh.x      = x;
	xsh.y      = y;
	xsh.flags = USPosition | USSize;

	XSetStandardProperties(disp_ptr, window_id, "hbiff", "hbiff", pix[1],
				argv, argc, &xsh);

	XSetCommand(disp_ptr, window_id, argv, argc);

	class_spec.res_name = "hbiff";
	class_spec.res_class = "HBiff";
	XSetClassHint(disp_ptr, window_id, &class_spec);

/*
 |	Set the client host name
 */

	arglist[0] = real_hostname;
	value = XStringListToTextProperty(arglist, 1, &property_list);

	XSetWMClientMachine(disp_ptr, window_id, &property_list);

	XSelectInput(disp_ptr, window_id, (ButtonPressMask | KeyPressMask | ExposureMask ));
	XMapWindow(disp_ptr, window_id);
	XFlush(disp_ptr);
	curr_state = 0;

/*
 |	get mailbox status and paint the window
 */
	update_icon(curr_state);
	checkmail();
	timeout.tv_sec = timer;
	timeout.tv_usec = 0;
	button_event = (XButtonEvent *) &event;
	done = 0;
	xfd = ConnectionNumber(disp_ptr);
	(void) set_window_name(hostname);
/* 
 |	Loop forever,  examining each event. 
 */
	while (!done) {
/* Get the next event */
		number_of_events = 0;
		while (!number_of_events)
		{
			ttymask = MASK(xfd);
			readfds = ttymask;
			timeout.tv_sec = timer;
			timeout.tv_usec = 0;
			temp = select(xfd+1, (fd_set *)&readfds, 0, 0, &timeout);
			number_of_events = XPending(disp_ptr);
			if ((temp > 0) && (number_of_events == 0))
			{
				done++;
				break;
			}
			checkmail();
		}
		while (XPending(disp_ptr))
		{
			XNextEvent(disp_ptr, &event);
/*
 |	Determine the event type and deal with it accordingly. 
 */

			switch (event.type) {
				case Expose:
					if (event.xexpose.window == from_wid)
						paint_lines(new_mail_showing);
					else if (event.xexpose.count == 0)
						update_icon(curr_state);
					break;
				case MappingNotify:
					XRefreshKeyboardMapping ( &event.xmapping);
					break;
				case KeyPress:
					i = XLookupString(&event.xkey, text, 10, &key, NULL);
					if (i == 1 && text[0] == 'q') 
						done++;
					if (from_wid)
						nuke_summary_window();
					break;
				case ButtonPress:
					if ((button_event->button == Button3) && (button_event->state == ShiftMask))
						done++;
					else if ((button_event->button == Button3) && (child_num == 0))
					{
						if (from_wid)
							nuke_summary_window();
						if (no_flash == FALSE)
							flash_icon(curr_state);
						signal(SIGCHLD, clear_child);
						if (!(child_num = fork()))
						{
							system(mail_command);
							exit(0);
						}
					}
					else if ((button_event->button == Button2) && (!from_wid))
					{
						get_from_lines();
						display_lines(FALSE);
					}
					else if ((button_event->button == Button1) && (curr_state != nomail))
					{
/*
 |	reset access time on mailbox, so that hbiff does not think 
 |	there is new mail
 */
						if (button_event->window == from_wid)
						{
							y = button_event->y / fontheight;
							if (vchild_num == 0)
								(void) dump_message(y);
						}

/*						if (from_wid)
							nuke_summary_window();
*/
						fp = fopen(mail_file, "r");
						if (fp != NULL)
						{
							fgets(buffer, 512, fp);
							fclose(fp);
						}
						checkmail();
					}
					else if (from_wid)
						nuke_summary_window();
					unmark_msgs(new_msg_list);
					if (curr_state == newmail)
					{
						curr_state = oldmail;
						get_from_lines();
						update_icon(curr_state);
					}
					break;
			} /* switch */
		}
	} /* while (!done) */

/*
 |	leave hbiff
 */
	XFreeGC(disp_ptr, gc);
	XFreeGC(disp_ptr, rev_gc);
	XFreeGC(disp_ptr, new_mail_gc);
	XFreeGC(disp_ptr, summary_gc);
	XDestroyWindow(disp_ptr, window_id);
	XCloseDisplay(disp_ptr);
}

flash_icon(state)
int state;
{
	paint_window(state, rev_gc, foreground);
	sleep(1);
	paint_window(state, gc, background);
}

paint_window(state, context, background)
int state;
GC context;
unsigned long background;
{
	int local_y;
	int new_off, msgs_off;

	local_y = text_y_offset;
	if (show_tally)
	{
		sprintf(num_of_msgs, "%d msgs", lines);
		sprintf(num_of_new, "%d new", new_lines);
		new_off = (width - XTextWidth(ae_font, num_of_new, strlen(num_of_new))) / 2;
		msgs_off = (width - XTextWidth(ae_font, num_of_msgs, strlen(num_of_msgs))) / 2;
	}
	XSetWindowBackground(disp_ptr, window_id, background);
	XClearWindow(disp_ptr, window_id);
	XCopyPlane(disp_ptr, pix[state], window_id, context, 0, 0, width, height, pix_x_offset, pix_y_offset, 1);
	if (show_tally)
	{
		XDrawImageString(disp_ptr, window_id, context, msgs_off, local_y, num_of_msgs, strlen(num_of_msgs));
		local_y += fontheight;
		if (new_lines)
			XDrawImageString(disp_ptr, window_id, context, new_off, local_y, num_of_new, strlen(num_of_new));
		local_y += fontheight;
	}
	if (hostname_len != FALSE)
		XDrawImageString(disp_ptr, window_id, context, text_x_offset, local_y, hostname, hostname_len);
	XFlush(disp_ptr);
}

update_icon(state)
int state;
{
	XWMHints hints;

	if ((state == newmail) && (!new_mail_reverse))
	{
		paint_window(state, new_mail_gc, new_mail_background);
	}
	else if (reverse_on)
	{
		paint_window(state, rev_gc, foreground);
	}
	else
	{
		paint_window(state, gc, background);
	}
/*	XSetStandardProperties(disp_ptr, window_id, "hbiff", "hbiff", 
				pix[state], argv1, argc1, &xsh); */
	hints.flags = IconPixmapHint;
	hints.icon_pixmap = pix[state];
	XSetWMHints(disp_ptr, window_id, &hints);

	XFlush(disp_ptr);
}

checkmail()
{
	static int old_state = 0;	/* initially "nomail"	*/
	static int file_size = 0;
	static time_t last_modified = 0;
	static struct utimbuf timebuf;

	old_state = curr_state;
	if (stat(mail_file, &file_status) == -1)
	{
		curr_state = nomail;
		file_status.st_size = 0;
	}
	else 
	{
		if (file_status.st_size == 0)
			curr_state = nomail;
		else if ((file_status.st_atime <= file_status.st_mtime) ||
			 ((file_status.st_atime <= last_hbiff_access) && 
			  (curr_state == newmail)))
		{
			curr_state = newmail;
/*
 |	Even if the window already indicates new mail, do the appropriate 
 |	operations if there is more new mail.
 */
			if ((old_state == curr_state) && (last_modified < file_status.st_mtime))
			{
				old_state = oldmail;
			}
			last_modified = file_status.st_mtime;
		}
		else /* if (file_status.st_atime > file_status.st_mtime) */
		{
			curr_state = oldmail;
			if (((file_status.st_ctime > last_hbiff_access) || 
			     (file_status.st_atime > last_hbiff_access)) && 
			    (show_new_mail || show_tally))
			{
				get_from_lines();
				update_icon(curr_state);
			}
		}
	}
	if (curr_state != newmail)
		reverse_on = FALSE;
	if (old_state != curr_state)
	{
		if (from_wid)
			nuke_summary_window();
		get_from_lines();
		if (curr_state == newmail)
		{
			if (!file_is_dir)
			{
			/*
			 |	Reset file times so that other mechanisms will
			 |	still be able to detect that mail is new.
			 */
				timebuf.actime = timebuf.modtime = last_modified;
				utime(mail_file, &timebuf);
			}

			if (new_mail_reverse)
				reverse_on = TRUE;
			if (new_mail_raise)
			{
				XRaiseWindow(disp_ptr, window_id);
				XFlush(disp_ptr);
				update_icon(curr_state);
			}
			if (no_flash == FALSE)
			{
				flash_icon(curr_state);
				sleep(1);
				flash_icon(curr_state);
			}
			if (new_mail_beep)
				beep_new();
			if (show_new_mail && new_lines)
			{
				new_mail_showing = TRUE;
				display_lines(new_mail_showing);
			}
		}
		else
			unmark_msgs(new_msg_list);
		update_icon(curr_state);
	}
}

get_defaults()
{
	char *string;

	summary_fg_color = XGetDefault(disp_ptr, "hbiff", "summaryForeground");
	summary_bg_color = XGetDefault(disp_ptr, "hbiff", "summaryBackground");
	nm_fg_color = XGetDefault(disp_ptr, "hbiff", "newMailForeground");
	nm_bg_color = XGetDefault(disp_ptr, "hbiff", "newMailBackground");
	fg_color = XGetDefault(disp_ptr, "hbiff", "foreground");
	bg_color = XGetDefault(disp_ptr, "hbiff", "background");
	b_color = XGetDefault(disp_ptr, "hbiff", "borderColor");
	if (string = XGetDefault(disp_ptr, "hbiff", "time"))
		timer = atoi(string);
	if (string = XGetDefault(disp_ptr, "hbiff", "volume"))
		global_volume = atoi(string);
	
	if (string = XGetDefault(disp_ptr, "hbiff", "geometry"))
	{
		result = XParseGeometry(string, &x, &y, &width, &height);
		xsh.flags = USPosition | USSize;
		x_neg = result & XNegative;
		y_neg = result & YNegative;
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "summaryGeometry"))
	{
		result = XParseGeometry(string, &sx, &sy, &swidth, &sheight);
		sxsh.flags = USPosition | USSize;
		sx_neg = result & XNegative;
		sy_neg = result & YNegative;
		summary_g_set = TRUE;
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "newMailRaise"))
	{
		new_mail_raise = yes_string(string);
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "newMailBeep"))
	{
		new_mail_beep = yes_string(string);
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "borderWidth"))
		border_width = atoi(string);
	if (string = XGetDefault(disp_ptr, "hbiff", "mailCommand"))
	{
		mail_command = (char *) malloc(strlen(string) + 1);
		strcpy(mail_command, string);
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "viewCommand"))
	{
		view_command = (char *) malloc(strlen(string) + 1);
		strcpy(view_command, string);
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "fontName"))
		font_name = string;
	if (string = XGetDefault(disp_ptr, "hbiff", "reverseVideo"))
	{
		reverse_video = yes_string(string);
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "reverseOrder"))
	{
		reverse_list = yes_string(string);
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "newMailReverse"))
	{
		new_mail_reverse = yes_string(string);
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "showNewMail"))
	{
		show_new_mail = yes_string(string);
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "tally"))
	{
		show_tally = yes_string(string);
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "date"))
	{
		show_date = yes_string(string);
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "noFlash"))
	{
		no_flash = yes_string(string);
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "noHostname"))
	{
		if ((yes_string(string)) && (!name_set))
			hostname_len = FALSE;
	}
	if (string = XGetDefault(disp_ptr, "hbiff", "name"))
	{
		strcpy(hostname, string);
		name_set = TRUE;
		hostname_len = strlen(hostname);
	}
}

/*
 |	check string for a positive value (on, yes, true)
 */

yes_string(string)
char *string;
{
	char temp_string[16];
	int counter;

	if (strlen(string) > 4)
		return(FALSE);

	for (counter = 0; counter < strlen(string); counter++)
		temp_string[counter] = toupper(string[counter]);

	temp_string[counter] = (char)NULL;

	if ((strcmp(temp_string, "YES") == 0) 
		|| (strcmp(temp_string, "TRUE") == 0) 
			|| (strcmp(temp_string, "ON") == 0))
		return(TRUE);
	else
		return(FALSE);
}

/*
 |	Create list of mail messages, and check for messages that were not 
 |	present previously.  For messages that were considered new in the 
 |	old list, set flag to indicate that they are new in the new list, too.
 */

#define buff_len 512
int after_first_time = FALSE;

get_from_lines()
{
	int counter;
	char *file_name;
	struct from_text *list_head, *temp_ptr;
	struct from_text *new_ptr, *old_ptr;
	char buffer[buff_len];
	char buffer2[buff_len];
	char from_buffer[buff_len];
	char subj_buffer[buff_len];
	char date_buffer[buff_len];
	char *temp;
	int sub_flag;
	int from_flag;
	int line_len, max_len;
	int max_lines, max_width;
	int done;
	int temp_int;
	int found;
	int retval;
	int len, len2;
	struct stat lfile_status;

	if (file_is_dir)
		return(0);

	temp_int = stat(mail_file, &lfile_status);

	if ((file_status.st_size == lfile_status.st_size) && 
	    (file_status.st_ctime < last_hbiff_access) && after_first_time)
	{
        	if ((fp = fopen(mail_file, "r")) == NULL)
        	        return(0);

	        fclose(fp);

        	temp_int = stat(mail_file, &file_status);
		last_hbiff_access = file_status.st_atime;

		return(0);
	}

	after_first_time = TRUE;

	lines = 0;
	new_lines = 0;

	if (old_msg_list != NULL)
	{
		free_list(old_msg_list);
	}
	old_msg_list = new_msg_list;
	new_msg_list = NULL;

	if (temp_int != -1)
	{
		last_hbiff_access = lfile_status.st_atime;
		/*
		 |	make sure that file is non-zero size
		 */
		if (lfile_status.st_size == 0)
			return(0);
	}
	else
	{
		/*
		 |	couldn't stat the file
		 */
		return(0);
	}


/*
 |	open mailbox
 */
	if ((fp = fopen(mail_file, "r")) == NULL)
		return(0);

	sub_flag = from_flag = FALSE;
	memset(buffer2, 0, buff_len);
	memset(subj_buffer, 0, buff_len);
	memset(date_buffer, 0, buff_len);
	memset(from_buffer, 0, buff_len);
	list_head = NULL;

/*
 |	create a linked list of lines containing the "From" and "Subject:" 
 |	information from each mail message
 */
	retval = fgetpos(fp, &location);
	while ((temp = getline(buffer, buff_len, fp)) != NULL)
	{
		if (!(strncmp(buffer, "From ", 5)))	/* start of message */
		{
			from_flag = TRUE;
			strncpy(from_buffer, buffer, (strlen(buffer) - 1));
			from_location = location;
		}
		else if ((!(strncmp(buffer, "From: ", 5))) && from_flag)
		{
			from_parse(from_buffer, buffer);
		}
		else if ((!(strncmp(buffer, "Subject: ", 9))) && from_flag &&
			 (subj_buffer[0] == (char) NULL))
		{
			sub_flag = TRUE;
			strncat(subj_buffer, " [", 2);
			len = strlen(buffer);
			if (len >= buff_len)
				strncat(subj_buffer, buffer, (len - 4) - 1);
			else
				strcat(subj_buffer, buffer);
			strncat(subj_buffer, "]", 1);
		}
		else if ((!(strncmp(buffer, "Date: ", 6))) && from_flag && show_date)
		{
			temp = (temp = strstr(buffer, ", ")) == NULL ? buffer : (temp + 2);
			len = strlen(temp);
			if (len >= buff_len)
				strncat(date_buffer, temp, (buff_len - 1) );
			else
				strncat(date_buffer, temp, (strlen(temp)-1) );
			temp = strstr(date_buffer, "\n");
			if (temp != NULL)
				*temp = (char)NULL;
		}
		else if (((buffer[0] == '\n') || (buffer[0] == '\r')) && (from_flag))
		{
			if (!sub_flag)
			{
				from_flag = sub_flag = FALSE;
				continue;
			}
			buffer2[0] = (char) NULL;
			if (show_date)
			{
				strcat(buffer2, date_buffer);
				strncat(buffer2, 
			 "                                                  ", 
					(16 - (strlen(buffer2) % 16)));
			}
			strcat(buffer2, from_buffer);
			strncat(buffer2, "            ", 
					(8 - (strlen(buffer2) % 8)));
			len = strlen(buffer2);
			len2 = strlen(subj_buffer);
			if ((len + len2 + 1) >= (buff_len))
				strncat(buffer2, subj_buffer, ((buff_len - len) - 1));
			else
				strcat(buffer2, subj_buffer);

			memset(from_buffer, 0, buff_len);
			memset(date_buffer, 0, buff_len);
			memset(subj_buffer, 0, buff_len);
			if (list_head == NULL)
			{
				temp_ptr = list_head = (struct from_text *) malloc(sizeof(struct from_text));
				temp_ptr->prev = NULL;
			}
			else
			{
				temp_ptr = list_head;
				while (temp_ptr->next != NULL)
					temp_ptr = temp_ptr->next;
				temp_ptr->next = (struct from_text *) malloc(sizeof(struct from_text));
				temp_ptr->next->prev = temp_ptr;
				temp_ptr = temp_ptr->next;
			}
			temp_ptr->flag = FALSE;
			temp_ptr->length = strlen(buffer2) + 2;
			temp_ptr->string = (char *) malloc(temp_ptr->length);
			temp_ptr->from_location = from_location;
			strcpy(temp_ptr->string, " ");
			strcat(temp_ptr->string, buffer2);
			temp_ptr->next = NULL;
			from_flag = sub_flag = FALSE;
			lines++;
			memset(buffer2, 0, buff_len);
		}
		retval = fgetpos(fp, &location);
	}

	if (list_head == 0)
	{
		/*
		 |	The mailbox is not in an expected format!
		fprintf(stderr, "hbiff: mailbox corrupted!\n");
		 */
		fclose(fp);
		return(0);
	}

	temp_ptr = list_head;

	/*
	 |	indicate which is the most recent message
	 */

	while (temp_ptr->next != NULL)
		temp_ptr = temp_ptr->next;
	temp_ptr->string[0] = '>';
	temp_ptr = list_head;

	if (reverse_list)
	{
		while (list_head->next != NULL)
			list_head = list_head->next;
		reverse_order(temp_ptr);
		temp_ptr = list_head;
	}

	new_msg_list = list_head;

	for (new_ptr = new_msg_list; new_ptr != NULL; new_ptr = new_ptr->next)
	{
		found = FALSE;
		for (old_ptr = old_msg_list; (old_ptr != NULL) && (!found); 
			old_ptr = old_ptr->next)
		{
			if (old_ptr->string && (!strcmp((new_ptr->string+1), (old_ptr->string+1))))
			{
				free(old_ptr->string);
				old_ptr->string = NULL;
				found = TRUE;
				if (old_ptr->flag)
				{
					new_lines++;
					new_ptr->flag = TRUE;
				}
			}
		}
		if ((!found) && (curr_state == newmail))
		{
			new_lines++;
			new_ptr->flag = TRUE;
		}
	}
	fclose(fp);
	if (stat(mail_file, &file_status) != -1)
	{
		last_hbiff_access = file_status.st_atime;
	}
}

/*
 |	Create window of appropriate size to display mail summary.
 */

display_lines(new_mail_only)
int new_mail_only;
{
	XSizeHints xsh;
	char *file_name;
	char buffer[512];
	char buffer2[512];
	char from_buffer[512];
	char subj_buffer[512];
	char *temp;
	int sub_flag;
	int from_flag;
	int line_len = 0, max_len = 0;
	int done;
	int temp_int;
	int counter;
	int lines_to_display = 0;
	struct from_text *temp_ptr;

	/* copy size hints */
	xsh.flags = sxsh.flags;
	xsh.x = sx;
	xsh.y = sy;

	temp_ptr = new_msg_list;

	while (temp_ptr != NULL)
	{
		if ((new_mail_only && temp_ptr->flag) || (!new_mail_only))
		{
			lines_to_display++;
			line_len = XTextWidth(ae_font, temp_ptr->string, (temp_ptr->length -1));
		}
		if (line_len > max_len)
			max_len = line_len;
		temp_ptr = temp_ptr->next;
	}

	if (lines_to_display == 0)
		return(0);

	if (max_len > max_width)
		max_len = max_width;

/*
 |	set up summary window information
 */

	xsh.height = lines_to_display * fontheight;
	xsh.width  = max_len + 6;

	if (sxsh.flags == (USPosition | USSize)) /* really specified by user */
	{ 
	/*
	 |	check for negative geometry information
	 */
		if (sx_neg)
			xsh.x = XDisplayWidth(disp_ptr, screen) + sx - xsh.width - (2 * border_width);
		else
			xsh.x = sx;
		if (sy_neg)
			xsh.y = XDisplayHeight(disp_ptr, screen) + sy - xsh.height - (2 * border_width);
		else
			xsh.y = sy;
	} 
	else 
	{
		xsh.x      = max(0, (sx - xsh.width));
		xsh.y      = max(0, (sy - xsh.height));
		xsh.flags = USPosition | USSize;
	}

	if ((from_wid = XCreateWindow(disp_ptr, RootWindow(disp_ptr, screen), 
		xsh.x, xsh.y, xsh.width, xsh.height, border_width, 
		DefaultDepth(disp_ptr, screen), 
		InputOutput, DefaultVisual(disp_ptr, screen), (CWBackPixel | 
		CWBackPixmap | CWColormap), &win_attrib)) 
		== 0)
	{
		fprintf(stderr, "could not create window for \"From\" info\n");
	}

	XSetStandardProperties(disp_ptr, from_wid, "hbiff", "hbiff", pix[1],
				argv1, argc1, &xsh);

	XSetClassHint(disp_ptr, from_wid, &class_spec);
	XSetWindowBackground(disp_ptr, from_wid, summary_background);
	XSelectInput(disp_ptr, from_wid, (ButtonPressMask | KeyPressMask | ExposureMask ));
	XMapWindow(disp_ptr, from_wid);
	XFlush(disp_ptr);

	paint_lines(new_mail_only);
}

/*
 |	Print appropriate summary information in summary window.
 */

paint_lines(new_mail_only)
int new_mail_only;
{
	struct from_text *temp_ptr;
	int counter, i;
/*
 |	display the text
 */

	for (i = 0, temp_ptr = new_msg_list, counter = 0; i < lines; i++)
	{
		if ((new_mail_only & temp_ptr->flag) || (!new_mail_only))
		{
			XDrawImageString(disp_ptr, from_wid, summary_gc, 2, 
			  ((counter * fontheight) + ae_font->ascent), 
			  temp_ptr->string, (temp_ptr->length - 1));
			counter++;
		}
		temp_ptr = temp_ptr->next;
	}
	XFlush(disp_ptr);
}

nuke_summary_window()
{
/*
 |	Destroy summary window.
 */

	XDestroyWindow(disp_ptr, from_wid);
	from_wid = 0;
	new_mail_showing = FALSE;
}

/*
 |	traverse the list and reverse the ordering
 */

reverse_order(ptr)
struct from_text *ptr;
{
	struct from_text *list_ptr;
	struct from_text *tmp_ptr;

	list_ptr = ptr;
	while (list_ptr != NULL)
	{
		tmp_ptr = list_ptr->next;
		list_ptr->next = list_ptr->prev;
		list_ptr->prev = tmp_ptr;
		list_ptr = list_ptr->prev;
	}
}

/*
 |	Traverse the list and reset flags indicating that a message is 
 |	considered new.
 */

unmark_msgs(ptr)
struct from_text *ptr;
{
	struct from_text *tmp_ptr = ptr;

	while (tmp_ptr != NULL)
	{
		tmp_ptr->flag = FALSE;
		tmp_ptr = tmp_ptr->next;
	}
	new_lines = 0;
}

free_list(ptr)
struct from_text *ptr;
{
/*
 |	recursively traverse linked list, freeing data
 */
	if (ptr->next != NULL)
	{
		free_list(ptr->next);
	}
	if (ptr->string != NULL)
	{
		free(ptr->string);
	}
	free(ptr);
}

from_parse(out_buffer, in_buffer)
char *out_buffer, *in_buffer;
{
	int counter;
	char *temp_ptr;
	char *start_of_name;
	char open_paren, close_paren;

	open_paren = '(';
	close_paren = ')';

	memset(out_buffer, 0, 512);

	if ((temp_ptr = strchr(in_buffer, '"')))
	{
		/* move to first character after open quote */
		temp_ptr++;
		start_of_name = temp_ptr;
		for (counter = 0; ((*temp_ptr != (char)NULL) && 
		     (*temp_ptr != '"') && (counter < 512)); counter++)
			temp_ptr++;
		strcpy(out_buffer, "From: ");
		strncat(out_buffer, start_of_name, counter);
	}
	else if ((temp_ptr = strchr(in_buffer, open_paren)))
	{
		/* move to first character after open paren */
		temp_ptr++;
		start_of_name = temp_ptr;
		for (counter = 0; ((*temp_ptr != (char)NULL) && 
		     (*temp_ptr != close_paren) && (counter < 512)); counter++)
			temp_ptr++;
		strcpy(out_buffer, "From: ");
		strncat(out_buffer, start_of_name, counter);
	}
	else if ((temp_ptr = strchr(in_buffer, '<')))
	{
		temp_ptr = in_buffer;
		while ((*temp_ptr != ' ') && (*temp_ptr != (char)NULL))
			temp_ptr++;
		while ((*temp_ptr == ' ') && (*temp_ptr != (char)NULL))
			temp_ptr++;
		start_of_name = temp_ptr;
		for (counter = 0; ((*temp_ptr != (char)NULL) && 
		     (*temp_ptr != '<') && (counter < 512)); counter++)
			temp_ptr++;
		strcpy(out_buffer, "From: ");
		strncat(out_buffer, start_of_name, counter);
	}
	else
	{
		strcpy(out_buffer, in_buffer);
	}
}

clear_child()
{
	int value;

	value = wait(0);
	if (value == child_num)
		child_num = 0;
	else if (value == vchild_num)
	{
		vchild_num = 0;
		if (view_file_name[0] != (char) NULL)
		{
			unlink(view_file_name);
			view_file_name[0] = (char) NULL;
		}
	}
	if ((child_num != 0) || (vchild_num != 0))
		signal(SIGCHLD, clear_child);
}

/*
 |	The code for setting the beeper to a different tone, beeping, and 
 |	restoring the beeper settings to what they were before is taken from 
 |	code written by someone else.
 */

restore_kbd()
{
    int mask;
    /* Restore initial bell values */
    mask = KBBellPercent | KBBellPitch | KBBellDuration;
    XChangeKeyboardControl(disp_ptr, mask, &save_kbd);
    
    XFlush (disp_ptr);
}

void high_res_sleep(milli_seconds)
long milli_seconds;
{
    int             fds = 0;
    struct timeval  timeout;
    
    timeout.tv_sec  = milli_seconds / 1000; 		/* Seconds */
    timeout.tv_usec = (milli_seconds % 1000) * 1000; 	/* Micro-seconds */
    select(0, (fd_set *)&fds, (fd_set *)&fds, (fd_set *)&fds, &timeout);
}

#define SLEEP_TIMER_OVERHEAD 20;   /* Milliseconds overhead in sleep routine */

/*
 * Play a tone.
 * The HP buffer-box with speaker seems to be capable of a range from
 * 82 Hz thru 16666 Hz inclusive.
 * 0 to 81 Hz are non-existent.  16667 Hz and above are non-existent.
 */
void tone(volume, pitch, duration)
int volume, pitch, duration;
{
    XKeyboardControl	set_bell;
    unsigned int 	mask;
    unsigned int 	overhead;
    
    overhead = SLEEP_TIMER_OVERHEAD;	/* May need to be fancier, someday. */
    if (duration < (overhead + 10)) overhead = 0;
    
    /* Limit changes to Bell */
    mask = KBBellPercent | KBBellPitch | KBBellDuration;
    
    /* Make some changes. */
    set_bell.bell_percent = volume;
    set_bell.bell_pitch  = pitch;
    set_bell.bell_duration = duration;
    XChangeKeyboardControl(disp_ptr, mask, &set_bell);
    XBell (disp_ptr, 0);
    XFlush (disp_ptr);
    high_res_sleep(duration - overhead);
}

beep_new()
{
    XKeyboardState	query_kbd;

    /* Save current values in query_kbd */
    XGetKeyboardControl(disp_ptr, &query_kbd);
    
    save_kbd.bell_percent = query_kbd.bell_percent;
    save_kbd.bell_pitch  = query_kbd.bell_pitch;
    save_kbd.bell_duration = query_kbd.bell_duration;
    
    tone(global_volume, 523, 360);
    tone(global_volume, 1, 40);
    tone(global_volume, 392, 720);

    restore_kbd();
}

void 
set_window_name(name)
char *name;
{
	static char *window_name = NULL;
	int result;

	if (window_name != NULL)
		free(window_name);

	window_name = malloc(strlen("hbiff:") + strlen(name) + 1);
	strcpy(window_name, "hbiff:");
	strcat(window_name, name);
	result = XStoreName(disp_ptr, window_id, window_name);
	result = XSetIconName(disp_ptr, window_id, window_name);
}

void 
dump_message(y)
int y;
{
	int dcounter;
	struct from_text *entry;
	char * temp;
	char buffer[512];
	int from_found = FALSE;
	FILE *fp2;
	fpos_t curr_loc, end_loc;
	int retval;

	sprintf(view_file_name, "/tmp/hbiff.%d", getpid());
	fp2 = fopen(view_file_name, "w");
	if (fp2 == NULL)
		return;

	fp = fopen(mail_file, "r");
	if (fp == NULL)
	{
		fclose(fp2);
		return;
	}

	for (dcounter = 0, entry = new_msg_list; 
	     (entry != NULL) && (dcounter < y); 
	       dcounter++, entry = entry->next)
	       ;
	dcounter = fsetpos(fp, &(entry->from_location));
	if (reverse_list)
	{
		if (entry->prev != NULL)
			end_loc = entry->prev->from_location;
		else
			end_loc = file_status.st_size;  /* really big number */
	}
	else
	{
		if (entry->next != NULL)
			end_loc = entry->next->from_location;
		else
			end_loc = file_status.st_size;  /* really big number */
	}
	temp = fgets(buffer, 512, fp);
	do 
	{
		fputs(buffer, fp2);
		temp = fgets(buffer, 512, fp);
		retval = fgetpos(fp, &curr_loc);
	}
	while ((temp != NULL) && (curr_loc < end_loc));

	fclose(fp2);
	fclose(fp);
	sprintf(buffer, view_command, view_file_name);

	signal(SIGCHLD, clear_child);
	if (!(vchild_num = fork()))
	{
		system(buffer);
		exit(0);
	}
}
