/*
** TI-99/4A emulator main program.
** (c) 1993 by T. Brouwer
**
**
*/

#include <stdio.h>
#ifndef unix
#ifndef AMIGA
#include <alloc.h>
#endif
#else
#include <malloc.h>
#include <sys/ioctl.h>
struct termio cb;
#endif
#include <string.h>
#include "ti99emul.h"
#include "instr.h"
#include "opc_tabl.c"
#include "sysdepen.c"	/* system dependent routines */
#include "grom.c"	/* handle GROM access */
#include "vdp.c"        /* display emulator, vdp memory access */
#include "memory.c"	/* handle memory accesses */
#include "boot.c"	/* setup environment (ROMs & GROMs) */
#include "operands.c"	/* decode instruction operands */
#include "kscan.c"	/* KSCAN bypass routine */
#include "status.c"	/* handle status register setting */
#include "processor.c"	/* fetch, decode & execute 9900 instructions */
#include "dsk1.c"	/* Disk access emulation */
#include "sound.c"	/* Sound chip emulation */

/***********************************************************************/

void main(int argc,char *argv[])
{
	/* Set config filename from cmdline argument or default */

	char configname[15];
#ifdef unix
	ioctl(_IOC_READ, TCGETA, &cb);
	cb.c_lflag&=~(ICANON|ECHO);
	ioctl(_IOC_READ, TCSETA, &cb);
#endif
	if (argc>1) strcpy(configname,argv[1]);
	else strcpy(configname,"ticonfig.dat");

	/* allow for initialisation for every functional unit of the
	   emulator */

	clear_screen();
	printf("TI-99/4A Emulator\nWritten by Ton Brouwer\nVersion 7/5/1993\n\n");

	init_vdp();
	init_cpu();
	init_grom();
	load_roms(configname);

	printf("\n\nPress any key to powerup.\n");
	wait_for_keypress();
#ifdef AMIGA
        tifont();
        puts("\033c");
#endif
        clear_screen();
	printf("wait...\n");

/* This is the implementation of the vonn Neumann
** cycle: Fetch, decode, execute.
*/

	/* Initialise 9900 internal registers */

	STATUS=IR=0;
	WP=memory_read(0);
	PC=memory_read(2);

	while(TRUE)
	{
		IR=memory_read(PC);	/* fetch */
		PC+=2;                  /* update program counter */
		(*opcode_table[IR>>8])();	/* execute instruction */
	}

} /* end of main */


void _TAB2(void)
{
	(*low_opcode_table[IR>>5])();
}




