/* root v1.2 by interrupt request <irq@collective.org> http://www.collective.org/
   verify() function - verifys uid in /etc/rooters (ROOTERS_FILE).
   Called from main()   

   Passed-to variables: int uid - numerical uid representing the user
   Returns: 3 if it can't open /etc/rooters (ROOTERS_FILE);
            1 if verified;
            0 if not verified
*/

#include <stdio.h>
#include <string.h>
#include "main.h"

int verify(int uid)
{
	FILE *fp;
	char rooter[256];
	int daeof = 0;
	int temp = 1;
	int fileuid;
	fp = fopen(ROOTERS_FILE, "r");
	if (!fp) {
		printf("\nError: Cannot open %s\n", ROOTERS_FILE);
		return 3;
	}
	while (temp == 1) {
		daeof = fgets(rooter, 80, fp);
		if (daeof == NULL) { return 0; }
		strtok(rooter, "\n");
		fileuid = atoi(rooter);
		if (uid == fileuid) {
			return 1;
		}
	}
	return 0;
}
