/* root v1.2 by interrupt request <irq@collective.org>, http://www.collective.org/
   main() function - calls verify() to verify the uid in /etc/rooters
   (ROOTERS_FILE), and if verified executed the specified command as root 
   (argv[1 thru infinity]) and then calls log() to log the command to 
   /var/log/rooters (LOG_FILE). Also changes UID to 0.

   Passed-to variables: int argc and char *argv[], the count of command
                        line arguments, and the actual command line
                        arguments.
   Returns: 0 (noerr)
   
   Main #define's are in main.h
   NOTE: root must be set-uid root in order to function as designed.
   Don't forget /etc/rooters !
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "main.h"

int main(int argc, char *argv[])
{
	int uid = getuid();
	int verified;
	int i = 1;
	int errlvl = 0;
	char toSystem[256];
	verified = verify(uid);
	if (argc <= 1) {
		printf("\nroot - sudo clone by interrupt request");
		printf("\nUsage: %s command, to be executed as root\n", argv[0]);
		return 0;
	}
	if (verified == 1) {
		printf("\nVerified, continuing with command.\n");
		setuid(0);
		while (i < argc) {
			strcat(toSystem, " ");
			strcat(toSystem, argv[i]);
			i++;
		}
		errlvl = log(toSystem);
		system(toSystem);
		return 0;
	}
	else {
		printf("\nNot-verified or error\n");
	}
}
