#!/usr/bin/perl

# date support routines
# Copr. 1997 Chris Nott (c.nott@student.canberra.edu.au)

my (@monthstr,@mdays,$firstday);

# name of the months
$monthstr[0]  = 'Jan';
$monthstr[1]  = 'Feb';
$monthstr[2]  = 'Mar';
$monthstr[3]  = 'Apr';
$monthstr[4]  = 'May';
$monthstr[5]  = 'Jun';
$monthstr[6]  = 'Jul';
$monthstr[7]  = 'Aug';
$monthstr[8]  = 'Sep';
$monthstr[9]  = 'Oct';
$monthstr[10] = 'Nov';
$monthstr[11] = 'Dec';

# number of days in each month
$mdays[0] = 31;
$mdays[1] = 28;	# 29 in leap yr
$mdays[2] = 31;
$mdays[3] = 30;
$mdays[4] = 31;
$mdays[5] = 30;
$mdays[6] = 31;
$mdays[7] = 31;
$mdays[8] = 30;
$mdays[9] = 31;
$mdays[10] = 30;
$mdays[11] = 31;

$firstday = 0;	# 1st Jan 1900 was a monday..

# copied from GNU C library time.h 
sub __isleap ($) {
	my $year = shift;
	return(($year) % 4 == 0 && (($year) % 100 != 0 || ($year) % 400 == 0));
}


# like the c localtime(3) function except only works to the day level
sub miniptime {
	die "miniptime: not enough parameters" if(@_ < 1);
	my $day = shift;
	my ($mday,$mon,$year,$wday,$yday);
	my ($d,$daysinyear,$daysinmon);

	$d = 0;
	$year = 0;
	while($d <= $day) {
		if(__isleap $year++) {
			$daysinyear = 366;
		} else {
			$daysinyear = 365;
		}
		$d += $daysinyear;
	}
	$d -= $daysinyear;
	$year--;
	$yday = $day - $d;

	$mon = 0;
	while($d <= $day) {
		if($mon == 1 && __isleap $year) {
			$daysinmon = 29;
		} else {
			$daysinmon = $mdays[$mon];
		}
		$d += $daysinmon;
		$mon++;
	}
	$d -= $daysinmon;
	$mon--;
	$mday = $day - $d + 1;

	$wday = ($day + $firstday) % 7;

	return($mday,$mon,$year,$wday,$yday);
}


sub daystoyear {
	die "daystoyear: not enough parameters" if(@_ < 1);
	my $year = shift;
	my $yday = 0;

	for($y=0; $y<$year; $y++) {
		if(__isleap $y) {
			$yday += 366;
		} else {
			$yday += 365;
		}
	}
	return($yday);
}


sub daystomonth {
	die "daystomonth: not enough parameters" if(@_ != 2);
	my ($mon,$year) = @_;
	my $yday = 0;

	for($m=0; $m<$mon; $m++) {
		$yday += $mdays[$m];
		$yday++ if($m == 1 && __isleap($year));
	}
	return($yday);
}


# return the number of days since january 1 1900
sub parsedate {
	my $datestr = shift or die "parsedate: not enough parameters";

	if($datestr =~ /^([0-9]*)-([A-Za-z]*)-([0-9]*)$/) {
		my ($mday,$month,$year,$yday,$mon);
		$mday = $1;
		$month = $2;
		$year = $3;
		$year -= 1900 if($year > 1000);

		for($m=0;$m<12;$m++) {
			if($monthstr[$m] =~ /$month/i) {
				$mon = $m;
				$yday = $mday + daystomonth($mon,$year) - 1;
				last;
			}
		}
		if($mday > ($mdays[$mon]+($mon==1&&__isleap($year))) || $m == 12) {
			return(-1,"");
		}

		$yday += daystoyear($year);
		$year += 1900;
		return($yday,"$mday-$monthstr[$mon]-$year");
	}
}


# return week containing day
sub getweek {
	die "getweek: not enough parameters" if(@_ < 1);
	my $day = shift;
	my ($sday,$eday,$sstr,$estr);
	
	my ($mday,$mon,$year,$wday,$yday) = miniptime($day);
	$sday = $day - $wday;
	$eday = $sday + 6;
	
	($mday,$mon,$year,$wday,$yday) = miniptime($sday);
	$sstr = "$mday-$monthstr[$mon]-".($year+1900);

	($mday,$mon,$year,$wday,$yday) = miniptime($eday);
	$estr = "$mday-$monthstr[$mon]-".($year+1900);

	return($sday,"$sstr - $estr");
}


# return month containing day
sub getmonth {
	die "getmonth: not enough parameters" if(@_ < 1);
	my $day = shift;
	my $sday,$str,$days;
	
	my ($mday,$mon,$year,$wday,$yday) = miniptime($day);
	$sday = $day - $mday + 1;
	$str = "$monthstr[$mon] $year";
	$days = $mdays[$mon];
	$days++ if($mon == 1 && __isleap($year));
	return($sday,$days,$str);
}


# return current day as number of days since jan 1 1900
sub getday {
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
		localtime(time);

	$yday += daystoyear($year);
	$year += 1900;
	$str = "$mday-$monthstr[$mon]-$year";
	return($yday,$str);
}

1;

# test things
# print getday."\n";
# print join(' ',miniptime(0))."\n";
# print join(' ',miniptime(365))."\n";
# print join(' ',miniptime(366))."\n";
# print join(' ',miniptime(parsedate("1-jan-1950")))."\n";
# print join(' ',miniptime(36035))."\n";
# print parsedate("1-Jan-1999")."\n";
# print "--\n";
# print getweek(getday)."\n";
# print "1: ".getweek(parsedate("1-sep-1997"))."\n";
# print "2: ".getweek(parsedate("2-sep-1997"))."\n";
# print "3: ".getweek(parsedate("3-sep-1997"))."\n";
# print "4: ".getweek(parsedate("4-sep-1997"))."\n";
# print "5: ".getweek(parsedate("5-sep-1997"))."\n";
# print "6: ".getweek(parsedate("6-sep-1997"))."\n";
# print "7: ".getweek(parsedate("7-sep-1997"))."\n";
# print "8: ".getweek(parsedate("8-sep-1997"))."\n";
# print "9: ".getweek(parsedate("9-sep-1997"))."\n";
# print "10: ".getweek(parsedate("10-sep-1997"))."\n";
# print "11: ".getweek(parsedate("11-sep-1997"))."\n";
# @test = getmonth(parsedate("2-may-1997"));
# @test2 = parsedate("1-may-1997");
# print "2/5/1997: ".join(':',@test)." == ".join(':',@test2)."\n";
# @test = getmonth(parsedate("31-aug-1997"));
# @test2 = parsedate("1-aug-1997");
# print "31/8/1997: ".join(':',@test)." == ".join(':',@test2)."\n";
# @test = getmonth(parsedate("29-feb-1996"));
# @test2 = parsedate("1-feb-1996");
# print "29/2/1996: ".join(':',@test)." == ".join(':',@test2)."\n";
# 
# print "\n";
# for($i=0; $i<100; $i++) { printf "%i",__isleap($i) };
# print "\n";
# for($i=80; $i<100; $i++) {
# 	print "year: $i -> " . daystoyear($i) . "\n";
# }
# for($i=30000; $i<40000; $i++) {
# 	my ($mday,$mon,$year,$wday,$yday) = miniptime($i);
# 	$str = sprintf("%02i-%s-%i",$mday,$monthstr[$mon],$year);
# 	($foo,$bar) = parsedate($str);
# 	print "$i: $str - $mday:$mon:$year:$wday:$yday - $foo:$bar\n";
# }
