/*              Mauro Javier De Gennaro <mauro@minter.com.ar>           */

/* user_manager.c <2.0> - User Manager Main module */

#include <stdio.h> 
#include <string.h>
#include <stdlib.h>
#include "visualadmin.h"

user_tb *userlist=NULL;
int nusers=0;

void user_list(int a);
void sort_users();
void save_passwd();
void pass_chk(int num,  char *ptmp);
int islower(char *w1, char *w2);

void user_list(int a) {
char buf[1024], temp[150], *s, *e, *salt;
int b=0,c=0,i=0,unew=0,chp=0, r, r1, r2;
#ifdef SHADOW_PASSWD
int month, year, day, days[13]={0,31,28,31,30,31,30,31,31,30,31,30,31};
int totaldays[13]={0,0,31,59,90,120,151,181,212,243,273,304,334};
long today;
#endif
FILE *passwd_fp;
#ifdef SHADOW_PASSWD
FILE *shadow_fp;
shadow_fp=fopen(F_SHADOW, "r");
#endif
passwd_fp=fopen(F_PASSWD, "r");
if(!passwd_fp) critical("Error opening passwd file");
#ifdef SHADOW_PASSWD
if(!shadow_fp) critical("Error opening shadow passwd file");
#endif
while(fgets(buf, sizeof(buf), passwd_fp)) 
	if(!(buf[0]=='#' || buf[0]==';')) 
		nusers++;
rewind(passwd_fp);
userlist=malloc((nusers+3)*sizeof(user_tb));
if(userlist==NULL) critical("Error in malloc()");
while(fgets(buf, sizeof(buf), passwd_fp)) {
	if(buf[0]=='#' || buf[0]==';') continue;
	c++;
	userlist[c].active=1;
	s=buf;
	e=index(s,':');
	if(!e) critical("Error processing passwd file: incorrect format.");
	strncpy(userlist[c].user,s,e-s);
	userlist[c].user[e-s]='\0';
	s=e+1;
	e=index(s,':');
	if(!e) critical("Error processing passwd file: incorrect format.");
	strncpy(userlist[c].pass,s,e-s);
	userlist[c].pass[e-s]='\0';
	s=e+1;
	e=index(s,':');
	if(!e) critical("Error processing passwd file: incorrect format.");
	strncpy(temp,s,e-s);
	temp[e-s]='\0';
	userlist[c].uid=atoi(temp);
	s=e+1;
	e=index(s,':');
	if(!e) critical("Error processing passwd file: incorrect format.");
	strncpy(temp,s,e-s);
	temp[e-s]='\0';
	userlist[c].gid=atoi(temp);
	s=e+1;
	e=index(s,':');
	if(!e) critical("Error processing passwd file: incorrect format.");
	strncpy(temp,s,e-s);
	temp[e-s]='\0';
	for(i=0;i<=strlen(temp);i++)
		if(i<=54)
			userlist[c].gecos[i]=temp[i];
		else { userlist[c].gecos[i]='\0'; i=strlen(temp)+1; }
	s=e+1;
	e=index(s,':');
	if(!e) critical("Error processing passwd file: incorrect format.");
	strncpy(userlist[c].home,s,e-s);
	userlist[c].home[e-s]='\0';
	s=e+1;
	e=index(s,'\n');
	if(!e) e=index(s,'\0');
	if(!e) critical("Error processing passwd file: incorrect format.");
	strncpy(userlist[c].shell,s,e-s);
	userlist[c].shell[e-s]='\0';
}
fclose(passwd_fp);
#ifdef SHADOW_PASSWD
while(fgets(buf, sizeof(buf), shadow_fp)) {
	if(buf[0]=='#' || buf[0]==';') continue;
	s=buf;
	e=index(s,':');
	if(!e) critical("Error processing shadow passwd file: incorrect format.");
	strncpy(temp,s,e-s);
	temp[e-s]='\0'; c=0;
	for(i=1;i<=nusers;i++) if(!strcmp(userlist[i].user, temp)) c=i;	
	s=e+1;
	e=index(s,':');
	if(!e) critical("Error processing shadow passwd file: incorrect format.");
	strncpy(userlist[c].pass,s,e-s);
	userlist[c].pass[e-s]='\0';
	s=e+1;
	e=index(s,':');
	if(!e) critical("Error processing shadow passwd file: incorrect format.");
	strncpy(userlist[c].lastch,s,e-s);
	userlist[c].lastch[e-s]='\0';
	s=e+1;
	e=index(s,':');
	if(!e) critical("Error processing shadow passwd file: incorrect format.");
	strncpy(userlist[c].min,s,e-s);
	userlist[c].min[e-s]='\0';
	s=e+1;
	e=index(s,':');
	if(!e) critical("Error processing shadow passwd file: incorrect format.");
	strncpy(userlist[c].max,s,e-s);
	userlist[c].max[e-s]='\0';
	s=e+1;
	e=index(s,':');
	if(!e) critical("Error processing shadow passwd file: incorrect format.");
	strncpy(userlist[c].warn,s,e-s);
	userlist[c].warn[e-s]='\0';
	s=e+1;
	e=index(s,':');
	if(!e) critical("Error processing shadow passwd file: incorrect format.");
	strncpy(userlist[c].inact,s,e-s);
	userlist[c].inact[e-s]='\0';
	s=e+1;
	e=index(s,':');
	if(!e) critical("Error processing shadow passwd file: incorrect format.");
	strncpy(userlist[c].expire,s,e-s);
	userlist[c].expire[e-s]='\0';
	s=e+1;
	e=index(s,'\n');
	if(!e) e=index(s,'\0');
	if(!e) critical("Error processing shadow passwd file: incorrect format.");
	strncpy(userlist[c].flag,s,e-s);
	userlist[c].flag[e-s]='\0';
}
fclose(shadow_fp);
#endif
if(sortpass) sort_users();
switch(a) {
	case 0:
		view_userlist();
	case 1:
		s=data;
		c=1;
		while(c) {
			e=strstr(s,"usr=");
			if(!e) {
				c=0;
				continue;
			}
			s=e+4;
			e=index(s,'&');
			if(!e) {
				c=0;
				continue;
			}
			strncpy(temp,s,e-s);
			temp[e-s]='\0';
			s=e+1;
			userlist[atoi(temp)].active=0;
		}
		save_passwd();
		view_userlist();
		break;
	case 2:
		c=0;
		strcpy(temp,"");
		get_var(data, temp, "num=");
		c=atoi(temp);
		if(!c) critical("Error getting target user ID");
		view_useredit(c);
		break;	
	case 3:
		c=0;
		strcpy(temp,"");
		get_var(data, temp, "unum=");
		c=atoi(temp);
		if(strstr(data,"cancel=") != NULL) {
			if(c) 
				view_userlist();
			else
				view_menu();
		}
		if(!c) { unew=1; nusers++; c=nusers; }
		get_var(data, temp, "login=");
		if(strlen(temp)<=1) critical("Username field must be completed.");
		if(strlen(temp)>13) critical("Username too long. (max 10 chars)");
		for(i=1;i<=nusers;i++) 
			if(!strcmp(userlist[i].user, temp) && c!=i)
				critical("Username already exists on the system.");
		strcpy(userlist[c].user, temp);
		get_var(data,userlist[c].gecos,"gecos=");
		if(strlen(userlist[c].gecos)<=1)
			critical("Gecos field must be completed.");
		get_var(data, temp, "passwd=");
		if(strlen(temp)>1) chp=1;
		srand(time(0));
		for(i=0; i <= 1; i++) {
		    r = rand();
		    r = r & 127;
		    if (r < 46) r += 46;
		    if (r > 57 && r < 65) r += 7;
		    if (r > 90 && r < 97) r += 6;
		    if (r > 122) r -= 5;
		    if (i) r2 = r; else r1 = r;
		}
		sprintf(buf, "%c%c", r1, r2);
		salt = buf;
		if(strstr(data,"lockpass=") != NULL) i=1; else i=0;
		switch(i) {
			case 1:
				switch(unew) {
					case 1:
						if(strlen(temp)<=1)
							strcpy(userlist[c].pass, "*");
						else
							{ pass_chk(c,temp); sprintf(userlist[c].pass, "*%s", (char *)crypt(temp,salt));}
						break;
					case 0:
						if(strlen(temp)<=1) { 
							if(userlist[c].pass[0]!='*') {
								strcpy(temp, userlist[c].pass);
								sprintf(userlist[c].pass,"*%s",temp);
							}
						} else
							{ pass_chk(c,temp); sprintf(userlist[c].pass, "*%s", (char *)crypt(temp,salt));}
						break;
					default:
						break;
				}
				break;
			case 0:
				switch(unew) {
					case 1:
						if(strlen(temp)<=1)
							critical("Password Field must be completed.");
						else
							{ pass_chk(c,temp); sprintf(userlist[c].pass, "%s", (char *)crypt(temp,salt));}
						break;
					case 0:
						if(strlen(temp)<=1) { 
							if(userlist[c].pass[0]=='*') {
								strcpy(temp, userlist[c].pass);
								strcpy(userlist[c].pass, "");
								for(b=1;b<=strlen(temp);b++)
									userlist[c].pass[b-1]=temp[b];
							}
						} else 
							{ pass_chk(c,temp); sprintf(userlist[c].pass, "%s", (char *)crypt(temp,salt));}
						break;
					default:
						break;
				}
				break;
			default:
				break;
		}
		get_var(data,userlist[c].shell, "shell=");
		if(!strcmp(userlist[c].shell,"none") || strlen(userlist[c].shell)<=1)
			critical("A Shell must be selected");
		get_var(data,temp,"gid=");
		if(!strcmp(temp,"none"))
			critical("A Group ID must be selected");
		userlist[c].gid=atoi(temp);
		get_var(data,temp,"uid=");
		if(strlen(temp)<1)
			critical("UID field must be completed.");
		b=atoi(temp);
		for(i=1;i<=nusers;i++)
			if(b==userlist[i].uid && i!=c)
				critical("UID already exists");
		userlist[c].uid=b;
		get_var(data,userlist[c].home,"home=");
		if(unew&strlen(userlist[c].home)>1&access(userlist[c].home,0) != 0) {
			mkdir(userlist[c].home, 0755);
			chown(userlist[c].home, userlist[c].uid, userlist[c].gid);
		}
		userlist[c].active=1;
#ifdef SHADOW_PASSWD
		if(chp) {
			(void)time(&today);
			today/=86400L;
			sprintf(userlist[c].lastch, "%d", today);
		}
		get_var(data,userlist[c].min,"mindays=");
		get_var(data,userlist[c].max,"maxdays=");
		get_var(data,userlist[c].warn,"warndays=");
		get_var(data,userlist[c].inact,"inactdays=");
		if(strstr(userlist[c].warn,"-1") != NULL) strcpy(userlist[c].warn,"");
		if(strstr(userlist[c].inact,"-1") != NULL) strcpy(userlist[c].inact,"");
		get_var(data,buf,"expdate=");
		if(strlen(buf)>5) {
			s=buf;
			e=index(s,'/');
			if(!e) critical("Incorrect expiration date format");
			strncpy(temp,s,e-s);
			temp[e-s]='\0';
			switch(dispmode) {
				case 1: day=atoi(temp); break;
				case 2:	month=atoi(temp); break;
				case 3:	year=atoi(temp); break; }
			s=e+1;
			e=index(s,'/');
			if(!e) critical("Incorrect expiration date format");
			strncpy(temp,s,e-s);
			temp[e-s]='\0';
			switch(dispmode) {
				case 1: month=atoi(temp); break;
				case 2:	day=atoi(temp); break;
				case 3:	month=atoi(temp); break; }
			s=e+1;
			e=index(s,'\0');
			if(!e) critical("Incorrect expiration date format");
			strncpy(temp,s,e-s);
			temp[e-s]='\0';
			switch(dispmode) {
				case 1: year=atoi(temp); break;
				case 2:	year=atoi(temp); break;
				case 3:	day=atoi(temp); break; }
			if((month<1)||(month>12)) critical("Incorrect month number");
			if((day<1)||((month!=2||(year%4)!=0)&&day>days[month])||((month==2&&(year%4)==0)&&day>29)) critical ("Incorrect day number");
			if(year<0) critical("Incorrect year number");
			if(year<=69)year+=2000; else if(year<=99)year+=1900;
			if(year<1970||year>2069) critical("Incorrect year number");
			sprintf(userlist[c].expire,"%d",(long)(((year-1970)*365L)+(((year+1)-1970)/4)+totaldays[month]+(month>2&&(year%4)==0?1:0)+day-1));
		}
#endif
		if(sortpass) sort_users();
		save_passwd();
		if(unew) 
			view_menu();
		else
			view_userlist();
		break;
	case 4:
		view_useredit(0);
		break;
	default:
		critical("Illegal data.");
}

}

void pass_chk(int num,  char *ptmp) {
char utmp[15],gtmp[55],p2tmp[25];
int a,b;
strcpy(p2tmp,ptmp);
strcpy(utmp,userlist[num].user);
strcpy(gtmp,userlist[num].gecos);
strlow(utmp); strlow(gtmp); strlow(p2tmp);
if(strstr(gtmp, p2tmp) != NULL ||
   strstr(utmp, p2tmp) != NULL ||
   strstr(p2tmp, gtmp) != NULL ||
   strstr(p2tmp, utmp) != NULL)
   	critical("Security Error: Password too easy to crack.");
for(a=strlen(ptmp)-1,b=0;a>=0;a--,b++) p2tmp[b]=ptmp[a];
p2tmp[b]='\0';
strlow(p2tmp);
if(strstr(gtmp, p2tmp) != NULL ||
   strstr(utmp, p2tmp) != NULL ||
   strstr(p2tmp, gtmp) != NULL ||
   strstr(p2tmp, utmp) != NULL)
   	critical("Security Error: Password easy to crack.");
}

void save_passwd() {
int c=1;
FILE *passwd_fp;
#ifdef SHADOW_PASSWD
FILE *shadow_fp;
#endif

passwd_fp=fopen(F_PASSWD, "w");
if(!passwd_fp) critical("Error opening passwd file for writing");
for(c=1;c<=nusers;c++)
	if(userlist[c].active)
#ifdef SHADOW_PASSWD
		fprintf(passwd_fp, "%s:x:%d:%d:%s:%s:%s\n", userlist[c].user, userlist[c].uid, userlist[c].gid, userlist[c].gecos, userlist[c].home, userlist[c].shell);
#else
		fprintf(passwd_fp, "%s:%s:%d:%d:%s:%s:%s\n", userlist[c].user, userlist[c].pass, userlist[c].uid, userlist[c].gid, userlist[c].gecos, userlist[c].home, userlist[c].shell);
#endif
fclose(passwd_fp);
#ifdef SHADOW_PASSWD
shadow_fp=fopen(F_SHADOW, "w");
if(!shadow_fp) critical("Error opening passwd file for writing");
for(c=1;c<=nusers;c++)
	if(userlist[c].active)
		fprintf(shadow_fp, "%s:%s:%s:%s:%s:%s:%s:%s:%s\n", userlist[c].user, userlist[c].pass, userlist[c].lastch, userlist[c].min, userlist[c].max, userlist[c].warn, userlist[c].inact, userlist[c].expire, userlist[c].flag);
fclose(shadow_fp);
#endif


}

void sort_users() {
char aux[15], auxd[55];
int i,k,auxn;

for(k=1; k<=(nusers-1); k++) {
	for(i=1; i<=(nusers-1); i++) {
		if(islower(userlist[i+1].user, userlist[i].user)) {
			strcpy(aux, userlist[i+1].user);
			strcpy(userlist[i+1].user, userlist[i].user);
			strcpy(userlist[i].user, aux);

			strcpy(aux, userlist[i+1].pass);
			strcpy(userlist[i+1].pass, userlist[i].pass);
			strcpy(userlist[i].pass, aux);

			strcpy(auxd, userlist[i+1].shell);
			strcpy(userlist[i+1].shell, userlist[i].shell);
			strcpy(userlist[i].shell, auxd);

			strcpy(auxd, userlist[i+1].gecos);
			strcpy(userlist[i+1].gecos, userlist[i].gecos);
			strcpy(userlist[i].gecos, auxd);

			strcpy(auxd, userlist[i+1].home);
			strcpy(userlist[i+1].home, userlist[i].home);
			strcpy(userlist[i].home, auxd);

			auxn=userlist[i+1].uid;
			userlist[i+1].uid=userlist[i].uid;
			userlist[i].uid=auxn;

			auxn=userlist[i+1].gid;
			userlist[i+1].gid=userlist[i].gid;
			userlist[i].gid=auxn;
#ifdef SHADOW_PASSWD
			strcpy(auxd, userlist[i+1].lastch);
			strcpy(userlist[i+1].lastch, userlist[i].lastch);
			strcpy(userlist[i].lastch, auxd);

			strcpy(auxd, userlist[i+1].min);
			strcpy(userlist[i+1].min, userlist[i].min);
			strcpy(userlist[i].min, auxd);

			strcpy(auxd, userlist[i+1].max);
			strcpy(userlist[i+1].max, userlist[i].max);
			strcpy(userlist[i].max, auxd);

			strcpy(auxd, userlist[i+1].warn);
			strcpy(userlist[i+1].warn, userlist[i].warn);
			strcpy(userlist[i].warn, auxd);

			strcpy(auxd, userlist[i+1].inact);
			strcpy(userlist[i+1].inact, userlist[i].inact);
			strcpy(userlist[i].inact, auxd);

			strcpy(auxd, userlist[i+1].expire);
			strcpy(userlist[i+1].expire, userlist[i].expire);
			strcpy(userlist[i].expire, auxd);

			strcpy(auxd, userlist[i+1].flag);
			strcpy(userlist[i+1].flag, userlist[i].flag);
			strcpy(userlist[i].flag, auxd);
#endif
		}	
	}
}
return;
}

int islower(char *w1, char *w2) {
int i=0;
for (i=0;i<14;i++) {
	if(w1[i]>w2[i]) return(0);
	if(w1[i]<w2[i]) return(1);
}
return(0);
}


