/*            Mauro Javier De Gennaro <mauro@minter.com.ar>          */ 

/* readconf.c <2.0> - Reads visualadmin's configuration file */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "visualadmin.h"

file_tb *filelist=NULL;

void readconf();
void createconf();
void removesp(char *src);

void readconf() {
FILE *conf_fp;
int c=0;
char buf[1024],*s,*e,aux[10];
conf_fp=fopen(CONF_FILE,"r");
if(!conf_fp) {
	createconf();
	conf_fp=fopen(CONF_FILE,"r");
	if(!conf_fp) critical("Unable to open configuration file");
}
filelist=malloc(22*sizeof(file_tb));
if(filelist==NULL) critical("Can't malloc()");
strcpy(filelist[0].file," ");
#ifdef SHADOW_PASSWD
strcpy(F_SHADOW,"none");
#endif
strcpy(F_PASSWD,"none");
strcpy(F_SHELLS,"none");
strcpy(F_GROUP,"none");
strcpy(F_NAMED,"none");
strcpy(F_LDEFS,"none");
strcpy(D_HOME,"none");
strcpy(CRIPT_KEY,"MySecretKey");
sortpass=1;
while(fgets(buf,sizeof(buf),conf_fp)) {
	s=buf;
	switch(buf[0]) {
		case '#':
		case ';':
		case '[':
			break;
		case 'f':
			s=buf;
			c=0;
			while(filelist[c].file[0]!=' '&&c<20)c++;
			e=index(s,'=');
			if(!e) critical("Error processing config file");
			s=e+1;
			e=index(s,',');
			if(!e) critical("Error processing config file");
			strncpy(filelist[c].file,s,e-s);
			filelist[c].file[e-s]='\0';
			s=e+1;
			e=index(s,'\n');
			if(!e) critical("Error processing config file");
			strncpy(filelist[c].desc,s,e-s);
			filelist[c].desc[e-s]='\0';
			removesp(filelist[c].file);
			strcpy(filelist[c+1].file, " ");
			break;
		case 'h':
			e=index(s,'=');
			if(!e) critical("Error processing config file");
			s=e+1;
			e=index(s,'\n');
			if(!e) critical("Error processing config file");
			strncpy(D_HOME,s,e-s);
			D_HOME[e-s]='\0';
			if(D_HOME[strlen(D_HOME)-1]=='/') D_HOME[strlen(D_HOME)-1]='\0';
			removesp(D_HOME);
			break;
		case 'g':
			e=index(s,'=');
			if(!e) critical("Error processing config file");
			s=e+1;
			e=index(s,'\n');
			if(!e) critical("Error processing config file");
			strncpy(F_GROUP,s,e-s);
			F_GROUP[e-s]='\0';
			removesp(F_GROUP);
			break;
		case 'l':
			e=index(s,'=');
			if(!e) critical("Error processing config file");
			s=e+1;
			e=index(s,'\n');
			if(!e) critical("Error processing config file");
			strncpy(F_LDEFS,s,e-s);
			F_LDEFS[e-s]='\0';
			removesp(F_LDEFS);
			break;
		case 'p':
			e=index(s,'=');
			if(!e) critical("Error processing config file");
			s=e+1;
			e=index(s,'\n');
			if(!e) critical("Error processing config file");
			strncpy(F_PASSWD,s,e-s);
			F_PASSWD[e-s]='\0';
			removesp(F_PASSWD);
			break;
		case 's':
			switch(buf[2]) {
				case 'r':
					if(strstr(buf,"no") != NULL)
						sortpass=0;
					break;
				case 'e':
					e=index(s,'=');
					if(!e) critical("Error processing config file");
					s=e+1;
					e=index(s,'\n');
					if(!e) critical("Error processing config file");
					strncpy(F_SHELLS,s,e-s);
					F_SHELLS[e-s]='\0';
					removesp(F_SHELLS);
					break;
#ifdef SHADOW_PASSWD
				case 'a':
					e=index(s,'=');
					if(!e) critical("Error processing config file");
					s=e+1;
					e=index(s,'\n');
					if(!e) critical("Error processing config file");
					strncpy(F_SHADOW,s,e-s);
					F_SHADOW[e-s]='\0';
					removesp(F_SHADOW);
					break;
#endif
				default:
					break;
			}
			break;
		case 'c':
			e=index(s,'=');
			if(!e) critical("Error processing config file");
			s=e+1;
			e=index(s,'\n');
			if(!e) critical("Error processing config file");
			strncpy(CRIPT_KEY,s,e-s);
			CRIPT_KEY[e-s]='\0';
			removesp(CRIPT_KEY);
			break;
		case 'b':
			e=index(s,'=');
			if(!e) critical("Error processing config file");
			s=e+1;
			e=index(s,'\n');
			if(!e) critical("Error processing config file");
			strncpy(F_NAMED,s,e-s);
			F_NAMED[e-s]='\0';
			removesp(F_NAMED);
			break;
#ifdef SHADOW_PASSWD
		case 'd':
			e=index(s,'=');
			if(!e) critical("Error processing config file");
			s=e+1;
			e=index(s,'\n');
			if(!e) critical("Error processing config file");
			strncpy(aux,s,e-s);
			aux[e-s]='\0';
			dispmode=1;
			strlow(aux);
			if(strstr(aux,"mdy") != NULL) dispmode=2;
			if(strstr(aux,"ymd") != NULL) dispmode=3;
			break;
#endif
		default:
			break;			
	}
}
fclose(conf_fp);

if(!strcmp(F_PASSWD,"none")) critical("You must specify a passwd file.");
if(!strcmp(F_NAMED,"none")) critical("You must specify a named boot file.");
if(!strcmp(D_HOME,"none")) critical("You must specify a home directory.");
#ifdef SHADOW_PASSWD
if(!strcmp(F_SHADOW,"none")) critical("You must specify a shadow passwd file.");
#endif

}

void removesp(char *src) {
char aux[50];
int i,k=0;

strcpy(aux,src);
for(i=0;i<=strlen(aux);i++)
	if(aux[i]!=' ') src[k++]=aux[i];

}

void createconf() {
int ifp;
FILE *fp;
if ((ifp = open (CONF_FILE, O_WRONLY|O_CREAT|O_EXCL, 0600)) < 0 ||
   !(fp = fdopen (ifp, "w"))) critical("Can't create config file");
fprintf(fp,"# Visual Admin 2.0 Configuration File </etc/visualadmin.conf>\n");
fprintf(fp,"# Mauro J. De Gennaro <mauro@minter.com.ar>\n");
fprintf(fp,"#-----------------------------------------------------------------\n");
fprintf(fp,"# Note: options with (*) must appear in config file.\n");
fprintf(fp,"#       options with (+) must appear in config file if you\n");
fprintf(fp,"#       have shadow passwords.   \n");
fprintf(fp,"#-----------------------------------------------------------------\n");
fprintf(fp,"\n");
fprintf(fp,"[files]\n");
fprintf(fp,"# Location of passwd file (*)\n");
fprintf(fp,"passwd=/etc/passwd\n");
fprintf(fp,"# Location of shadow password file (+)\n");
fprintf(fp,"shadow=/etc/shadow\n");
fprintf(fp,"# Location of shells file (*)\n");
fprintf(fp,"shells=/etc/shells\n");
fprintf(fp,"# Location of group file (*)\n");
fprintf(fp,"group=/etc/group\n");
fprintf(fp,"# Location of Login Defaults File (+)\n");
fprintf(fp,"logindefs=/etc/login.defs\n");
fprintf(fp,"# Location of Named Boot File (*)\n");
fprintf(fp,"bootn=/etc/named.boot\n");
fprintf(fp,"\n");
fprintf(fp,"[file_editor]\n");
fprintf(fp,"# Specify here system files to be edited from the web (max. 20 files)\n");
fprintf(fp,"# The format is:\n");
fprintf(fp,"#       file=<path_to_file>,<description>\n");
fprintf(fp,"# Where:\n");
fprintf(fp,"#       <path_to_file> - location of the file\n");
fprintf(fp,"#       <description> - description of the file <max 20 chars>\n");
fprintf(fp,"#\n");
fprintf(fp,"file=/etc/hosts,Hosts Table\n");
fprintf(fp,"file=/etc/networks,Networks Table\n");
fprintf(fp,"file=/etc/aliases,Mail Aliases\n");
fprintf(fp,"file=/etc/shells,Shells File\n");
fprintf(fp,"file=/etc/group,Group File\n");
fprintf(fp,"file=/etc/exports,Exports File\n");
fprintf(fp,"\n");
fprintf(fp,"[directory]\n");
fprintf(fp,"# Location of Home Directory (*)\n");
fprintf(fp,"home=/home\n");
fprintf(fp,"\n");
fprintf(fp,"[switches]\n");
fprintf(fp,"# Select 'yes' to sort passwd file (default is yes)\n");
fprintf(fp,"sort_users=yes\n");
fprintf(fp,"# Password Crypting Key (max. 15 chars) (default is MySecretKey)\n");
fprintf(fp,"cryptkey=MySecretKey\n");
fprintf(fp,"# Date display modes (+)\n");
fprintf(fp,"# Valid modes:\n");
fprintf(fp,"#  dmy - dd/mm/yy\n");
fprintf(fp,"#  mdy - mm/dd/yy\n");
fprintf(fp,"#  ymd - yy/mm/dd\n");
fprintf(fp,"date_display=mdy\n");
fprintf(fp,"\n");
fprintf(fp,"# End of Config file\n");
fclose(fp);
}